/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.wsrp;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.ChannelFactory;
import org.jasig.portal.ChannelParameter;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.ChannelRendererFactory;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IChannel;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.IChannelRenderer;
import org.jasig.portal.IChannelRendererFactory;
import org.jasig.portal.MediaManager;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.serialize.BaseMarkupSerializer;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.AbsoluteURLFilter;
import org.jasig.portal.wsrp.types.AccessDeniedFault;
import org.jasig.portal.wsrp.types.InteractionParams;
import org.jasig.portal.wsrp.types.InvalidHandleFault;
import org.jasig.portal.wsrp.types.MarkupParams;
import org.jasig.portal.wsrp.types.NamedString;
import org.jasig.portal.wsrp.types.OperationFailedFault;
import org.jasig.portal.wsrp.types.RuntimeContext;
import org.jasig.portal.wsrp.types.UserContext;
import tyrex.naming.MemoryContext;

public class ChannelInstanceManager {
    private IChannel channel;
    private ChannelDefinition channelDef;
    private ChannelRuntimeData runtimeData;
    private IPerson person;
    private static final IChannelRegistryStore channelRegistryStore = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
    protected static final Random randomNumberGenerator = new Random();
    private static final IChannelRendererFactory channelRendererFactory = ChannelRendererFactory.newInstance((class$org$jasig$portal$wsrp$ChannelInstanceManager == null ? (class$org$jasig$portal$wsrp$ChannelInstanceManager = ChannelInstanceManager.class$("org.jasig.portal.wsrp.ChannelInstanceManager")) : class$org$jasig$portal$wsrp$ChannelInstanceManager).getName());
    protected static String baseUrl;
    static /* synthetic */ Class class$org$jasig$portal$wsrp$ChannelInstanceManager;

    public ChannelInstanceManager(String portletHandle, String sessionId, UserContext userContext) throws Exception {
        this.person = this.getPerson(userContext);
        this.channelDef = this.getChannelDefinition(portletHandle);
        this.channel = this.getChannel(sessionId, this.channelDef);
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public void setChannelRuntimeData(RuntimeContext runtimeContext, MarkupParams markupParams, InteractionParams interactionParams) throws PortalException {
        this.runtimeData = new ChannelRuntimeData();
        this.runtimeData.setBaseActionURL(runtimeContext.getTemplates().getRenderTemplate());
        String userAgent = markupParams.getClientData().getUserAgent();
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("user-agent", userAgent);
        this.runtimeData.setBrowserInfo(new BrowserInfo(new Cookie[0], headers));
        this.runtimeData.setHttpRequestMethod("GET");
        this.runtimeData.setLocales(null);
        if (interactionParams != null) {
            NamedString[] formParams = interactionParams.getFormParameters();
            for (int i = 0; i < formParams.length; ++i) {
                NamedString formParam = formParams[i];
                this.runtimeData.setParameter(formParam.getName(), formParam.getValue());
            }
        }
    }

    public String getChannelMarkup(RuntimeContext runtimeContext, MarkupParams markupParams) throws Throwable {
        String mode;
        if (this.runtimeData == null) {
            this.setChannelRuntimeData(runtimeContext, markupParams, null);
        }
        if ((mode = markupParams.getMode()).equals("wsrp:help")) {
            this.channel.receiveEvent(new PortalEvent(4));
        } else if (mode.equals("wsrp:edit")) {
            this.channel.receiveEvent(new PortalEvent(3));
        } else if (mode.equals("up_about")) {
            this.channel.receiveEvent(new PortalEvent(5));
        }
        IChannelRenderer cr = channelRendererFactory.newInstance(this.channel, this.runtimeData);
        cr.setTimeout(this.channelDef.getTimeout());
        cr.startRendering();
        StringWriter sw = new StringWriter();
        MediaManager mm = new MediaManager();
        BaseMarkupSerializer markupSerializer = mm.getSerializerByName("XHTML", sw);
        markupSerializer.asContentHandler();
        String media = mm.getMedia(this.runtimeData.getBrowserInfo());
        String mimeType = mm.getReturnMimeType(media);
        String baseUrl = ChannelInstanceManager.getBaseUrl();
        AbsoluteURLFilter urlFilter = AbsoluteURLFilter.newAbsoluteURLFilter(mimeType, baseUrl, markupSerializer);
        int status = cr.outputRendering(urlFilter);
        if (status == 2) {
            LogService.log(LogService.DEBUG, this.channelDef.getFName() + " timed out");
            throw new OperationFailedFault();
        }
        this.runtimeData = null;
        return sw.toString();
    }

    protected ChannelDefinition getChannelDefinition(String portletHandle) throws Exception {
        ChannelDefinition channelDef = null;
        try {
            channelDef = channelRegistryStore.getChannelDefinition(portletHandle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (channelDef == null) {
            LogService.log(LogService.DEBUG, "Unable to find a channel with functional name '" + portletHandle + "'");
            throw new InvalidHandleFault();
        }
        return channelDef;
    }

    protected IChannel getChannel(String sessionId, ChannelDefinition channelDef) throws Exception {
        int channelPublishId;
        EntityIdentifier ei = this.person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        boolean authorized = ap.canSubscribe(channelPublishId = channelDef.getId());
        if (!authorized) {
            String message = "User [" + this.person.getAttribute("username") + "] is not authorized to access channel with functional name [" + channelDef.getFName() + "]";
            LogService.log(LogService.DEBUG, message);
            AccessDeniedFault accessDeniedFault = new AccessDeniedFault();
            accessDeniedFault.setFaultString(message);
            throw accessDeniedFault;
        }
        String javaClass = channelDef.getJavaClass();
        String instanceId = Long.toHexString(randomNumberGenerator.nextLong()) + "_" + System.currentTimeMillis();
        String uid = sessionId + "/" + instanceId;
        IChannel channel = ChannelFactory.instantiateChannel(javaClass, uid);
        ChannelStaticData staticData = new ChannelStaticData();
        staticData.setChannelPublishId(String.valueOf(channelPublishId));
        staticData.setPerson(this.person);
        staticData.setTimeout(channelDef.getTimeout());
        Hashtable<String, String> environment = new Hashtable<String, String>(1);
        environment.put("java.naming.factory.initial", "org.jasig.portal.jndi.PortalInitialContextFactory");
        InitialContext portalContext = new InitialContext(environment);
        MemoryContext channelContext = new MemoryContext(new Hashtable());
        Context servicesContext = (Context)portalContext.lookup("services");
        channelContext.bind("services", (Object)servicesContext);
        staticData.setJNDIContext((Context)channelContext);
        ChannelParameter[] channelParams = channelDef.getParameters();
        for (int i = 0; i < channelParams.length; ++i) {
            staticData.setParameter(channelParams[i].getName(), channelParams[i].getValue());
        }
        channel.setStaticData(staticData);
        return channel;
    }

    protected IPerson getPerson(UserContext userContext) throws PortalException {
        return PersonFactory.createGuestPerson();
    }

    protected static String getBaseUrl() {
        if (baseUrl == null) {
            MessageContext messageContext = MessageContext.getCurrentContext();
            HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            String protocol = request.getProtocol();
            String protocolFixed = protocol.substring(0, protocol.indexOf("/")).toLowerCase();
            String serverName = request.getServerName();
            int serverPort = request.getServerPort();
            String contextPath = request.getContextPath();
            baseUrl = protocolFixed + "://" + serverName + ":" + serverPort + contextPath + "/";
        }
        return baseUrl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

