/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.InvalidNamespaceConfigurationException;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceAccessTokenImpl;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.Uri;
import org.apache.slide.common.UriPath;
import org.apache.slide.content.ContentInterceptor;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.util.Messages;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;

public final class NamespaceConfig {
    public static final String NOBODY = "nobody";
    public static final String NOBODY_ROLE = (class$org$apache$slide$structure$ObjectNode == null ? (class$org$apache$slide$structure$ObjectNode = NamespaceConfig.class$("org.apache.slide.structure.ObjectNode")) : class$org$apache$slide$structure$ObjectNode).getName();
    public static final String BASE_ROLE = (class$org$apache$slide$structure$SubjectNode == null ? (class$org$apache$slide$structure$SubjectNode = NamespaceConfig.class$("org.apache.slide.structure.SubjectNode")) : class$org$apache$slide$structure$SubjectNode).getName();
    public static final String ACTION_ROLE = (class$org$apache$slide$structure$ActionNode == null ? (class$org$apache$slide$structure$ActionNode = NamespaceConfig.class$("org.apache.slide.structure.ActionNode")) : class$org$apache$slide$structure$ActionNode).getName();
    public static final String LINK_ROLE = (class$org$apache$slide$structure$LinkNode == null ? (class$org$apache$slide$structure$LinkNode = NamespaceConfig.class$("org.apache.slide.structure.LinkNode")) : class$org$apache$slide$structure$LinkNode).getName();
    private static final String ACL_INHERIT_TYPE = "acl_inheritance_type";
    private static final String NESTED_ROLES_MAXDEPTH = "nested_roles_maxdepth";
    private static final int NESTED_ROLES_MAXDEPTH_DEFAULT = 0;
    public static final int ACL_INHERIT_TYPE_NONE = 0;
    public static final int ACL_INHERIT_TYPE_ROOT = 1;
    public static final int ACL_INHERIT_TYPE_PATH = 2;
    public static final int ACL_INHERIT_TYPE_FULL = 3;
    protected String name;
    protected ActionNode readObjectAction;
    protected ActionNode createObjectAction;
    protected ActionNode removeObjectAction;
    protected ActionNode grantPermissionAction;
    protected ActionNode revokePermissionAction;
    protected ActionNode readPermissionsAction;
    protected ActionNode readOwnPermissionsAction;
    protected ActionNode lockObjectAction;
    protected ActionNode killLockAction;
    protected ActionNode readLocksAction;
    protected ActionNode createRevisionMetadataAction;
    protected ActionNode modifyRevisionMetadataAction;
    protected ActionNode removeRevisionMetadataAction;
    protected ActionNode readRevisionMetadataAction;
    protected ActionNode readRevisionContentAction;
    protected ActionNode createRevisionContentAction;
    protected ActionNode modifyRevisionContentAction;
    protected ActionNode removeRevisionContentAction;
    protected ActionNode bindMemberAction;
    protected ActionNode unbindMemberAction;
    protected String usersPath = null;
    protected String groupsPath = null;
    protected String rolesPath = null;
    private UriPath usersUriPath;
    private UriPath groupsUriPath;
    private UriPath rolesUriPath;
    protected String guestPath;
    protected String filesPath = null;
    protected String actionsPath = null;
    protected Hashtable parameters;
    protected Hashtable roleMappings = new Hashtable();
    protected Hashtable roleClassMappings = new Hashtable();
    protected Hashtable defaultProperties;
    protected static Vector emptyVector = new Vector();
    protected ContentInterceptor[] contentInterceptors = new ContentInterceptor[0];
    protected boolean autoCreateUsers = false;
    protected String autoCreateUsersRole = "slideroles.basic.UserRoleImpl";
    static /* synthetic */ Class class$org$apache$slide$structure$ObjectNode;
    static /* synthetic */ Class class$org$apache$slide$structure$SubjectNode;
    static /* synthetic */ Class class$org$apache$slide$structure$ActionNode;
    static /* synthetic */ Class class$org$apache$slide$structure$LinkNode;

    public ActionNode getDefaultAction() {
        return ActionNode.DEFAULT;
    }

    public ActionNode getReadObjectAction() {
        return this.readObjectAction;
    }

    public ActionNode getCreateObjectAction() {
        return this.createObjectAction;
    }

    public ActionNode getRemoveObjectAction() {
        return this.removeObjectAction;
    }

    public ActionNode getGrantPermissionAction() {
        return this.grantPermissionAction;
    }

    public ActionNode getRevokePermissionAction() {
        return this.revokePermissionAction;
    }

    public ActionNode getReadPermissionsAction() {
        return this.readPermissionsAction;
    }

    public ActionNode getReadOwnPermissionsAction() {
        return this.readOwnPermissionsAction;
    }

    public ActionNode getLockObjectAction() {
        return this.lockObjectAction;
    }

    public ActionNode getKillLockAction() {
        return this.killLockAction;
    }

    public ActionNode getReadLocksAction() {
        return this.readLocksAction;
    }

    public ActionNode getCreateRevisionMetadataAction() {
        return this.createRevisionMetadataAction;
    }

    public ActionNode getReadRevisionMetadataAction() {
        return this.readRevisionMetadataAction;
    }

    public ActionNode getModifyRevisionMetadataAction() {
        return this.modifyRevisionMetadataAction;
    }

    public ActionNode getRemoveRevisionMetadataAction() {
        return this.removeRevisionMetadataAction;
    }

    public ActionNode getReadRevisionContentAction() {
        return this.readRevisionContentAction;
    }

    public ActionNode getCreateRevisionContentAction() {
        return this.createRevisionContentAction;
    }

    public ActionNode getModifyRevisionContentAction() {
        return this.modifyRevisionContentAction;
    }

    public ActionNode getRemoveRevisionContentAction() {
        return this.removeRevisionContentAction;
    }

    public ActionNode getBindMemberAction() {
        return this.bindMemberAction;
    }

    public ActionNode getUnbindMemberAction() {
        return this.unbindMemberAction;
    }

    public String getUsersPath() {
        return this.usersPath;
    }

    public String getGroupsPath() {
        return this.groupsPath;
    }

    public String getRolesPath() {
        return this.rolesPath;
    }

    public String getGuestPath() {
        return this.guestPath;
    }

    public String getFilesPath() {
        return this.filesPath;
    }

    public String getActionsPath() {
        return this.actionsPath;
    }

    public Enumeration getDefaultProperties(String role) {
        Vector result = (Vector)this.defaultProperties.get(role);
        if (result == null) {
            return emptyVector.elements();
        }
        return result.elements();
    }

    ContentInterceptor[] getContentInterceptors() {
        return this.contentInterceptors;
    }

    public String getParameter(String name) {
        Object result = this.parameters.get(name);
        if (result == null) {
            return null;
        }
        return (String)result;
    }

    public String getRoleMapping(String name) {
        Object result = this.roleMappings.get(name);
        if (result == null) {
            return (String)this.roleClassMappings.get(name);
        }
        return (String)result;
    }

    public boolean isAutoCreateUsers() {
        return this.autoCreateUsers;
    }

    public boolean isPrincipal(String uri) {
        UriPath uriPath = new UriPath(uri);
        return this.usersUriPath != null && this.usersUriPath.equals(uriPath.parent()) || this.rolesUriPath != null && this.rolesUriPath.equals(uriPath.parent()) || this.groupsUriPath != null && this.groupsUriPath.equals(uriPath.parent());
    }

    public boolean isRole(String uri) {
        UriPath uriPath = new UriPath(uri);
        return this.rolesUriPath != null && this.rolesUriPath.equals(uriPath.parent());
    }

    public boolean isGroup(String uri) {
        UriPath uriPath = new UriPath(uri);
        return this.groupsUriPath != null && this.groupsUriPath.equals(uriPath.parent());
    }

    public String getAutoCreateUsersRole() {
        return this.autoCreateUsersRole;
    }

    public int getAclInheritanceType() {
        String aclInheritanceTypeStr = this.getParameter(ACL_INHERIT_TYPE);
        if ("none".equalsIgnoreCase(aclInheritanceTypeStr)) {
            return 0;
        }
        if ("root".equalsIgnoreCase(aclInheritanceTypeStr)) {
            return 1;
        }
        if ("path".equalsIgnoreCase(aclInheritanceTypeStr)) {
            return 2;
        }
        if ("full".equalsIgnoreCase(aclInheritanceTypeStr)) {
            return 3;
        }
        return 2;
    }

    public int getNestedRolesMaxDepth() {
        int result = 0;
        String nestedRolesMaxDepthStr = this.getParameter(NESTED_ROLES_MAXDEPTH);
        try {
            result = Integer.parseInt(nestedRolesMaxDepthStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void initializeNamespaceConfig(Namespace namespace, Configuration config) throws InvalidNamespaceConfigurationException, SlideException {
        this.name = namespace.getName();
        this.readObjectAction = this.getConfiguredNode(namespace, config, "read-object");
        this.createObjectAction = this.getConfiguredNode(namespace, config, "create-object");
        this.removeObjectAction = this.getConfiguredNode(namespace, config, "remove-object");
        this.grantPermissionAction = this.getConfiguredNode(namespace, config, "grant-permission");
        this.revokePermissionAction = this.getConfiguredNode(namespace, config, "revoke-permission");
        this.readPermissionsAction = this.getConfiguredNode(namespace, config, "read-permissions");
        this.readOwnPermissionsAction = this.getConfiguredNode(namespace, config, "read-own-permissions");
        this.lockObjectAction = this.getConfiguredNode(namespace, config, "lock-object");
        this.killLockAction = this.getConfiguredNode(namespace, config, "kill-lock");
        this.readLocksAction = this.getConfiguredNode(namespace, config, "read-locks");
        this.readRevisionMetadataAction = this.getConfiguredNode(namespace, config, "read-revision-metadata");
        this.createRevisionMetadataAction = this.getConfiguredNode(namespace, config, "create-revision-metadata");
        this.modifyRevisionMetadataAction = this.getConfiguredNode(namespace, config, "modify-revision-metadata");
        this.removeRevisionMetadataAction = this.getConfiguredNode(namespace, config, "remove-revision-metadata");
        this.readRevisionContentAction = this.getConfiguredNode(namespace, config, "read-revision-content");
        this.createRevisionContentAction = this.getConfiguredNode(namespace, config, "create-revision-content");
        this.modifyRevisionContentAction = this.getConfiguredNode(namespace, config, "modify-revision-content");
        this.removeRevisionContentAction = this.getConfiguredNode(namespace, config, "remove-revision-content");
        this.bindMemberAction = this.getConfiguredNode(namespace, config, "bind-member");
        this.unbindMemberAction = this.getConfiguredNode(namespace, config, "unbind-member");
        this.setPathsAndConfigValues(config);
        this.setParameters(config, namespace);
        this.setRoles(config, namespace);
        this.setDefaultProperties(config, namespace);
        Enumeration contentInteceptorsDef = config.getConfigurations("content-interceptor");
        try {
            while (contentInteceptorsDef.hasMoreElements()) {
                Configuration contentInterceptorDef = (Configuration)contentInteceptorsDef.nextElement();
                String classname = contentInterceptorDef.getAttribute("class");
                Enumeration contentInterceptorParametersDef = contentInterceptorDef.getConfigurations("parameter");
                Hashtable<String, String> contentInterceptorParameters = new Hashtable<String, String>();
                while (contentInterceptorParametersDef.hasMoreElements()) {
                    Configuration parameterDefinition = (Configuration)contentInterceptorParametersDef.nextElement();
                    String parameterName = parameterDefinition.getAttribute("name");
                    String parameterValue = parameterDefinition.getValue();
                    contentInterceptorParameters.put(parameterName, parameterValue);
                }
                try {
                    Class<?> contentInterceptorClass = Class.forName(classname);
                    ContentInterceptor contentInterceptor = (ContentInterceptor)contentInterceptorClass.newInstance();
                    contentInterceptor.setParameters(contentInterceptorParameters);
                    ContentInterceptor[] tempArray = new ContentInterceptor[this.contentInterceptors.length + 1];
                    for (int i = 0; i < this.contentInterceptors.length; ++i) {
                        tempArray[i] = this.contentInterceptors[i];
                    }
                    tempArray[this.contentInterceptors.length] = contentInterceptor;
                    this.contentInterceptors = tempArray;
                }
                catch (Exception e) {
                    namespace.getLogger().log(Messages.format("org.apache.slide.common.InvalidContentInterceptor", classname, e.getMessage()), 4);
                }
            }
            NamespaceAccessTokenImpl nat = new NamespaceAccessTokenImpl(namespace);
            ContentInterceptor[] contentInterceptors = namespace.getContentInterceptors();
            for (int i = 0; i < contentInterceptors.length; ++i) {
                contentInterceptors[i].setNamespace(nat);
            }
            return;
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
    }

    private void setDefaultProperties(Configuration config, Namespace namespace) throws InvalidNamespaceConfigurationException {
        this.defaultProperties = new Hashtable();
        Enumeration defaultPropertiesDef = config.getConfigurations("default-property");
        try {
            while (defaultPropertiesDef.hasMoreElements()) {
                Configuration defaultProperty = (Configuration)defaultPropertiesDef.nextElement();
                String name = defaultProperty.getAttribute("name");
                String value = defaultProperty.getAttribute("value", "");
                String propertyNamespace = defaultProperty.getAttribute("namespace", "DAV:");
                String role = defaultProperty.getAttribute("role");
                this.addDefaultProperty(role, name, value, propertyNamespace);
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
    }

    private void setParameters(Configuration config, Namespace namespace) throws InvalidNamespaceConfigurationException {
        this.parameters = new Hashtable();
        Enumeration parametersDef = config.getConfigurations("parameter");
        try {
            while (parametersDef.hasMoreElements()) {
                Configuration parameter = (Configuration)parametersDef.nextElement();
                this.addParameter(parameter.getAttribute("name"), parameter.getValue());
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
    }

    private ActionNode getConfiguredNode(Namespace namespace, Configuration config, String nodeName) throws SlideException {
        ActionNode result = null;
        try {
            result = this.getActionNode(namespace, config.getConfiguration(nodeName).getValue());
        }
        catch (ConfigurationException e) {
            result = this.getDefaultAction();
        }
        return result;
    }

    private void setPathsAndConfigValues(Configuration config) {
        try {
            this.usersPath = config.getConfiguration("userspath").getValue();
            this.usersUriPath = new UriPath(this.usersPath);
        }
        catch (ConfigurationException e) {
            this.usersPath = "";
        }
        try {
            this.groupsPath = config.getConfiguration("groupspath").getValue();
            this.groupsUriPath = new UriPath(this.groupsPath);
        }
        catch (ConfigurationException e) {
            this.groupsPath = "";
        }
        try {
            this.rolesPath = config.getConfiguration("rolespath").getValue();
            this.rolesUriPath = new UriPath(this.rolesPath);
        }
        catch (ConfigurationException e) {
            this.rolesPath = "";
        }
        try {
            this.guestPath = config.getConfiguration("guestpath").getValue();
        }
        catch (ConfigurationException e) {
            this.guestPath = "";
        }
        try {
            this.filesPath = config.getConfiguration("filespath").getValue();
        }
        catch (ConfigurationException e) {
            this.filesPath = "";
        }
        try {
            this.actionsPath = config.getConfiguration("actionspath").getValue();
        }
        catch (ConfigurationException e) {
            this.actionsPath = "";
        }
        try {
            this.autoCreateUsers = Boolean.valueOf(config.getConfiguration("auto-create-users").getValue());
        }
        catch (ConfigurationException e) {
            this.autoCreateUsers = false;
        }
        try {
            this.autoCreateUsersRole = config.getConfiguration("auto-create-users-role").getValue();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    void initializeNamespaceParameters(Namespace namespace, Configuration config) throws InvalidNamespaceConfigurationException, SlideException {
        this.setParameters(config, namespace);
        this.setPathsAndConfigValues(config);
        this.setRoles(config, namespace);
        this.setDefaultProperties(config, namespace);
    }

    private void setRoles(Configuration config, Namespace namespace) throws InvalidNamespaceConfigurationException {
        this.addRoleMapping(NOBODY, NOBODY_ROLE);
        this.addRoleMapping(NOBODY, LINK_ROLE);
        this.addRoleMapping(NOBODY, ACTION_ROLE);
        this.addRoleMapping(NOBODY, BASE_ROLE);
        Enumeration roleMappingsDef = config.getConfigurations("role");
        try {
            while (roleMappingsDef.hasMoreElements()) {
                Configuration roleMappingDef = (Configuration)roleMappingsDef.nextElement();
                this.addRoleMapping(roleMappingDef.getAttribute("name"), roleMappingDef.getValue());
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
    }

    void initializeAsDummyConfig(Namespace namespace) throws InvalidNamespaceConfigurationException {
        this.name = namespace.getName();
        try {
            this.readObjectAction = this.getDefaultAction();
            this.createObjectAction = this.getDefaultAction();
            this.removeObjectAction = this.getDefaultAction();
            this.grantPermissionAction = this.getDefaultAction();
            this.revokePermissionAction = this.getDefaultAction();
            this.readPermissionsAction = this.getDefaultAction();
            this.readOwnPermissionsAction = this.getDefaultAction();
            this.lockObjectAction = this.getDefaultAction();
            this.killLockAction = this.getDefaultAction();
            this.readLocksAction = this.getDefaultAction();
            this.readRevisionMetadataAction = this.getDefaultAction();
            this.createRevisionMetadataAction = this.getDefaultAction();
            this.modifyRevisionMetadataAction = this.getDefaultAction();
            this.removeRevisionMetadataAction = this.getDefaultAction();
            this.readRevisionContentAction = this.getDefaultAction();
            this.createRevisionContentAction = this.getDefaultAction();
            this.modifyRevisionContentAction = this.getDefaultAction();
            this.removeRevisionContentAction = this.getDefaultAction();
            this.bindMemberAction = this.getDefaultAction();
            this.unbindMemberAction = this.getDefaultAction();
        }
        catch (Exception e) {
            throw new InvalidNamespaceConfigurationException(namespace, e.getMessage());
        }
    }

    public void initializeForTestPurposesOnly() throws InvalidNamespaceConfigurationException {
        this.name = "slide";
        try {
            this.readObjectAction = this.getDefaultAction();
            this.createObjectAction = this.getDefaultAction();
            this.removeObjectAction = this.getDefaultAction();
            this.grantPermissionAction = this.getDefaultAction();
            this.revokePermissionAction = this.getDefaultAction();
            this.readPermissionsAction = this.getDefaultAction();
            this.readOwnPermissionsAction = this.getDefaultAction();
            this.lockObjectAction = this.getDefaultAction();
            this.killLockAction = this.getDefaultAction();
            this.readLocksAction = this.getDefaultAction();
            this.readRevisionMetadataAction = this.getDefaultAction();
            this.createRevisionMetadataAction = this.getDefaultAction();
            this.modifyRevisionMetadataAction = this.getDefaultAction();
            this.removeRevisionMetadataAction = this.getDefaultAction();
            this.readRevisionContentAction = this.getDefaultAction();
            this.createRevisionContentAction = this.getDefaultAction();
            this.modifyRevisionContentAction = this.getDefaultAction();
            this.removeRevisionContentAction = this.getDefaultAction();
            this.bindMemberAction = this.getDefaultAction();
            this.unbindMemberAction = this.getDefaultAction();
        }
        catch (Exception e) {
            throw new InvalidNamespaceConfigurationException(null, e.getMessage());
        }
    }

    protected void addParameter(String name, String value) {
        if (name != null && value != null) {
            this.parameters.put(name, value);
        }
    }

    protected void addDefaultProperty(String role, String name, String value, String namespace) {
        if (role != null && name != null && value != null) {
            Vector<NodeProperty> currentDefaultProperties = (Vector<NodeProperty>)this.defaultProperties.get(role);
            if (currentDefaultProperties == null) {
                currentDefaultProperties = new Vector<NodeProperty>();
                this.defaultProperties.put(role, currentDefaultProperties);
            }
            currentDefaultProperties.addElement(new NodeProperty(name, (Object)value, namespace));
        }
    }

    protected void addRoleMapping(String name, String value) {
        if (name != null && value != null) {
            this.roleMappings.put(name, value);
            this.roleClassMappings.put(value, name);
        }
    }

    protected ActionNode getActionNode(Namespace namespace, String actionPath) throws InvalidNamespaceConfigurationException, SlideException {
        ActionNode result = null;
        if (actionPath != null) {
            Uri actionUri = namespace.getUri(actionPath);
            result = (ActionNode)actionUri.getStore().retrieveObject(actionUri);
        } else {
            result = this.getDefaultAction();
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

