/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.content;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.util.Messages;

public final class NodeRevisionDescriptors
implements Serializable,
Cloneable {
    public static final String MAIN_BRANCH = "main";
    protected static final NodeRevisionNumber initialRevision = new NodeRevisionNumber();
    private boolean useVersioning;
    private String uri;
    private String originalUri;
    private Hashtable workingRevisions;
    private Hashtable latestRevisionNumbers;
    private Hashtable branches;
    static /* synthetic */ Class class$org$apache$slide$content$NodeRevisionDescriptors;

    public NodeRevisionDescriptors() {
        this.latestRevisionNumbers = new Hashtable();
        this.branches = new Hashtable();
        this.workingRevisions = new Hashtable();
        this.useVersioning = false;
    }

    public NodeRevisionDescriptors(boolean isVersioned) {
        this.latestRevisionNumbers = new Hashtable();
        this.branches = new Hashtable();
        this.workingRevisions = new Hashtable();
        this.useVersioning = isVersioned;
    }

    public NodeRevisionDescriptors(String uri, NodeRevisionNumber initialRevision, Hashtable workingRevisions, Hashtable latestRevisionNumbers, Hashtable branches, boolean isVersioned) {
        this.uri = uri;
        this.latestRevisionNumbers = latestRevisionNumbers;
        this.branches = branches;
        this.workingRevisions = workingRevisions;
        this.useVersioning = isVersioned;
    }

    public boolean isVersioned() {
        return this.useVersioning;
    }

    void setVersioned(boolean useVersioning) {
        this.useVersioning = useVersioning;
    }

    public boolean hasRevisions() {
        return !this.latestRevisionNumbers.isEmpty();
    }

    public String getUri() {
        return this.uri;
    }

    public String getOriginalUri() {
        if (this.originalUri != null) {
            return this.originalUri;
        }
        return this.uri;
    }

    void setOriginalUri(String originalUri) {
        this.originalUri = originalUri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public NodeRevisionNumber getInitialRevision() {
        return initialRevision;
    }

    public NodeRevisionNumber getLatestRevision() {
        return this.getLatestRevision(MAIN_BRANCH);
    }

    public NodeRevisionNumber getLatestRevision(String branchName) {
        Object number = null;
        number = this.latestRevisionNumbers.get(branchName);
        if (number != null) {
            return number;
        }
        return null;
    }

    void setLatestRevision(NodeRevisionNumber number) {
        this.latestRevisionNumbers.put(MAIN_BRANCH, number);
    }

    void setLatestRevision(String branch, NodeRevisionNumber number) {
        this.latestRevisionNumbers.put(branch, number);
    }

    public Enumeration getSuccessors(NodeRevisionNumber number) {
        Object result = this.branches.get(number);
        if (result != null) {
            return ((Vector)result).elements();
        }
        return null;
    }

    public boolean isAncestorDescendant(NodeRevisionNumber ancNrn, NodeRevisionNumber descNrn) {
        if (ancNrn.equals(descNrn)) {
            return true;
        }
        Enumeration ancSuccs = this.getSuccessors(ancNrn);
        while (ancSuccs != null && ancSuccs.hasMoreElements()) {
            NodeRevisionNumber ancSuccNrn = (NodeRevisionNumber)ancSuccs.nextElement();
            if (!this.isAncestorDescendant(ancSuccNrn, descNrn)) continue;
            return true;
        }
        return false;
    }

    public boolean isRedirected() {
        return !this.uri.equals(this.originalUri);
    }

    void setSuccessors(NodeRevisionNumber number, NodeRevisionNumber successor) {
        Vector<NodeRevisionNumber> tempVector = new Vector<NodeRevisionNumber>();
        tempVector.addElement(successor);
        this.setSuccessors(number, tempVector);
    }

    void setSuccessors(NodeRevisionNumber number, Vector successors) {
        this.branches.put(number, successors);
    }

    void addSuccessor(NodeRevisionNumber number, NodeRevisionNumber successor) {
        Object result = this.branches.get(number);
        if (result != null) {
            ((Vector)result).addElement(successor);
        } else {
            this.setSuccessors(number, successor);
        }
    }

    void removeSuccessor(NodeRevisionNumber number, NodeRevisionNumber successor) {
        Object result = this.branches.get(number);
        if (result != null) {
            ((Vector)result).removeElement(successor);
        }
    }

    public Enumeration enumerateRevisionNumbers() {
        return this.branches.keys();
    }

    public Enumeration enumerateBranchNames() {
        return this.latestRevisionNumbers.keys();
    }

    public NodeRevisionDescriptors cloneObject() {
        NodeRevisionDescriptors result = null;
        try {
            result = (NodeRevisionDescriptors)super.clone();
            Hashtable branchesClone = new Hashtable();
            Enumeration branchesList = this.branches.keys();
            while (branchesList.hasMoreElements()) {
                Object key = branchesList.nextElement();
                Vector value = (Vector)this.branches.get(key);
                branchesClone.put(key, value.clone());
            }
            result.branches = branchesClone;
            result.latestRevisionNumbers = (Hashtable)this.latestRevisionNumbers.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof NodeRevisionDescriptors) {
            NodeRevisionDescriptors revisionDescriptors = (NodeRevisionDescriptors)obj;
            result = this.getUri().equals(revisionDescriptors.getUri());
        }
        return result;
    }

    public void validate(String expectedUri) {
        if (this.uri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message((class$org$apache$slide$content$NodeRevisionDescriptors == null ? (class$org$apache$slide$content$NodeRevisionDescriptors = NodeRevisionDescriptors.class$("org.apache.slide.content.NodeRevisionDescriptors")) : class$org$apache$slide$content$NodeRevisionDescriptors).getName() + ".nullUri"));
        }
        if (!this.uri.equals(expectedUri) && !this.uri.equals(expectedUri + "/")) {
            System.out.println("Uri1 : " + this.uri + " Uri2 : " + expectedUri);
        }
        if (this.workingRevisions == null) {
            throw new ObjectValidationFailedException(this.uri, Messages.message((class$org$apache$slide$content$NodeRevisionDescriptors == null ? (class$org$apache$slide$content$NodeRevisionDescriptors = NodeRevisionDescriptors.class$("org.apache.slide.content.NodeRevisionDescriptors")) : class$org$apache$slide$content$NodeRevisionDescriptors).getName() + ".nullWorkingRevisions"));
        }
        if (this.latestRevisionNumbers == null) {
            throw new ObjectValidationFailedException(this.uri, Messages.message((class$org$apache$slide$content$NodeRevisionDescriptors == null ? (class$org$apache$slide$content$NodeRevisionDescriptors = NodeRevisionDescriptors.class$("org.apache.slide.content.NodeRevisionDescriptors")) : class$org$apache$slide$content$NodeRevisionDescriptors).getName() + ".nullLatestRevisionNumbers"));
        }
        if (this.branches == null) {
            throw new ObjectValidationFailedException(this.uri, Messages.message((class$org$apache$slide$content$NodeRevisionDescriptors == null ? (class$org$apache$slide$content$NodeRevisionDescriptors = NodeRevisionDescriptors.class$("org.apache.slide.content.NodeRevisionDescriptors")) : class$org$apache$slide$content$NodeRevisionDescriptors).getName() + ".nullBranches"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

