/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.extractor;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.extractor.ContentExtractor;
import org.apache.slide.extractor.Extractor;
import org.apache.slide.extractor.PropertyExtractor;
import org.apache.slide.util.conf.Configurable;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;

public class ExtractorManager
implements Configurable {
    private static final ExtractorManager manager = new ExtractorManager();
    private List extractors = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;

    private ExtractorManager() {
    }

    public static ExtractorManager getInstance() {
        return manager;
    }

    public void addExtractor(Extractor extractor) {
        this.extractors.add(extractor);
    }

    public PropertyExtractor[] getPropertyExtractors(String namespace, NodeRevisionDescriptors descriptors, NodeRevisionDescriptor descriptor) {
        ArrayList<Extractor> matchingExtractors = new ArrayList<Extractor>();
        Iterator i = this.extractors.iterator();
        while (i.hasNext()) {
            Extractor extractor = (Extractor)i.next();
            if (!(extractor instanceof PropertyExtractor) || !this.matches(extractor, namespace, descriptors, descriptor)) continue;
            matchingExtractors.add(extractor);
        }
        PropertyExtractor[] extractors = new PropertyExtractor[matchingExtractors.size()];
        return matchingExtractors.toArray(extractors);
    }

    public ContentExtractor[] getContentExtractors(String namespace, NodeRevisionDescriptors descriptors, NodeRevisionDescriptor descriptor) {
        ArrayList<Extractor> matchingExtractors = new ArrayList<Extractor>();
        Iterator i = this.extractors.iterator();
        while (i.hasNext()) {
            Extractor extractor = (Extractor)i.next();
            if (!(extractor instanceof ContentExtractor) || !this.matches(extractor, namespace, descriptors, descriptor)) continue;
            matchingExtractors.add(extractor);
        }
        ContentExtractor[] extractors = new ContentExtractor[matchingExtractors.size()];
        return matchingExtractors.toArray(extractors);
    }

    public Extractor[] getExtractors(String namespace, NodeRevisionDescriptors descriptors, NodeRevisionDescriptor descriptor) {
        ArrayList<Extractor> matchingExtractors = new ArrayList<Extractor>();
        Iterator i = this.extractors.iterator();
        while (i.hasNext()) {
            Extractor extractor = (Extractor)i.next();
            if (!this.matches(extractor, namespace, descriptors, descriptor)) continue;
            matchingExtractors.add(extractor);
        }
        Extractor[] extractors = new Extractor[matchingExtractors.size()];
        return matchingExtractors.toArray(extractors);
    }

    public boolean matches(Extractor extractor, String namespace, NodeRevisionDescriptors descriptors, NodeRevisionDescriptor descriptor) {
        boolean matching = true;
        if (descriptor != null && extractor.getContentType() != null && !descriptor.getContentType().equals(extractor.getContentType())) {
            matching = false;
        }
        if (descriptors != null && extractor.getUri() != null && !descriptors.getUri().startsWith(extractor.getUri())) {
            matching = false;
        }
        if (descriptors != null && extractor.getNamespace() != null && !extractor.getNamespace().equals(namespace)) {
            matching = false;
        }
        return matching;
    }

    public void configure(Configuration config) throws ConfigurationException {
        Enumeration extractorConfigs = config.getConfigurations("extractor");
        while (extractorConfigs.hasMoreElements()) {
            Configuration extractorConfig = (Configuration)extractorConfigs.nextElement();
            String classname = extractorConfig.getAttribute("classname");
            String uri = extractorConfig.getAttribute("uri", null);
            String contentType = extractorConfig.getAttribute("content-type", null);
            String namespace = extractorConfig.getAttribute("namespace", null);
            try {
                Class<?> extractorClass = Class.forName(classname);
                Extractor extractor = null;
                try {
                    Constructor<?> extractorConstructor = extractorClass.getConstructor(class$java$lang$String == null ? ExtractorManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? ExtractorManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? ExtractorManager.class$("java.lang.String") : class$java$lang$String);
                    extractor = (Extractor)extractorConstructor.newInstance(uri, contentType, namespace);
                }
                catch (NoSuchMethodException e) {
                    Constructor<?> extractorConstructor = extractorClass.getConstructor(class$java$lang$String == null ? ExtractorManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? ExtractorManager.class$("java.lang.String") : class$java$lang$String);
                    extractor = (Extractor)extractorConstructor.newInstance(uri, contentType);
                }
                if (extractor instanceof Configurable) {
                    ((Configurable)((Object)extractor)).configure(extractorConfig.getConfiguration("configuration"));
                }
                this.addExtractor(extractor);
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("Extractor '" + classname + "' is not of type Extractor", config);
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationException("Extractor '" + classname + "' could not be loaded", config);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

