/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.store.impl.rdbms.SequenceAdapter;
import org.apache.slide.store.impl.rdbms.StandardRDBMSAdapter;
import org.apache.slide.util.logger.Logger;

public class MySqlRDBMSAdapter
extends StandardRDBMSAdapter
implements SequenceAdapter {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$store$impl$rdbms$MySqlRDBMSAdapter == null ? (class$org$apache$slide$store$impl$rdbms$MySqlRDBMSAdapter = MySqlRDBMSAdapter.class$("org.apache.slide.store.impl.rdbms.MySqlRDBMSAdapter")) : class$org$apache$slide$store$impl$rdbms$MySqlRDBMSAdapter).getName();
    static /* synthetic */ Class class$org$apache$slide$store$impl$rdbms$MySqlRDBMSAdapter;

    protected static String normalizeSequenceName(String sequenceName) {
        return sequenceName.replace('-', '_').toUpperCase() + "_SEQ";
    }

    public MySqlRDBMSAdapter(Service service, Logger logger) {
        super(service, logger);
    }

    protected ServiceAccessException createException(SQLException e, String uri) {
        switch (e.getErrorCode()) {
            case 1213: {
                this.getLogger().log((Object)(e.getErrorCode() + ": Deadlock resolved on " + uri), LOG_CHANNEL, 4);
                return new ServiceAccessException(this.service, (Throwable)new ConflictException(uri));
            }
        }
        this.getLogger().log((Object)("SQL error " + e.getErrorCode() + " on " + uri + ": " + e.getMessage()), LOG_CHANNEL, 2);
        return new ServiceAccessException(this.service, (Throwable)e);
    }

    protected String convertRevisionNumberToComparable(String revisioNumber) {
        return "convert(SUBSTRING_INDEX(" + revisioNumber + ", '.', 1), unsigned), convert(SUBSTRING_INDEX(" + revisioNumber + ", '.', -1), unsigned)";
    }

    public boolean isSequenceSupported(Connection conn) {
        return true;
    }

    public boolean createSequence(Connection conn, String sequenceName) throws ServiceAccessException {
        String query = "CREATE TABLE " + MySqlRDBMSAdapter.normalizeSequenceName(sequenceName) + "(id INT auto_increment NOT NULL,PRIMARY KEY (id))";
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(query);
            statement.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
        finally {
            this.close(statement);
        }
    }

    public long nextSequenceValue(Connection conn, String sequenceName) throws ServiceAccessException {
        long l;
        String query = "INSERT INTO " + MySqlRDBMSAdapter.normalizeSequenceName(sequenceName) + " VALUES(0)";
        String selectQuery = "SELECT LAST_INSERT_ID()";
        PreparedStatement statement = null;
        PreparedStatement selectStatement = null;
        ResultSet res = null;
        try {
            long value;
            statement = conn.prepareStatement(query);
            statement.executeUpdate();
            selectStatement = conn.prepareStatement(selectQuery);
            res = selectStatement.executeQuery();
            if (!res.next()) {
                throw new ServiceAccessException(this.service, "Could not increment sequence " + sequenceName);
            }
            l = value = res.getLong(1);
        }
        catch (SQLException e) {
            try {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(selectStatement, res);
                throw throwable;
            }
        }
        this.close(statement);
        this.close(selectStatement, res);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sequenceExists(Connection conn, String sequenceName) throws ServiceAccessException {
        PreparedStatement selectStatement = null;
        ResultSet res = null;
        try {
            selectStatement = conn.prepareStatement("SELECT * FROM " + MySqlRDBMSAdapter.normalizeSequenceName(sequenceName));
            res = selectStatement.executeQuery();
            boolean bl = true;
            this.close(selectStatement, res);
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(selectStatement, res);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

