/*
 * Decompiled with CFR 0.152.
 */
package sf.net.ehcache.constructs.blocking;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.constructs.blocking.BlockingCacheManager;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;

public abstract class SelfPopulatingCacheManager
extends BlockingCacheManager {
    public SelfPopulatingCacheManager() throws CacheException {
        this.setupCaches();
    }

    public SelfPopulatingCache getSelfPopulatingCache(String name) throws CacheException {
        SelfPopulatingCache cache = (SelfPopulatingCache)this.caches.get(name);
        if (cache == null) {
            throw new CacheException("Cache " + name + " cannot be retrieved. Please check ehcache.xml");
        }
        return cache;
    }

    public void refreshAll() throws Exception {
        List caches = this.getCaches();
        for (int i = 0; i < caches.size(); ++i) {
            SelfPopulatingCache cache = (SelfPopulatingCache)caches.get(i);
            cache.refresh();
        }
    }

    public void refresh(String name) throws CacheException {
        SelfPopulatingCache cache = this.getSelfPopulatingCache(name);
        cache.refresh();
    }

    public void refreshEntry(String cacheName, Serializable key) throws Exception {
        SelfPopulatingCache cache = this.getSelfPopulatingCache(cacheName);
        cache.put(key, null);
        cache.get(key);
    }

    protected synchronized SelfPopulatingCache createSelfPopulatingCache(String name, CacheEntryFactory factory) throws CacheException {
        if (this.caches.containsKey(name)) {
            throw new CacheException("A cache with name \"" + name + "\" already exists.");
        }
        SelfPopulatingCache cache = new SelfPopulatingCache(name, factory);
        this.caches.put(name, cache);
        return cache;
    }

    protected synchronized SelfPopulatingCache createUpdatingSelfPopulatingCache(String name, UpdatingCacheEntryFactory factory) throws CacheException {
        if (this.caches.containsKey(name)) {
            throw new CacheException("A cache with name \"" + name + "\" already exists.");
        }
        SelfPopulatingCache cache = new SelfPopulatingCache(name, factory);
        this.caches.put(name, cache);
        return cache;
    }

    protected synchronized List getCaches() {
        ArrayList caches = new ArrayList();
        caches.addAll(this.caches.values());
        return caches;
    }

    protected synchronized void setupCaches() throws CacheException {
        this.doSetupCaches();
    }

    protected abstract void doSetupCaches() throws CacheException;
}

