/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.wsrp;

import java.util.HashMap;
import java.util.Map;
import org.jasig.portal.channels.wsrp.MarkupWrapper;
import org.jasig.portal.wsrp.types.CacheControl;

public class MarkupCache {
    private static Map cacheForAll;
    private Map cachePerUser = new HashMap();

    public void put(String key, MarkupWrapper markupWrapper) {
        CacheControl cacheControl = markupWrapper.getCacheControl();
        if (cacheControl != null) {
            int expires = cacheControl.getExpires();
            String userScope = cacheControl.getUserScope();
            if (userScope.equals("wsrp:forAll")) {
                cacheForAll.put(key, markupWrapper);
            } else if (userScope.equals("wsrp:perUser")) {
                this.cachePerUser.put(key, markupWrapper);
            }
        }
    }

    public MarkupWrapper get(String key, String userScope) {
        MarkupWrapper markupWrapper = null;
        if (userScope.equals("wsrp:forAll")) {
            markupWrapper = (MarkupWrapper)cacheForAll.get(key);
        } else if (userScope.equals("wsrp:perUser")) {
            markupWrapper = (MarkupWrapper)this.cachePerUser.get(key);
        }
        return markupWrapper;
    }

    public void remove(String key, String userScope) {
        if (userScope.equals("wsrp:forAll")) {
            cacheForAll.remove(key);
        } else if (userScope.equals("wsrp:perUser")) {
            this.cachePerUser.remove(key);
        }
    }
}

