/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.restrictions;

import java.util.StringTokenizer;
import java.util.Vector;
import org.jasig.portal.PortalException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupService;
import org.jasig.portal.groups.IGroupServiceFactory;
import org.jasig.portal.groups.ReferenceGroupServiceFactory;
import org.jasig.portal.layout.ALNode;
import org.jasig.portal.layout.restrictions.UserLayoutRestriction;

public class GroupRestriction
extends UserLayoutRestriction {
    private IEntityGroup[] groups;
    private static IGroupService groupService;
    private static IGroupServiceFactory groupServiceFactory;

    public GroupRestriction(String nodePath) throws PortalException {
        super(nodePath);
        try {
            if (groupServiceFactory == null) {
                groupServiceFactory = new ReferenceGroupServiceFactory();
            }
            if (groupService == null) {
                groupService = groupServiceFactory.newGroupService();
            }
        }
        catch (Exception e) {
            throw new PortalException(e.getMessage());
        }
    }

    public GroupRestriction() throws PortalException {
        this(LOCAL_RESTRICTION);
    }

    public int getRestrictionType() {
        return 4 | super.getRestrictionType();
    }

    protected void parseRestrictionExpression() throws PortalException {
        try {
            String restrictionExp = this.getRestrictionExpression();
            Vector<IEntityGroup> groupsList = new Vector<IEntityGroup>();
            StringTokenizer st = new StringTokenizer(restrictionExp, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                groupsList.add(groupService.findGroup(token));
            }
            this.groups = (IEntityGroup[])groupsList.toArray();
        }
        catch (Exception e) {
            throw new PortalException(e.getMessage());
        }
    }

    public boolean checkRestriction(String propertyValue) throws PortalException {
        IEntityGroup group = groupService.findGroup(propertyValue);
        for (int i = 0; i < this.groups.length; ++i) {
            if (!this.groups[i].contains(group)) continue;
            return true;
        }
        return false;
    }

    public boolean checkRestriction(ALNode node) throws PortalException {
        IEntityGroup group = groupService.findGroup(node.getNodeDescription().getGroup());
        for (int i = 0; i < this.groups.length; ++i) {
            if (!this.groups[i].contains(group)) continue;
            return true;
        }
        return false;
    }
}

