/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.RDBMUserIdentityStore;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;

public class DeleteUser {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage \"DeleteUser <username>\"");
            return;
        }
        int portalUID = -1;
        IPerson per = PersonFactory.createPerson();
        per.setAttribute("username", args[0]);
        RDBMUserIdentityStore rdbmuser = new RDBMUserIdentityStore();
        try {
            portalUID = rdbmuser.getPortalUID(per, false);
            System.out.println("DeleteUser.main(): Got portal UID for " + args[0] + ": " + portalUID);
        }
        catch (AuthorizationException e) {
            System.err.println("DeleteUser.main(): Attempting to get portal UID for " + args[0] + " - Authorization exception: " + e.getMessage());
            return;
        }
        if (portalUID > -1) {
            try {
                rdbmuser.removePortalUID(portalUID);
                System.out.println("DeleteUser.main(): Removed " + portalUID + " from portal db.");
            }
            catch (Exception e) {
                System.err.println("DeleteUser.main(): Attempting to delete user: error removing user from user identity store.");
                e.printStackTrace();
                return;
            }
        } else {
            System.err.println("DeleteUser.removePortalUid(): Attempting to delete " + portalUID + "; unable to find user.");
            return;
        }
        try {
            DeleteUser.removeUserMemberships(args[0]);
        }
        catch (Exception e) {
            System.err.println("DeleteUser.main(): error removing user from groups: " + e.getMessage());
            return;
        }
        try {
            DeleteUser.deleteBookmarks(portalUID);
        }
        catch (SQLException e) {
            System.err.println("DeleteUser.main(): Error deleting bookmarks: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteBookmarks(int uid) throws SQLException {
        DatabaseMetaData metadata = null;
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            if (con == null) {
                throw new SQLException("DeleteUser.deleteBookmarks(): Unable to get a database connection.");
            }
            Statement stmt = null;
            try {
                metadata = con.getMetaData();
                String[] names = new String[]{"TABLE"};
                ResultSet tableNames = null;
                try {
                    tableNames = metadata.getTables(null, "%", "UPC_BOOKMARKS", names);
                    if (tableNames.next()) {
                        stmt = con.createStatement();
                        System.out.println("Deleting bookmarks from UPC_BOOKMARKS");
                        String bookmarksSql = "DELETE FROM UPC_BOOKMARKS WHERE PORTAL_USER_ID=" + uid;
                        boolean b = stmt.execute(bookmarksSql);
                    }
                }
                finally {
                    try {
                        tableNames.close();
                    }
                    catch (Exception e) {}
                }
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
        finally {
            try {
                RDBMServices.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUserMemberships(String userName) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = RDBMServices.getConnection();
            if (con == null) {
                throw new SQLException("DeleteUser.removeUserMemberships(): Unable to get a database connection.");
            }
            try {
                stmt = con.createStatement();
                String sql = "DELETE FROM UP_GROUP_MEMBERSHIP WHERE MEMBER_KEY = '" + userName + "' AND GROUP_ID IN " + "(SELECT M.GROUP_ID " + "FROM UP_GROUP_MEMBERSHIP M, UP_GROUP G, UP_ENTITY_TYPE E " + "WHERE M.GROUP_ID = G.GROUP_ID " + "  AND G.ENTITY_TYPE_ID = E.ENTITY_TYPE_ID " + "  AND  E.ENTITY_TYPE_NAME = 'org.jasig.portal.security.IPerson'" + "  AND  M.MEMBER_KEY = '" + userName + "'" + "  AND  M.MEMBER_IS_GROUP = 'F')";
                int rows = stmt.executeUpdate(sql);
                System.out.println("Deleted " + rows + " memberships for " + userName + " from UP_GROUP_MEMBERSHIP.");
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
        finally {
            try {
                RDBMServices.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }
}

