/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.util.EmptyStackException;
import java.util.Stack;

public class BlockingStack {
    int maxSize = -1;
    int minSize = 0;
    volatile Stack stack = new Stack();

    BlockingStack() {
    }

    BlockingStack(int min, int max) {
        this();
        this.maxSize = max;
        this.minSize = min;
    }

    BlockingStack(int max) {
        this(0, max);
    }

    public synchronized boolean empty() {
        return this.stack.empty();
    }

    public synchronized void push(Object o) throws InterruptedException {
        while (this.stack.size() >= this.maxSize && this.maxSize != -1) {
            this.wait();
        }
        this.stack.push(o);
        this.notifyAll();
    }

    public synchronized Object pop() throws InterruptedException {
        while (this.stack.size() <= this.minSize) {
            this.wait();
        }
        this.notifyAll();
        return this.stack.pop();
    }

    public synchronized Object nonBlockingPop() throws EmptyStackException {
        Object o = this.stack.pop();
        this.notifyAll();
        return o;
    }

    public synchronized boolean nonBlockingPush(Object o) {
        if (this.stack.size() > this.maxSize && this.maxSize != -1) {
            return false;
        }
        this.stack.push(o);
        this.notifyAll();
        return true;
    }

    public synchronized void setLimits(int max, int min) {
        this.maxSize = max;
        this.minSize = min;
        this.notifyAll();
    }

    public synchronized boolean remove(Object o) {
        return this.stack.remove(o);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public synchronized void setMaxSize(int max) {
        this.maxSize = max;
        this.notifyAll();
    }

    public synchronized void setMinSize(int min) {
        this.minSize = min;
        this.notifyAll();
    }

    public synchronized int size() {
        return this.stack.size();
    }
}

