/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.wsrp;

import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.StringHolder;
import org.jasig.portal.wsrp.intf.WSRP_v1_PortletManagement_PortType;
import org.jasig.portal.wsrp.types.DestroyPortletsResponse;
import org.jasig.portal.wsrp.types.PortletContext;
import org.jasig.portal.wsrp.types.PortletDescriptionResponse;
import org.jasig.portal.wsrp.types.PortletPropertyDescriptionResponse;
import org.jasig.portal.wsrp.types.PropertyList;
import org.jasig.portal.wsrp.types.RegistrationContext;
import org.jasig.portal.wsrp.types.UserContext;
import org.jasig.portal.wsrp.types.holders.DestroyFailedArrayHolder;
import org.jasig.portal.wsrp.types.holders.ExtensionArrayHolder;
import org.jasig.portal.wsrp.types.holders.ModelDescriptionHolder;
import org.jasig.portal.wsrp.types.holders.PortletDescriptionHolder;
import org.jasig.portal.wsrp.types.holders.PropertyArrayHolder;
import org.jasig.portal.wsrp.types.holders.ResetPropertyArrayHolder;
import org.jasig.portal.wsrp.types.holders.ResourceListHolder;
import org.jasig.portal.wsrp.wsdl.WSRPServiceLocator;

public class PortletManagementService {
    WSRPServiceLocator locator = new WSRPServiceLocator();
    WSRP_v1_PortletManagement_PortType pt = null;
    private static final String serviceName = "WSRPPortletManagementService";
    private static final Map services = new WeakHashMap();

    private PortletManagementService(String baseEndpoint) throws Exception {
        if (!baseEndpoint.endsWith("/")) {
            baseEndpoint = baseEndpoint + "/";
        }
        String serviceEndpoint = baseEndpoint + serviceName;
        this.pt = this.locator.getWSRPPortletManagementService(new URL(serviceEndpoint));
    }

    public static PortletManagementService getService(String baseEndpoint) throws Exception {
        PortletManagementService service = (PortletManagementService)services.get(baseEndpoint);
        if (service == null) {
            service = new PortletManagementService(baseEndpoint);
            services.put(baseEndpoint, service);
        }
        return service;
    }

    public PortletDescriptionResponse getPortletDescription(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, String[] desiredLocales) throws Exception {
        PortletDescriptionHolder portletDescription = new PortletDescriptionHolder();
        ResourceListHolder resourceList = new ResourceListHolder();
        ExtensionArrayHolder extensions = new ExtensionArrayHolder();
        this.pt.getPortletDescription(registrationContext, portletContext, userContext, desiredLocales, portletDescription, resourceList, extensions);
        PortletDescriptionResponse portletDescriptionResponse = new PortletDescriptionResponse();
        portletDescriptionResponse.setPortletDescription(portletDescription.value);
        portletDescriptionResponse.setResourceList(resourceList.value);
        portletDescriptionResponse.setExtensions(extensions.value);
        return portletDescriptionResponse;
    }

    public PortletContext clonePortlet(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext) throws Exception {
        StringHolder portletHandle = new StringHolder();
        ByteArrayHolder portletState = new ByteArrayHolder();
        ExtensionArrayHolder extensions = new ExtensionArrayHolder();
        this.pt.clonePortlet(registrationContext, portletContext, userContext, portletHandle, portletState, extensions);
        PortletContext clonePortletResponse = new PortletContext();
        clonePortletResponse.setPortletHandle(portletHandle.value);
        clonePortletResponse.setPortletState(portletState.value);
        clonePortletResponse.setExtensions(extensions.value);
        return clonePortletResponse;
    }

    public DestroyPortletsResponse destroyPortlets(RegistrationContext registrationContext, String[] portletHandles) throws Exception {
        DestroyFailedArrayHolder destroyFailed = new DestroyFailedArrayHolder();
        ExtensionArrayHolder extensions = new ExtensionArrayHolder();
        this.pt.destroyPortlets(registrationContext, portletHandles, destroyFailed, extensions);
        DestroyPortletsResponse destroyPortletsResponse = new DestroyPortletsResponse();
        destroyPortletsResponse.setDestroyFailed(destroyFailed.value);
        destroyPortletsResponse.setExtensions(extensions.value);
        return destroyPortletsResponse;
    }

    public PortletContext setPortletProperties(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, PropertyList propertyList) throws Exception {
        StringHolder portletHandle = new StringHolder();
        ByteArrayHolder portletState = new ByteArrayHolder();
        ExtensionArrayHolder extensions = new ExtensionArrayHolder();
        this.pt.setPortletProperties(registrationContext, portletContext, userContext, propertyList, portletHandle, portletState, extensions);
        PortletContext setPortletPropertiesResponse = new PortletContext();
        setPortletPropertiesResponse.setPortletHandle(portletHandle.value);
        setPortletPropertiesResponse.setPortletState(portletState.value);
        setPortletPropertiesResponse.setExtensions(extensions.value);
        return setPortletPropertiesResponse;
    }

    public PropertyList getPortletProperties(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, String[] names) throws Exception {
        PropertyArrayHolder properties = new PropertyArrayHolder();
        ResetPropertyArrayHolder resetProperties = new ResetPropertyArrayHolder();
        ExtensionArrayHolder extensions = new ExtensionArrayHolder();
        this.pt.getPortletProperties(registrationContext, portletContext, userContext, names, properties, resetProperties, extensions);
        PropertyList propertyList = new PropertyList();
        propertyList.setProperties(properties.value);
        propertyList.setResetProperties(resetProperties.value);
        propertyList.setExtensions(extensions.value);
        return propertyList;
    }

    public PortletPropertyDescriptionResponse getPortletPropertyDescription(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, String[] desiredLocales) throws Exception {
        ModelDescriptionHolder modelDescription = new ModelDescriptionHolder();
        ResourceListHolder resourceList = new ResourceListHolder();
        ExtensionArrayHolder extensions = new ExtensionArrayHolder();
        this.pt.getPortletPropertyDescription(registrationContext, portletContext, userContext, desiredLocales, modelDescription, resourceList, extensions);
        PortletPropertyDescriptionResponse portletPropertyDescriptionResponse = new PortletPropertyDescriptionResponse();
        portletPropertyDescriptionResponse.setModelDescription(modelDescription.value);
        portletPropertyDescriptionResponse.setResourceList(resourceList.value);
        portletPropertyDescriptionResponse.setExtensions(extensions.value);
        return portletPropertyDescriptionResponse;
    }
}

