/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.client.ArrayEnumeration;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPAttribute
implements Cloneable,
Comparable,
Serializable {
    private String name;
    private String baseName;
    private String[] subTypes = null;
    private Object[] values = null;

    public LDAPAttribute(LDAPAttribute lDAPAttribute) {
        if (lDAPAttribute == null) {
            throw new IllegalArgumentException("LDAPAttribute class cannot be null");
        }
        this.name = lDAPAttribute.name;
        this.baseName = lDAPAttribute.baseName;
        if (null != lDAPAttribute.subTypes) {
            this.subTypes = new String[lDAPAttribute.subTypes.length];
            System.arraycopy(lDAPAttribute.subTypes, 0, this.subTypes, 0, this.subTypes.length);
        }
        if (null != lDAPAttribute.values) {
            this.values = new Object[lDAPAttribute.values.length];
            System.arraycopy(lDAPAttribute.values, 0, this.values, 0, this.values.length);
        }
    }

    public LDAPAttribute(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        this.name = string;
        this.baseName = LDAPAttribute.getBaseName(string);
        this.subTypes = LDAPAttribute.getSubtypes(string);
    }

    public LDAPAttribute(String string, byte[] byArray) {
        this(string);
        if (byArray == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.add(byArray2);
    }

    public LDAPAttribute(String string, String string2) {
        this(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        try {
            this.add(string2.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public LDAPAttribute(String string, String[] stringArray) {
        this(string);
        if (stringArray == null) {
            throw new IllegalArgumentException("Attribute values array cannot be null");
        }
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            try {
                if (stringArray[n] == null) {
                    throw new IllegalArgumentException("Attribute value at array index " + n + " cannot be null");
                }
                this.add(stringArray[n].getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.toString());
            }
            ++n;
        }
    }

    public Object clone() {
        try {
            Object object = super.clone();
            if (this.values != null) {
                System.arraycopy(this.values, 0, ((LDAPAttribute)object).values, 0, this.values.length);
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public void addValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        try {
            this.add(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public void addValue(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(byArray);
    }

    public void addBase64Value(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(Base64.decode(string));
    }

    public void addBase64Value(StringBuffer stringBuffer, int n, int n2) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(Base64.decode(stringBuffer, n, n2));
    }

    public void addBase64Value(char[] cArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(Base64.decode(cArray));
    }

    public void addURLValue(String string) throws MalformedURLException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("Attribute URL cannot be null");
        }
        this.addURLValue(new URL(string));
    }

    public void addURLValue(URL uRL) throws MalformedURLException, IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Attribute URL cannot be null");
        }
        try {
            int n;
            InputStream inputStream = uRL.openStream();
            class URLData {
                private int length;
                private byte[] data;
                private final /* synthetic */ LDAPAttribute this$0;

                URLData(LDAPAttribute lDAPAttribute, byte[] byArray, int n) {
                    this.this$0 = lDAPAttribute;
                    this.length = n;
                    this.data = byArray;
                }

                private int getLength() {
                    return this.length;
                }

                private byte[] getData() {
                    return this.data;
                }
            }
            ArrayList<URLData> arrayList = new ArrayList<URLData>();
            byte[] byArray = new byte[4096];
            int n2 = 0;
            while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
                arrayList.add(new URLData(this, byArray, n));
                byArray = new byte[4096];
                n2 += n;
            }
            byte[] byArray2 = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < arrayList.size()) {
                URLData uRLData = (URLData)arrayList.get(n4);
                n = uRLData.getLength();
                System.arraycopy(uRLData.getData(), 0, byArray2, n3, n);
                n3 += n;
                ++n4;
            }
            this.add(byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public Enumeration getByteValues() {
        return new ArrayEnumeration((Object[])this.getByteValueArray());
    }

    public Enumeration getStringValues() {
        return new ArrayEnumeration(this.getStringValueArray());
    }

    public byte[][] getByteValueArray() {
        if (null == this.values) {
            return new byte[0][];
        }
        int n = this.values.length;
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            byArrayArray[n2] = new byte[((byte[])this.values[n2]).length];
            System.arraycopy(this.values[n2], 0, byArrayArray[n2], 0, byArrayArray[n2].length);
            ++n2;
        }
        return byArrayArray;
    }

    public String[] getStringValueArray() {
        if (null == this.values) {
            return new String[0];
        }
        int n = this.values.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                stringArray[n2] = new String((byte[])this.values[n2], "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.toString());
            }
            ++n2;
        }
        return stringArray;
    }

    public String getStringValue() {
        String string = null;
        if (this.values != null) {
            try {
                string = new String((byte[])this.values[0], "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.toString());
            }
        }
        return string;
    }

    public byte[] getByteValue() {
        byte[] byArray = null;
        if (this.values != null) {
            byArray = new byte[((byte[])this.values[0]).length];
            System.arraycopy(this.values[0], 0, byArray, 0, byArray.length);
        }
        return byArray;
    }

    public String getLangSubtype() {
        if (this.subTypes != null) {
            int n = 0;
            while (n < this.subTypes.length) {
                if (this.subTypes[n].startsWith("lang-")) {
                    return this.subTypes[n];
                }
                ++n;
            }
        }
        return null;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public static String getBaseName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        int n = string.indexOf(59);
        if (-1 == n) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getName() {
        return this.name;
    }

    public String[] getSubtypes() {
        return this.subTypes;
    }

    public static String[] getSubtypes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String[] stringArray = null;
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            stringTokenizer.nextToken();
            stringArray = new String[n - 1];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2++] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    public boolean hasSubtype(String string) {
        if (string == null) {
            throw new IllegalArgumentException("subtype cannot be null");
        }
        if (null != this.subTypes) {
            int n = 0;
            while (n < this.subTypes.length) {
                if (this.subTypes[n].equalsIgnoreCase(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean hasSubtypes(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("subtypes cannot be null");
        }
        int n = 0;
        while (n < stringArray.length) {
            block5: {
                int n2 = 0;
                while (n2 < this.subTypes.length) {
                    if (this.subTypes[n2] == null) {
                        throw new IllegalArgumentException("subtype at array index " + n + " cannot be null");
                    }
                    if (!this.subTypes[n2].equalsIgnoreCase(stringArray[n])) {
                        ++n2;
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public void removeValue(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        try {
            this.removeValue(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public void removeValue(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        int n = 0;
        while (n < this.values.length) {
            if (this.equals(byArray, (byte[])this.values[n])) {
                if (0 == n && 1 == this.values.length) {
                    this.values = null;
                    return;
                }
                if (this.values.length == 1) {
                    this.values = null;
                    break;
                }
                int n2 = this.values.length - n - 1;
                Object[] objectArray = new Object[this.values.length - 1];
                if (n != 0) {
                    System.arraycopy(this.values, 0, objectArray, 0, n);
                }
                if (n2 != 0) {
                    System.arraycopy(this.values, n + 1, objectArray, n, n2);
                }
                this.values = objectArray;
                objectArray = null;
                break;
            }
            ++n;
        }
    }

    public int size() {
        return null == this.values ? 0 : this.values.length;
    }

    public int compareTo(Object object) {
        return this.name.compareTo(((LDAPAttribute)object).name);
    }

    private void add(byte[] byArray) {
        if (null == this.values) {
            this.values = new Object[]{byArray};
        } else {
            int n = 0;
            while (n < this.values.length) {
                if (this.equals(byArray, (byte[])this.values[n])) {
                    return;
                }
                ++n;
            }
            Object[] objectArray = new Object[this.values.length + 1];
            System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
            objectArray[this.values.length] = byArray;
            this.values = objectArray;
            objectArray = null;
        }
    }

    protected void setValue(String string) {
        this.values = null;
        try {
            this.add(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    private boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n = byArray.length;
        if (byArray2.length != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPAttribute: ");
        try {
            stringBuffer.append("{type='" + this.name + "'");
            if (this.values != null) {
                stringBuffer.append(", ");
                if (this.values.length == 1) {
                    stringBuffer.append("value='");
                } else {
                    stringBuffer.append("values='");
                }
                int n = 0;
                while (n < this.values.length) {
                    if (n != 0) {
                        stringBuffer.append("','");
                    }
                    if (((byte[])this.values[n]).length != 0) {
                        String string = new String((byte[])this.values[n], "UTF-8");
                        if (string.length() == 0) {
                            stringBuffer.append("<binary value, length:" + string.length());
                        } else {
                            stringBuffer.append(string);
                        }
                    }
                    ++n;
                }
                stringBuffer.append("'");
            }
            stringBuffer.append("}");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return stringBuffer.toString();
    }

    void newLine(int n, Writer writer) throws IOException {
        String string = "    ";
        writer.write("\n");
        int n2 = 0;
        while (n2 < n) {
            writer.write(string);
            ++n2;
        }
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<LDAPAttribute>");
        this.newLine(1, outputStreamWriter);
        outputStreamWriter.write("<attr name=\"");
        outputStreamWriter.write(this.getName());
        outputStreamWriter.write("\">");
        String[] stringArray = this.getStringValueArray();
        byte[][] byArray = this.getByteValueArray();
        int n = 0;
        while (n < stringArray.length) {
            this.newLine(2, outputStreamWriter);
            if (Base64.isValidUTF8(byArray[n], false)) {
                outputStreamWriter.write("<value>");
                outputStreamWriter.write(stringArray[n]);
                outputStreamWriter.write("</value>");
            } else {
                outputStreamWriter.write("<value xsi:type=\"xsd:base64Binary\">");
                outputStreamWriter.write(Base64.encode(byArray[n]));
                outputStreamWriter.write("</value>");
            }
            ++n;
        }
        this.newLine(1, outputStreamWriter);
        outputStreamWriter.write("</attr>");
        this.newLine(0, outputStreamWriter);
        outputStreamWriter.write("</LDAPAttribute>");
        ((Writer)outputStreamWriter).close();
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPAttribute.getXMLHandler("attr", null));
        return (LDAPAttribute)sAXEventMultiplexer.parseXML(inputStream);
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                LDAPAttribute lDAPAttribute = new LDAPAttribute(this.attrName);
                Iterator iterator = this.valuelist.iterator();
                while (iterator.hasNext()) {
                    lDAPAttribute.addValue((byte[])iterator.next());
                }
                this.setObject(lDAPAttribute);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

