/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPDN;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPEntry
implements Comparable,
Serializable {
    protected String dn;
    protected LDAPAttributeSet attrs;

    public LDAPEntry() {
        this(null, null);
    }

    public LDAPEntry(String string) {
        this(string, null);
    }

    public LDAPEntry(String string, LDAPAttributeSet lDAPAttributeSet) {
        if (string == null) {
            string = "";
        }
        if (lDAPAttributeSet == null) {
            lDAPAttributeSet = new LDAPAttributeSet();
        }
        this.dn = string;
        this.attrs = lDAPAttributeSet;
    }

    public LDAPAttribute getAttribute(String string) {
        return this.attrs.getAttribute(string);
    }

    public LDAPAttributeSet getAttributeSet() {
        return this.attrs;
    }

    public LDAPAttributeSet getAttributeSet(String string) {
        return this.attrs.getSubset(string);
    }

    public String getDN() {
        return this.dn;
    }

    public int compareTo(Object object) {
        return LDAPDN.normalize(this.dn).compareTo(LDAPDN.normalize(((LDAPEntry)object).dn));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPEntry: ");
        if (this.dn != null) {
            stringBuffer.append(this.dn + "; ");
        }
        if (this.attrs != null) {
            stringBuffer.append(this.attrs.toString());
        }
        return stringBuffer.toString();
    }

    void newLine(int n, Writer writer) throws IOException {
        String string = "    ";
        writer.write("\n");
        int n2 = 0;
        while (n2 < n) {
            writer.write(string);
            ++n2;
        }
    }

    private void writeAttribute(LDAPAttribute lDAPAttribute, Writer writer) throws IOException {
        this.newLine(2, writer);
        writer.write("<attr name=\"");
        writer.write(lDAPAttribute.getName());
        writer.write("\">");
        String[] stringArray = lDAPAttribute.getStringValueArray();
        byte[][] byArray = lDAPAttribute.getByteValueArray();
        int n = 0;
        while (n < stringArray.length) {
            this.newLine(3, writer);
            if (Base64.isValidUTF8(byArray[n], false)) {
                writer.write("<value>");
                writer.write(stringArray[n]);
                writer.write("</value>");
            } else {
                writer.write("<value xsi:type=\"xsd:base64Binary\">");
                writer.write(Base64.encode(byArray[n]));
                writer.write("</value>");
            }
            ++n;
        }
        this.newLine(2, writer);
        writer.write("</attr>");
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<LDAPEntry dn=\"");
        outputStreamWriter.write(this.getDN());
        outputStreamWriter.write("\">");
        Iterator iterator = this.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            this.writeAttribute((LDAPAttribute)iterator.next(), outputStreamWriter);
        }
        this.newLine(0, outputStreamWriter);
        outputStreamWriter.write("</LDAPEntry>");
        ((Writer)outputStreamWriter).close();
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPEntry.getXMLHandler("LDAPEntry", null));
        return (LDAPEntry)sAXEventMultiplexer.parseXML(inputStream);
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String dn;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttribute.getXMLHandler("attr", this));
            }

            protected void endElement() {
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.addAll((Collection)this.valuelist);
                LDAPEntry lDAPEntry = new LDAPEntry(this.dn, lDAPAttributeSet);
                this.setObject(lDAPEntry);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.dn = attributes.getValue("dn");
                if (this.dn == null) {
                    throw new SAXException("invalid entry Tag, dn is mandatory element: ");
                }
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

