/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;

public class LDAPExtendedOperation
implements Cloneable,
Serializable {
    private String oid;
    private byte[] vals;

    public LDAPExtendedOperation(String string, byte[] byArray) {
        this.oid = string;
        this.vals = byArray;
    }

    public Object clone() {
        try {
            Object object = super.clone();
            System.arraycopy(this.vals, 0, ((LDAPExtendedOperation)object).vals, 0, this.vals.length);
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public String getID() {
        return this.oid;
    }

    public byte[] getValue() {
        return this.vals;
    }

    protected void setValue(byte[] byArray) {
        this.vals = byArray;
    }

    protected void setID(String string) {
        this.oid = string;
    }

    void newLine(int n, Writer writer) throws IOException {
        String string = "    ";
        writer.write("\n");
        int n2 = 0;
        while (n2 < n) {
            writer.write(string);
            ++n2;
        }
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<extendedRequest>");
        this.newLine(1, outputStreamWriter);
        outputStreamWriter.write("<requestName>");
        outputStreamWriter.write(this.getID());
        outputStreamWriter.write("</requestName>");
        byte[] byArray = this.getValue();
        if (byArray != null) {
            this.newLine(1, outputStreamWriter);
            outputStreamWriter.write("<requestValue xsi:type=\"xsd:base64Binary\">");
            outputStreamWriter.write(Base64.encode(byArray));
            outputStreamWriter.write("</requestValue>");
        }
        this.newLine(0, outputStreamWriter);
        outputStreamWriter.write("</extendedRequest>");
        ((Writer)outputStreamWriter).close();
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPExtendedOperation.getXMLHandler("LDAPExtendedOperation", null));
        return (LDAPExtendedOperation)sAXEventMultiplexer.parseXML(inputStream);
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String requestName;
            byte[] requestValue;

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler("requestName", this));
                this.setchildelement(new ValueXMLhandler("requestValue", this));
            }

            protected void endElement() {
                LDAPExtendedOperation lDAPExtendedOperation = new LDAPExtendedOperation(this.requestName, this.requestValue);
                this.setObject(lDAPExtendedOperation);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("requestName")) {
                    this.requestName = new String((byte[])object);
                } else if (string.equals("requestValue")) {
                    this.requestValue = (byte[])object;
                }
            }
        };
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LDAPExtendedOperation:");
        stringBuffer.append("((requestName=" + this.getID());
        stringBuffer.append("),(requestValue=" + this.getValue() + "))");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

