/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.InterThreadException;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPUrl;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.client.ReferralInfo;
import com.novell.ldap.rfc2251.RfcAddResponse;
import com.novell.ldap.rfc2251.RfcCompareResponse;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcDelResponse;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcLDAPResult;
import com.novell.ldap.rfc2251.RfcLDAPString;
import com.novell.ldap.rfc2251.RfcModifyDNResponse;
import com.novell.ldap.rfc2251.RfcModifyResponse;
import com.novell.ldap.rfc2251.RfcReferral;
import com.novell.ldap.rfc2251.RfcResponse;
import com.novell.ldap.rfc2251.RfcSearchResultDone;
import java.net.MalformedURLException;

public class LDAPResponse
extends LDAPMessage {
    private InterThreadException exception = null;
    private ReferralInfo activeReferral;

    public LDAPResponse(InterThreadException interThreadException, ReferralInfo referralInfo) {
        this.exception = interThreadException;
        this.activeReferral = referralInfo;
    }

    LDAPResponse(RfcLDAPMessage rfcLDAPMessage) {
        super(rfcLDAPMessage);
    }

    public LDAPResponse(int n) {
        this(n, 0, null, null, null, null);
    }

    public LDAPResponse(int n, int n2, String string, String string2, String[] stringArray, LDAPControl[] lDAPControlArray) {
        super(new RfcLDAPMessage(LDAPResponse.RfcResultFactory(n, n2, string, string2, stringArray)));
    }

    private static RfcControls RfcControlFactory(LDAPControl[] lDAPControlArray) {
        RfcControls rfcControls = new RfcControls();
        if (lDAPControlArray != null) {
            int n = 0;
            while (n < lDAPControlArray.length) {
                rfcControls.add(lDAPControlArray[n].getASN1Object());
                ++n;
            }
            return rfcControls;
        }
        return null;
    }

    private static ASN1Sequence RfcResultFactory(int n, int n2, String string, String string2, String[] stringArray) {
        RfcLDAPResult rfcLDAPResult;
        RfcReferral rfcReferral = null;
        if (stringArray != null) {
            try {
                rfcReferral = new RfcReferral(stringArray);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        switch (n) {
            case 5: {
                rfcLDAPResult = new RfcSearchResultDone(new ASN1Enumerated(n2), new RfcLDAPDN(string), new RfcLDAPString(string2), rfcReferral);
                break;
            }
            case 1: {
                rfcLDAPResult = null;
                break;
            }
            case 4: {
                rfcLDAPResult = null;
                break;
            }
            case 7: {
                rfcLDAPResult = new RfcModifyResponse(new ASN1Enumerated(n2), new RfcLDAPDN(string), new RfcLDAPString(string2), rfcReferral);
                break;
            }
            case 9: {
                rfcLDAPResult = new RfcAddResponse(new ASN1Enumerated(n2), new RfcLDAPDN(string), new RfcLDAPString(string2), rfcReferral);
                break;
            }
            case 11: {
                rfcLDAPResult = new RfcDelResponse(new ASN1Enumerated(n2), new RfcLDAPDN(string), new RfcLDAPString(string2), rfcReferral);
                break;
            }
            case 13: {
                rfcLDAPResult = new RfcModifyDNResponse(new ASN1Enumerated(n2), new RfcLDAPDN(string), new RfcLDAPString(string2), rfcReferral);
                break;
            }
            case 15: {
                rfcLDAPResult = new RfcCompareResponse(new ASN1Enumerated(n2), new RfcLDAPDN(string), new RfcLDAPString(string2), rfcReferral);
                break;
            }
            case 19: {
                rfcLDAPResult = null;
                break;
            }
            case 24: {
                rfcLDAPResult = null;
                break;
            }
            default: {
                throw new RuntimeException("Type " + n + " Not Supported");
            }
        }
        return rfcLDAPResult;
    }

    public String getErrorMessage() {
        if (this.exception != null) {
            return this.exception.getLDAPErrorMessage();
        }
        return ((RfcResponse)((Object)this.message.getResponse())).getErrorMessage().stringValue();
    }

    public String getMatchedDN() {
        if (this.exception != null) {
            return this.exception.getMatchedDN();
        }
        return ((RfcResponse)((Object)this.message.getResponse())).getMatchedDN().stringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getReferrals() {
        String[] stringArray = null;
        RfcReferral rfcReferral = ((RfcResponse)((Object)this.message.getResponse())).getReferral();
        if (rfcReferral == null) {
            stringArray = new String[]{};
        } else {
            int n = rfcReferral.size();
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                Object var10_10;
                String string = ((ASN1OctetString)rfcReferral.get(n2)).stringValue();
                try {
                    block7: {
                        try {
                            RfcLDAPMessage rfcLDAPMessage;
                            String string2;
                            LDAPUrl lDAPUrl = new LDAPUrl(string);
                            if (lDAPUrl.getDN() != null || (string2 = (rfcLDAPMessage = super.getASN1Object().getRequestingMessage().getASN1Object()).getRequestDN()) == null) break block7;
                            lDAPUrl.setDN(string2);
                            string = lDAPUrl.toString();
                        }
                        catch (MalformedURLException malformedURLException) {
                            var10_10 = null;
                            stringArray[n2] = string;
                        }
                    }
                    var10_10 = null;
                    stringArray[n2] = string;
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    stringArray[n2] = string;
                    throw throwable;
                }
                ++n2;
            }
        }
        return stringArray;
    }

    public int getResultCode() {
        if (this.exception != null) {
            return this.exception.getResultCode();
        }
        return ((RfcResponse)((Object)this.message.getResponse())).getResultCode().intValue();
    }

    void chkResultCode() throws LDAPException {
        if (this.exception != null) {
            throw this.exception;
        }
        LDAPException lDAPException = this.getResultException();
        if (lDAPException != null) {
            throw lDAPException;
        }
    }

    LDAPException getResultException() {
        LDAPException lDAPException = null;
        switch (this.getResultCode()) {
            case 0: 
            case 5: 
            case 6: {
                break;
            }
            case 10: {
                String[] stringArray = this.getReferrals();
                lDAPException = new LDAPReferralException("Automatic referral following not enabled", 10, this.getErrorMessage());
                lDAPException.setReferrals(stringArray);
                break;
            }
            default: {
                lDAPException = new LDAPException(LDAPException.resultCodeToString(this.getResultCode()), this.getResultCode(), this.getErrorMessage(), this.getMatchedDN());
            }
        }
        return lDAPException;
    }

    public LDAPControl[] getControls() {
        if (this.exception != null) {
            return null;
        }
        return super.getControls();
    }

    public int getMessageID() {
        if (this.exception != null) {
            return this.exception.getMessageID();
        }
        return super.getMessageID();
    }

    public int getType() {
        if (this.exception != null) {
            return this.exception.getReplyType();
        }
        return super.getType();
    }

    boolean hasException() {
        return this.exception != null;
    }

    LDAPException getException() {
        return this.exception;
    }

    ReferralInfo getActiveReferral() {
        return this.activeReferral;
    }
}

