/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.client.ReferralInfo;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Vector;

public class LDAPSearchResults {
    private Vector entries;
    private int entryCount;
    private int entryIndex;
    private Vector references;
    private int referenceCount;
    private int referenceIndex;
    private int batchSize;
    private boolean completed = false;
    private LDAPControl[] controls = null;
    private LDAPSearchQueue queue;
    private static Object nameLock = new Object();
    private static int resultsNum = 0;
    private String name;
    private LDAPConnection conn;
    private LDAPSearchConstraints cons;
    private ArrayList referralConn = null;

    LDAPSearchResults(LDAPConnection lDAPConnection, LDAPSearchQueue lDAPSearchQueue, LDAPSearchConstraints lDAPSearchConstraints) {
        this.conn = lDAPConnection;
        this.cons = lDAPSearchConstraints;
        int n = lDAPSearchConstraints.getBatchSize();
        int n2 = n == 0 ? 64 : 0;
        this.entries = new Vector(n == 0 ? 64 : n, n2);
        this.entryCount = 0;
        this.entryIndex = 0;
        this.references = new Vector(5, 5);
        this.referenceCount = 0;
        this.referenceIndex = 0;
        this.queue = lDAPSearchQueue;
        this.batchSize = n == 0 ? Integer.MAX_VALUE : n;
    }

    public int getCount() {
        int n = this.queue.getMessageAgent().getCount();
        return this.entryCount - this.entryIndex + this.referenceCount - this.referenceIndex + n;
    }

    public LDAPControl[] getResponseControls() {
        return this.controls;
    }

    public boolean hasMore() {
        boolean bl = false;
        if (this.entryIndex < this.entryCount || this.referenceIndex < this.referenceCount) {
            bl = true;
        } else if (!this.completed) {
            this.resetVectors();
            bl = this.entryIndex < this.entryCount || this.referenceIndex < this.referenceCount;
        }
        return bl;
    }

    private void resetVectors() {
        if (this.completed) {
            return;
        }
        if (this.referenceIndex != 0 && this.referenceIndex >= this.referenceCount) {
            this.references.setSize(0);
            this.referenceCount = 0;
            this.referenceIndex = 0;
        }
        if (this.entryIndex != 0 && this.entryIndex >= this.entryCount) {
            this.entries.setSize(0);
            this.entryCount = 0;
            this.entryIndex = 0;
        }
        if (this.referenceIndex == 0 && this.referenceCount == 0 && this.entryIndex == 0 && this.entryCount == 0) {
            this.completed = this.getBatchOfResults();
        }
    }

    public LDAPEntry next() throws LDAPException {
        if (this.completed && this.entryIndex >= this.entryCount && this.referenceIndex >= this.referenceCount) {
            throw new NoSuchElementException("LDAPSearchResults.next() no more results");
        }
        this.resetVectors();
        Object var1_1 = null;
        if (this.referenceIndex < this.referenceCount) {
            String[] stringArray = (String[])this.references.elementAt(this.referenceIndex++);
            LDAPReferralException lDAPReferralException = new LDAPReferralException("REFERENCE_NOFOLLOW");
            lDAPReferralException.setReferrals(stringArray);
            throw lDAPReferralException;
        }
        if (this.entryIndex < this.entryCount) {
            if ((var1_1 = this.entries.elementAt(this.entryIndex++)) instanceof LDAPResponse) {
                LDAPResponse lDAPResponse;
                ReferralInfo referralInfo;
                if (((LDAPResponse)var1_1).hasException() && (referralInfo = (lDAPResponse = (LDAPResponse)var1_1).getActiveReferral()) != null) {
                    LDAPReferralException lDAPReferralException = new LDAPReferralException("REFERENCE_ERROR", lDAPResponse.getException());
                    lDAPReferralException.setReferrals(referralInfo.getReferralList());
                    lDAPReferralException.setFailedReferral(referralInfo.getReferralUrl().toString());
                    throw lDAPReferralException;
                }
                ((LDAPResponse)var1_1).chkResultCode();
            } else if (var1_1 instanceof LDAPException) {
                throw (LDAPException)var1_1;
            }
        } else {
            throw new LDAPException("REFERRAL_LOCAL", new Object[]{"next"}, 82, (String)null);
        }
        return var1_1;
    }

    private boolean getBatchOfResults() {
        int n = 0;
        while (n < this.batchSize) {
            try {
                Object object;
                LDAPMessage lDAPMessage = this.queue.getResponse();
                if (lDAPMessage != null) {
                    String[] stringArray;
                    object = lDAPMessage.getControls();
                    if (object != null) {
                        this.controls = object;
                    }
                    if (lDAPMessage instanceof LDAPSearchResult) {
                        stringArray = ((LDAPSearchResult)lDAPMessage).getEntry();
                        this.entries.addElement(stringArray);
                        ++n;
                        ++this.entryCount;
                        continue;
                    }
                    if (lDAPMessage instanceof LDAPSearchResultReference) {
                        stringArray = ((LDAPSearchResultReference)lDAPMessage).getReferrals();
                        if (this.cons.getReferralFollowing()) {
                            this.referralConn = this.conn.chaseReferral(this.queue, this.cons, lDAPMessage, stringArray, 0, true, this.referralConn);
                            continue;
                        }
                        this.references.addElement(stringArray);
                        ++this.referenceCount;
                        continue;
                    }
                    stringArray = (LDAPResponse)lDAPMessage;
                    int n2 = stringArray.getResultCode();
                    if (stringArray.hasException()) {
                        n2 = 91;
                    }
                    if (n2 == 10 && this.cons.getReferralFollowing()) {
                        this.referralConn = this.conn.chaseReferral(this.queue, this.cons, (LDAPMessage)stringArray, stringArray.getReferrals(), 0, false, this.referralConn);
                    } else if (n2 != 0) {
                        this.entries.addElement(stringArray);
                        ++this.entryCount;
                    }
                    int[] nArray = this.queue.getMessageIDs();
                    if (nArray.length != 0) continue;
                    this.conn.releaseReferralConnections(this.referralConn);
                    return true;
                }
                object = new LDAPException(null, 85, null);
                this.entries.addElement(object);
                break;
            }
            catch (LDAPException lDAPException) {
                this.entries.addElement(lDAPException);
            }
        }
        return false;
    }

    void abandon() {
        this.queue.getMessageAgent().abandonAll();
        this.resetVectors();
        this.completed = true;
    }
}

