/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import java.io.IOException;
import java.util.Enumeration;

public class LDAPSyntaxSchema
extends LDAPSchemaElement {
    public LDAPSyntaxSchema(String string, String string2) {
        super(LDAPSchema.schemaTypeNames[2]);
        this.oid = string;
        this.description = string2;
        super.setValue(this.formatString());
    }

    public LDAPSyntaxSchema(String string) {
        super(LDAPSchema.schemaTypeNames[2]);
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            if (schemaParser.getID() != null) {
                this.oid = schemaParser.getID();
            }
            if (schemaParser.getDescription() != null) {
                this.description = schemaParser.getDescription();
            }
            Enumeration enumeration = schemaParser.getQualifiers();
            while (enumeration.hasMoreElements()) {
                AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                this.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    protected String formatString() {
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if ((enumeration = this.getQualifierNames()) != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                stringBuffer.append(" " + string2 + " ");
                String[] stringArray = this.getQualifier(string2);
                if (stringArray == null || stringArray.length <= 1) continue;
                stringBuffer.append("( ");
                int n = 0;
                while (n < stringArray.length) {
                    if (n > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("'" + stringArray[n] + "'");
                    ++n;
                }
                if (stringArray.length <= 1) continue;
                stringBuffer.append(" )");
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

