/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.index;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LuceneIndexer {
    private static final String DOC_ID = "documentId";
    private String indexDb;

    public LuceneIndexer(String indexDb) {
        this.indexDb = indexDb;
    }

    public void removeIndex(String docId) throws IOException {
        FSDirectory directory = FSDirectory.getDirectory((String)this.indexDb, (boolean)false);
        IndexReader reader = IndexReader.open((Directory)directory);
        Term deleteTerm = new Term(DOC_ID, docId);
        reader.delete(deleteTerm);
        reader.close();
        directory.close();
    }

    public void index(String docId, Reader reader) throws Exception {
        IndexWriter writer = new IndexWriter(this.indexDb, (Analyzer)new StandardAnalyzer(), false);
        Document doc = new Document();
        doc.add(Field.Text((String)"contents", (Reader)reader));
        Field field = new Field(DOC_ID, docId, true, true, true);
        doc.add(field);
        writer.addDocument(doc);
        writer.optimize();
        writer.close();
    }

    private static Reader getReader(String file) throws IOException {
        FileReader reader = new FileReader(file);
        return reader;
    }

    private Set contains(String stringToFind) throws Exception {
        HashSet<String> resultSet = new HashSet<String>();
        IndexSearcher searcher = new IndexSearcher(this.indexDb);
        StandardAnalyzer analyzer = new StandardAnalyzer();
        Query query = QueryParser.parse((String)stringToFind, (String)"contents", (Analyzer)analyzer);
        Hits hits = searcher.search(query);
        int noOfHits = hits.length();
        for (int i = 0; i < noOfHits; ++i) {
            Document doc = hits.doc(i);
            String docId = doc.get(DOC_ID);
            resultSet.add(docId);
        }
        searcher.close();
        return resultSet;
    }

    public static void main(String[] args) throws Exception {
        String INDEX_DB = "D:\\projects\\tmp\\index";
        LuceneIndexer indexer = new LuceneIndexer(INDEX_DB);
        IndexWriter writer = new IndexWriter(INDEX_DB, (Analyzer)new StandardAnalyzer(), true);
        writer.close();
        String ottoFile = "otto.txt";
        new LuceneIndexer(INDEX_DB).index(ottoFile, LuceneIndexer.getReader(ottoFile));
        System.out.println("expect one element otto.txt");
        LuceneIndexer.displayResult(indexer.contains("otto"));
        new LuceneIndexer(INDEX_DB).index("fritz.txt", LuceneIndexer.getReader("fritz.txt"));
        System.out.println("expect fritz.txt");
        LuceneIndexer.displayResult(indexer.contains("fritz"));
        System.out.println("expect fritz.txt and otto.txt");
        LuceneIndexer.displayResult(indexer.contains("Hallo"));
        new LuceneIndexer(INDEX_DB).removeIndex("otto.txt");
        System.out.println("expect fritz.txt");
        LuceneIndexer.displayResult(indexer.contains("Hallo"));
        System.out.println("expect null");
        LuceneIndexer.displayResult(indexer.contains("otto"));
        new LuceneIndexer(INDEX_DB).removeIndex("fritz.txt");
        System.out.println("expect null");
        LuceneIndexer.displayResult(indexer.contains("fritz"));
    }

    private static void displayResult(Set result) {
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            System.out.println(element);
        }
    }
}

