/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.store.impl.rdbms.MySqlRDBMSAdapter;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.logger.Logger;

public class MySql41RDBMSAdapter
extends MySqlRDBMSAdapter {
    public MySql41RDBMSAdapter(Service service, Logger logger) {
        super(service, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(Connection connection, Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        PreparedStatement statement = null;
        try {
            this.clearBinding(connection, uri);
            try {
                statement = connection.prepareStatement("delete l from LINKS l, URI u where l.URI_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete vh from VERSION_HISTORY vh, URI u where vh.URI_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete v from VERSION v, URI u where v.URI_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete o from OBJECT o, URI u where o.URI_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete from URI where URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionContent(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        try {
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement("delete vc from VERSION_CONTENT vc, VERSION_HISTORY vh, URI u where vc.VERSION_ID = vh.VERSION_ID and vh.REVISION_NO = ? and vh.URI_ID=u.URI_ID AND u.URI_STRING=?");
                statement.setString(1, revisionDescriptor.getRevisionNumber().toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionDescriptor(Connection connection, Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete vl from VERSION_LABELS vl, VERSION_HISTORY vh, URI u where vl.VERSION_ID = vh.VERSION_ID and vh.REVISION_NO = ? and vh.URI_ID = u.URI_ID AND u.URI_STRING = ?");
                statement.setString(1, revisionNumber.toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete p from PROPERTIES p, VERSION_HISTORY vh, URI u where p.VERSION_ID = vh.VERSION_ID and vh.REVISION_NO = ? and vh.URI_ID = u.URI_ID AND u.URI_STRING = ?");
                statement.setString(1, revisionNumber.toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    public void removeRevisionDescriptors(Connection connection, Uri uri) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("delete vp from VERSION_PREDS vp, VERSION_HISTORY vh, URI u where vp.VERSION_ID = vh.VERSION_ID and vh.URI_ID = u.URI_ID and u.URI_STRING = ?");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
        finally {
            this.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearBinding(Connection connection, Uri uri) throws ServiceAccessException, ObjectNotFoundException, SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("delete c from BINDING c, URI u where c.URI_ID = u.URI_ID and u.URI_STRING = ?");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
        }
        finally {
            this.close(statement);
        }
        try {
            statement = connection.prepareStatement("delete c from PARENT_BINDING c, URI u where c.URI_ID = u.URI_ID and u.URI_STRING = ?");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
        }
        finally {
            this.close(statement);
        }
    }
}

