/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms.expression;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.search.SearchException;
import org.apache.slide.search.basic.IBasicResultSet;
import org.apache.slide.store.impl.rdbms.expression.RDBMSExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSExpressionFactory;
import org.apache.slide.store.impl.rdbms.expression.RDBMSMergeExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSQueryContext;
import org.jdom.Element;

public class RDBMSCompareExpression
extends RDBMSExpression {
    static final HashMap COMPARE_OPERATORS = new HashMap(11);
    protected final Element _element;
    protected int _tableIndex = -1;
    private Element _property;

    public RDBMSCompareExpression(Element element, RDBMSQueryContext context) {
        super(context);
        this._element = element;
    }

    public IBasicResultSet execute() throws SearchException {
        return this.compile(null);
    }

    protected IBasicResultSet compile(RDBMSMergeExpression expression) {
        if (expression != null && expression.getName().equals("or")) {
            Iterator iter = expression.getRDBMSExpressions().iterator();
            while (iter.hasNext()) {
                RDBMSExpression e = (RDBMSExpression)iter.next();
                if (!(e instanceof RDBMSCompareExpression)) continue;
                this._tableIndex = ((RDBMSCompareExpression)e).getTableIndex();
                if (this._tableIndex == -1) continue;
                break;
            }
        }
        if (this._tableIndex == -1) {
            this._tableIndex = this._context.joins().size();
        }
        this._context.joins().add(this.join());
        this._context.criteria().add(this.compile());
        String selectKey = this.getPropertyNamespace() + this.getPropertyName();
        this._context.selects().put(selectKey, this.select());
        return this._context.results();
    }

    protected String compile() {
        Element literal = this._element.getChild("literal", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        return "(p" + this._tableIndex + ".PROPERTY_NAME = '" + this.getPropertyName() + "' AND " + "p" + this._tableIndex + ".PROPERTY_NAMESPACE = '" + this.getPropertyNamespace() + "' AND " + "p" + this._tableIndex + ".PROPERTY_VALUE " + COMPARE_OPERATORS.get(this._element.getName()) + " '" + literal.getTextNormalize() + "')";
    }

    protected String join() {
        return "inner join PROPERTIES p" + this._tableIndex + " on p" + this._tableIndex + ".VERSION_ID = vh.VERSION_ID";
    }

    protected String select() {
        return "p" + this._tableIndex + ".PROPERTY_VALUE AS " + RDBMSExpressionFactory.propertyToAlias(this.getPropertyName());
    }

    protected int getTableIndex() {
        return this._tableIndex;
    }

    protected Element getProperty() {
        if (this._property == null) {
            this._property = (Element)this._element.getChild("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE).getChildren().get(0);
        }
        return this._property;
    }

    protected String getPropertyName() {
        return this.getProperty().getName();
    }

    protected String getPropertyNamespace() {
        return this.getProperty().getNamespaceURI();
    }

    static {
        COMPARE_OPERATORS.put("eq", "=");
        COMPARE_OPERATORS.put("gt", ">");
        COMPARE_OPERATORS.put("gte", ">=");
        COMPARE_OPERATORS.put("lt", "<");
        COMPARE_OPERATORS.put("lte", "<=");
        COMPARE_OPERATORS.put("not-eq", "<>");
        COMPARE_OPERATORS.put("not-gt", COMPARE_OPERATORS.get("LTE"));
        COMPARE_OPERATORS.put("not-gte", COMPARE_OPERATORS.get("LT"));
        COMPARE_OPERATORS.put("not-lt", COMPARE_OPERATORS.get("GTE"));
        COMPARE_OPERATORS.put("not-lte", COMPARE_OPERATORS.get("GT"));
    }
}

