/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.mem;

import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.mem.AbstractTransientStore;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;

public class TransientNodeStore
extends AbstractTransientStore
implements NodeStore {
    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        this.debug("retrieveObject {0}", uri);
        ObjectNode node = (ObjectNode)this.get(uri.toString());
        if (node != null) {
            return node;
        }
        throw new ObjectNotFoundException(uri);
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        this.debug("storeObejct {0}", uri);
        ObjectNode node = (ObjectNode)this.get(uri.toString());
        if (node == null) {
            throw new ObjectNotFoundException(uri);
        }
        this.put(uri.toString(), object);
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        this.debug("createObject {0}", uri);
        ObjectNode node = (ObjectNode)this.get(uri.toString());
        if (node != null) {
            throw new ObjectAlreadyExistsException(uri.toString());
        }
        this.put(uri.toString(), object);
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        this.debug("removeObject {0}", uri);
        ObjectNode node = (ObjectNode)this.get(uri.toString());
        if (node == null) {
            throw new ObjectNotFoundException(uri);
        }
        this.remove(uri.toString());
    }
}

