/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.mem;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.mem.AbstractTransientStore;

public class TransientSecurityStore
extends AbstractTransientStore
implements SecurityStore {
    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        this.debug("grantPermission {0} {1}", uri, permission);
        ArrayList<Object> list = (ArrayList<NodePermission>)this.get(uri.toString());
        list = list != null ? new ArrayList(list) : new ArrayList<NodePermission>();
        list.add(permission);
        this.put(uri.toString(), list);
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        this.debug("revokePermission {0} {1}", uri, permission);
        ArrayList list = (ArrayList)this.get(uri.toString());
        if (list != null && (list = new ArrayList(list)).remove(permission)) {
            if (list.size() > 0) {
                this.put(uri.toString(), list);
            } else {
                this.remove(uri.toString());
            }
        }
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        this.debug("revokePermissions {0}", uri);
        List list = (List)this.get(uri.toString());
        if (list != null) {
            this.remove(uri.toString());
        }
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        this.debug("enumeratePermissions {0}", uri);
        List list = (List)this.get(uri.toString());
        if (list != null) {
            return new AbstractTransientStore.IteratorEnum(list.iterator());
        }
        return EMPTY_ENUM;
    }
}

