/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.txfile;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.txfile.AbstractTxFileStoreService;
import org.apache.slide.store.txfile.XMLResourceDescriptor;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;

public class TxXMLFileDescriptorsStore
extends AbstractTxFileStoreService
implements NodeStore,
LockStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore {
    protected static final String LOG_CHANNEL = "file-meta-store";
    protected static final int DEBUG_LEVEL = 7;
    protected static final String ENCODING_PARAMETER = "encoding";
    protected static final String DEFER_SAVING_PARAMETER = "defer-saving";
    protected String characterEncoding = "UTF-8";
    protected boolean deferSaving = false;
    protected Map suspendedContexts = new HashMap();
    protected Map activeContexts = new HashMap();

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        String deferSavingString;
        super.setParameters(parameters);
        String encoding = (String)parameters.get(ENCODING_PARAMETER);
        if (encoding != null) {
            this.characterEncoding = encoding;
        }
        if ((deferSavingString = (String)parameters.get(DEFER_SAVING_PARAMETER)) != null) {
            this.deferSaving = Boolean.valueOf(deferSavingString);
            if (this.deferSaving) {
                this.getLogger().log((Object)"Enabling deferred saving", LOG_CHANNEL, 6);
            }
        }
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
        ObjectNode object = xfd.retrieveObject();
        return object;
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
        xfd.storeObject(object);
        if (this.deferSaving) {
            xfd.registerForSaving();
        } else {
            xfd.save();
        }
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.create();
            xfd.storeObject(object);
            if (this.deferSaving) {
                xfd.registerForSaving();
                TxContext txContext = this.getActiveTxContext();
                if (txContext != null) {
                    txContext.register(uri, xfd);
                }
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError("Newly created file vanished");
        }
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        TxContext txContext;
        XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
        xfd.delete();
        if (this.deferSaving && (txContext = this.getActiveTxContext()) != null) {
            txContext.deregister(uri);
        }
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.grantPermission(permission);
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.revokePermission(permission);
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.revokePermissions();
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            return xfd.enumeratePermissions();
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
            return null;
        }
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.putLock(lock);
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.renewLock(lock);
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.removeLock(lock);
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            throw new LockTokenNotFoundException(lock);
        }
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.removeLock(uri, lock);
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            return xfd.enumerateLocks();
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
            return null;
        }
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            return xfd.retrieveRevisionDescriptors();
        }
        catch (ObjectNotFoundException e) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.createRevisionDescriptors(revisionDescriptors);
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.storeRevisionDescriptors(revisionDescriptors);
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.removeRevisionDescriptors();
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            return xfd.retrieveRevisionDescriptor(revisionNumber);
        }
        catch (ObjectNotFoundException e) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.createRevisionDescriptor(revisionDescriptor);
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.storeRevisionDescriptor(revisionDescriptor);
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.removeRevisionDescriptor(number);
            if (this.deferSaving) {
                xfd.registerForSaving();
            } else {
                xfd.save();
            }
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public String toString() {
        return "TxXMLFileDescriptorsStore at " + this.storeDir + "  working on " + this.workDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            super.commit(xid, onePhase);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            String txId = this.wrap(xid);
            this.activeContexts.remove(txId);
            this.suspendedContexts.remove(txId);
            this.activeTransactionBranch.set(null);
            throw throwable;
        }
        String txId = this.wrap(xid);
        this.activeContexts.remove(txId);
        this.suspendedContexts.remove(txId);
        this.activeTransactionBranch.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(Xid xid) throws XAException {
        try {
            super.rollback(xid);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            String txId = this.wrap(xid);
            this.activeContexts.remove(txId);
            this.suspendedContexts.remove(txId);
            this.activeTransactionBranch.set(null);
            throw throwable;
        }
        String txId = this.wrap(xid);
        this.activeContexts.remove(txId);
        this.suspendedContexts.remove(txId);
        this.activeTransactionBranch.set(null);
    }

    public synchronized int prepare(Xid xid) throws XAException {
        String txId = this.wrap(xid);
        this.getLogger().log((Object)("Thread " + Thread.currentThread() + " prepares transaction branch " + txId), LOG_CHANNEL, 7);
        try {
            if (this.deferSaving) {
                TxContext txContext = (TxContext)this.activeContexts.get(txId);
                if (txContext == null) {
                    txContext = (TxContext)this.suspendedContexts.get(txId);
                }
                if (txContext != null) {
                    try {
                        txContext.saveDescriptors();
                    }
                    catch (ObjectNotFoundException onfe) {
                        this.getLogger().log((Object)("Thread " + Thread.currentThread() + " failed to prepare transaction branch " + txId), (Throwable)onfe, LOG_CHANNEL, 1);
                        throw new XAException(onfe.toString());
                    }
                    catch (ServiceAccessException sae) {
                        this.getLogger().log((Object)("Thread " + Thread.currentThread() + " failed to prepare transaction branch " + txId), (Throwable)sae, LOG_CHANNEL, 1);
                        throw new XAException(sae.toString());
                    }
                } else {
                    this.getLogger().log((Object)("Thread " + Thread.currentThread() + " could prepare *unknown* transaction branch " + txId), LOG_CHANNEL, 4);
                }
            }
            int status = this.rm.prepareTransaction((Object)txId);
            switch (status) {
                case 2: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
            }
            throw new XAException(100);
        }
        catch (ResourceManagerException e) {
            this.getLogger().log((Object)("Thread " + Thread.currentThread() + " failed to prepare transaction branch " + txId), (Throwable)e, LOG_CHANNEL, 1);
            throw this.createXAException(e);
        }
    }

    public synchronized void end(Xid xid, int flags) throws XAException {
        if (this.getActiveTxId() == null) {
            throw new XAException(-5);
        }
        String txId = this.wrap(xid);
        Thread currentThread = Thread.currentThread();
        this.getLogger().log((Object)("Thread " + currentThread + (flags == 0x2000000 ? " suspends" : (flags == 0x20000000 ? " fails" : " ends")) + " work on behalf of transaction branch " + txId), LOG_CHANNEL, 7);
        switch (flags) {
            case 0x2000000: {
                this.suspendedContexts.put(txId, this.getActiveTxContext());
                this.activeContexts.remove(txId);
                this.activeTransactionBranch.set(null);
                break;
            }
            case 0x20000000: {
                try {
                    this.rm.markTransactionForRollback((Object)this.wrap(xid));
                }
                catch (ResourceManagerException e) {
                    throw this.createXAException(e);
                }
                this.activeTransactionBranch.set(null);
                break;
            }
            case 0x4000000: {
                this.activeTransactionBranch.set(null);
            }
        }
    }

    public synchronized void start(Xid xid, int flags) throws XAException {
        String txId = this.wrap(xid);
        Thread currentThread = Thread.currentThread();
        this.getLogger().log((Object)("Thread " + currentThread + (flags == 0 ? " starts" : (flags == 0x200000 ? " joins" : " resumes")) + " work on behalf of transaction branch " + txId), LOG_CHANNEL, 7);
        switch (flags) {
            case 0: {
                if (this.getActiveTxId() != null) {
                    throw new XAException(-5);
                }
                try {
                    this.rm.startTransaction((Object)txId);
                    TxContext txContext = new TxContext(txId);
                    this.activeTransactionBranch.set(txContext);
                    this.activeContexts.put(txId, txContext);
                    break;
                }
                catch (ResourceManagerException e) {
                    throw this.createXAException(e);
                }
            }
            case 0x200000: {
                if (this.getActiveTxId() != null) {
                    throw new XAException(-5);
                }
                try {
                    if (this.rm.getTransactionState((Object)txId) == 6) {
                        throw new XAException(-5);
                    }
                }
                catch (ResourceManagerException e) {
                    throw this.createXAException(e);
                }
                TxContext txContext = new TxContext(txId);
                this.activeTransactionBranch.set(txContext);
                this.activeContexts.put(txId, txContext);
                break;
            }
            case 0x8000000: {
                if (this.getActiveTxId() != null) {
                    throw new XAException(-5);
                }
                TxContext txContext = (TxContext)this.suspendedContexts.remove(txId);
                if (txContext == null) {
                    throw new XAException(-4);
                }
                this.activeTransactionBranch.set(txContext);
            }
        }
    }

    protected XMLResourceDescriptor getFileDescriptor(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        XMLResourceDescriptor xfd;
        TxContext txContext = this.getActiveTxContext();
        if (txContext != null) {
            xfd = txContext.lookup(uri);
            if (xfd == null) {
                Object txId = txContext.xid;
                xfd = new XMLResourceDescriptor(uri, this, this.rm, txId, this.characterEncoding);
                xfd.load();
                if (txId != null) {
                    txContext.register(uri, xfd);
                }
            }
        } else {
            xfd = new XMLResourceDescriptor(uri, this, this.rm, null, this.characterEncoding);
            xfd.load();
        }
        if (!xfd.getUri().equals(uri.toString())) {
            throw new ObjectNotFoundException(uri);
        }
        return xfd;
    }

    protected TxContext getActiveTxContext() {
        TxContext context = (TxContext)this.activeTransactionBranch.get();
        return context;
    }

    protected Object getActiveTxId() {
        TxContext context = (TxContext)this.activeTransactionBranch.get();
        return context == null ? null : context.xid;
    }

    protected String getLogChannel() {
        return LOG_CHANNEL;
    }

    private static class TxContext {
        public Object xid;
        public Map descriptors = new HashMap();

        public TxContext(Object xid) {
            this.xid = xid;
        }

        public void register(Uri uri, XMLResourceDescriptor xfd) {
            this.descriptors.put(uri.toString(), xfd);
        }

        public void deregister(Uri uri) {
            this.descriptors.remove(uri.toString());
        }

        public XMLResourceDescriptor lookup(Uri uri) {
            return (XMLResourceDescriptor)this.descriptors.get(uri.toString());
        }

        public Collection list() {
            return this.descriptors.values();
        }

        public void saveDescriptors() throws ObjectNotFoundException, ServiceAccessException {
            Iterator it = this.list().iterator();
            while (it.hasNext()) {
                XMLResourceDescriptor xfd = (XMLResourceDescriptor)it.next();
                if (!xfd.isRegisteredForSaving()) continue;
                xfd.save();
            }
        }
    }
}

