/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.uPortal;

import fr.univrennes1.cri.util.cacheManagement.Cacheable;
import java.util.Calendar;
import java.util.Date;
import org.apache.slide.structure.ObjectNode;

public class CachedObjectNode
implements Cacheable {
    private ObjectNode objectNode;
    private String uri;
    private Date endOfLife;

    public CachedObjectNode(ObjectNode objectNode, String uri, int minutesToLive) {
        this.objectNode = objectNode;
        this.uri = uri;
        if (minutesToLive == -1) {
            this.endOfLife = null;
        } else {
            this.endOfLife = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.endOfLife);
            cal.add(12, minutesToLive);
            this.endOfLife = cal.getTime();
        }
    }

    public boolean isExpired() {
        if (this.endOfLife != null) {
            return this.endOfLife.before(new Date());
        }
        return false;
    }

    public Object getIdentifier() {
        return this.uri;
    }

    public ObjectNode getObjectNode() {
        return this.objectNode;
    }

    public String getUri() {
        return this.uri;
    }
}

