/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.httpclient.AutoCloseInputStream;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.DefaultMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HeaderGroup;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MethodRetryHandler;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.ResponseConsumedWatcher;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.Wire;
import org.apache.commons.httpclient.WireLogInputStream;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.HttpAuthenticator;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HttpMethodBase
implements HttpMethod {
    private static final int MAX_FORWARDS = 100;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$HttpMethodBase == null ? (class$org$apache$commons$httpclient$HttpMethodBase = HttpMethodBase.class$("org.apache.commons.httpclient.HttpMethodBase")) : class$org$apache$commons$httpclient$HttpMethodBase));
    protected static final Header USER_AGENT;
    private HeaderGroup requestHeaders = new HeaderGroup();
    private StatusLine statusLine = null;
    private HeaderGroup responseHeaders = new HeaderGroup();
    private HeaderGroup responseTrailerHeaders = new HeaderGroup();
    private AuthScheme authScheme = null;
    private Set realms = null;
    private String realm = null;
    private AuthScheme proxyAuthScheme = null;
    private Set proxyRealms = null;
    private String proxyRealm = null;
    private String path = null;
    private String queryString = null;
    private InputStream responseStream = null;
    private HttpConnection responseConnection = null;
    private byte[] responseBody = null;
    private boolean followRedirects = false;
    private boolean doAuthentication = true;
    private boolean http11 = true;
    private boolean strictMode = false;
    private boolean used = false;
    private int recoverableExceptionCount = 0;
    private HostConfiguration hostConfiguration;
    private MethodRetryHandler methodRetryHandler;
    private boolean inExecute = false;
    private boolean doneWithConnection = false;
    private boolean connectionCloseForced = false;
    private static final int RESPONSE_WAIT_TIME_MS = 3000;
    static /* synthetic */ Class class$org$apache$commons$httpclient$HttpMethodBase;

    public HttpMethodBase() {
    }

    public HttpMethodBase(String uri) throws IllegalArgumentException, IllegalStateException {
        try {
            URI parsedURI;
            if (uri == null || uri.equals("")) {
                uri = "/";
            }
            if ((parsedURI = new URI(uri.toCharArray())).isAbsoluteURI()) {
                this.hostConfiguration = new HostConfiguration();
                this.hostConfiguration.setHost(parsedURI.getHost(), parsedURI.getPort(), parsedURI.getScheme());
            }
            this.setPath(parsedURI.getPath() == null ? "/" : parsedURI.getEscapedPath());
            this.setQueryString(parsedURI.getEscapedQuery());
        }
        catch (URIException e) {
            throw new IllegalArgumentException("Invalid uri '" + uri + "': " + e.getMessage());
        }
    }

    public abstract String getName();

    public URI getURI() throws URIException {
        if (this.hostConfiguration == null) {
            URI tmpUri = new URI(null, null, this.path, null, null);
            tmpUri.setEscapedQuery(this.queryString);
            return tmpUri;
        }
        int port = this.hostConfiguration.getPort();
        if (port == this.hostConfiguration.getProtocol().getDefaultPort()) {
            port = -1;
        }
        URI tmpUri = new URI(this.hostConfiguration.getProtocol().getScheme(), null, this.hostConfiguration.getHost(), port, this.path, null);
        tmpUri.setEscapedQuery(this.queryString);
        return tmpUri;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setHttp11(boolean http11) {
        this.http11 = http11;
    }

    public boolean getDoAuthentication() {
        return this.doAuthentication;
    }

    public void setDoAuthentication(boolean doAuthentication) {
        this.doAuthentication = doAuthentication;
    }

    public boolean isHttp11() {
        return this.http11;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void addRequestHeader(Header header) {
        LOG.trace((Object)"HttpMethodBase.addRequestHeader(Header)");
        if (header == null) {
            LOG.debug((Object)"null header value ignored");
        } else {
            this.getRequestHeaderGroup().addHeader(header);
        }
    }

    public void addResponseFooter(Header footer) {
        this.getResponseTrailerHeaderGroup().addHeader(footer);
    }

    public String getPath() {
        return this.path == null || this.path.equals("") ? "/" : this.path;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setQueryString(NameValuePair[] params) {
        LOG.trace((Object)"enter HttpMethodBase.setQueryString(NameValuePair[])");
        this.queryString = EncodingUtil.formUrlEncode(params, "UTF-8");
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setRequestHeader(String headerName, String headerValue) {
        Header header = new Header(headerName, headerValue);
        this.setRequestHeader(header);
    }

    public void setRequestHeader(Header header) {
        Header[] headers = this.getRequestHeaderGroup().getHeaders(header.getName());
        for (int i = 0; i < headers.length; ++i) {
            this.getRequestHeaderGroup().removeHeader(headers[i]);
        }
        this.getRequestHeaderGroup().addHeader(header);
    }

    public Header getRequestHeader(String headerName) {
        if (headerName == null) {
            return null;
        }
        return this.getRequestHeaderGroup().getCondensedHeader(headerName);
    }

    public Header[] getRequestHeaders() {
        return this.getRequestHeaderGroup().getAllHeaders();
    }

    protected HeaderGroup getRequestHeaderGroup() {
        return this.requestHeaders;
    }

    protected HeaderGroup getResponseTrailerHeaderGroup() {
        return this.responseTrailerHeaders;
    }

    protected HeaderGroup getResponseHeaderGroup() {
        return this.responseHeaders;
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    private boolean responseAvailable() {
        return this.responseBody != null || this.responseStream != null;
    }

    public Header[] getResponseHeaders() {
        return this.getResponseHeaderGroup().getAllHeaders();
    }

    public Header getResponseHeader(String headerName) {
        if (headerName == null) {
            return null;
        }
        return this.getResponseHeaderGroup().getCondensedHeader(headerName);
    }

    protected int getResponseContentLength() {
        Header[] headers = this.getResponseHeaderGroup().getHeaders("Content-Length");
        if (headers.length == 0) {
            return -1;
        }
        if (headers.length > 1) {
            LOG.warn((Object)"Multiple content-length headers detected");
        }
        for (int i = headers.length - 1; i >= 0; ++i) {
            Header header = headers[i];
            try {
                return Integer.parseInt(header.getValue());
            }
            catch (NumberFormatException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)("Invalid content-length value: " + e.getMessage()));
                continue;
            }
        }
        return -1;
    }

    public byte[] getResponseBody() {
        if (this.responseBody == null) {
            try {
                InputStream instream = this.getResponseBodyAsStream();
                if (instream != null) {
                    int len;
                    LOG.debug((Object)"Buffering response body");
                    ByteArrayOutputStream outstream = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((len = instream.read(buffer)) > 0) {
                        outstream.write(buffer, 0, len);
                    }
                    outstream.close();
                    this.setResponseStream(null);
                    this.responseBody = outstream.toByteArray();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"I/O failure reading response body", (Throwable)e);
                this.responseBody = null;
            }
        }
        return this.responseBody;
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        if (this.responseStream != null) {
            return this.responseStream;
        }
        if (this.responseBody != null) {
            ByteArrayInputStream byteResponseStream = new ByteArrayInputStream(this.responseBody);
            LOG.debug((Object)"re-creating response stream from byte array");
            return byteResponseStream;
        }
        return null;
    }

    public String getResponseBodyAsString() {
        byte[] rawdata = null;
        if (this.responseAvailable()) {
            rawdata = this.getResponseBody();
        }
        if (rawdata != null) {
            return HttpConstants.getContentString(rawdata, this.getResponseCharSet());
        }
        return null;
    }

    public Header[] getResponseFooters() {
        return this.getResponseTrailerHeaderGroup().getAllHeaders();
    }

    public Header getResponseFooter(String footerName) {
        if (footerName == null) {
            return null;
        }
        return this.getResponseTrailerHeaderGroup().getCondensedHeader(footerName);
    }

    protected void setResponseStream(InputStream responseStream) {
        this.responseStream = responseStream;
    }

    protected InputStream getResponseStream() {
        return this.responseStream;
    }

    public String getStatusText() {
        return this.statusLine.getReasonPhrase();
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void addRequestHeader(String headerName, String headerValue) {
        this.addRequestHeader(new Header(headerName, headerValue));
    }

    protected boolean isConnectionCloseForced() {
        return this.connectionCloseForced;
    }

    protected void setConnectionCloseForced(boolean b) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Force-close connection: " + b));
        }
        this.connectionCloseForced = b;
    }

    protected boolean shouldCloseConnection(HttpConnection conn) {
        if (this.isConnectionCloseForced()) {
            LOG.debug((Object)"Should force-close connection.");
            return true;
        }
        Header connectionHeader = null;
        if (!conn.isTransparent()) {
            connectionHeader = this.responseHeaders.getFirstHeader("proxy-connection");
        }
        if (connectionHeader == null) {
            connectionHeader = this.responseHeaders.getFirstHeader("connection");
        }
        if (connectionHeader != null) {
            if (connectionHeader.getValue().equalsIgnoreCase("close")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Should close connection in response to " + connectionHeader.toExternalForm()));
                }
                return true;
            }
            if (connectionHeader.getValue().equalsIgnoreCase("keep-alive")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Should NOT close connection in response to " + connectionHeader.toExternalForm()));
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unknown directive: " + connectionHeader.toExternalForm()));
            }
        }
        LOG.debug((Object)"Resorting to protocol version default close connection policy");
        if (this.http11) {
            LOG.debug((Object)"Should NOT close connection, using HTTP/1.1.");
        } else {
            LOG.debug((Object)"Should close connection, using HTTP/1.0.");
        }
        return !this.http11;
    }

    private boolean isRetryNeeded(int statusCode, HttpState state, HttpConnection conn) {
        switch (statusCode) {
            case 401: 
            case 407: {
                LOG.debug((Object)"Authorization required");
                if (this.doAuthentication) {
                    if (!this.processAuthenticationResponse(state, conn)) break;
                    return false;
                }
                return false;
            }
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                LOG.debug((Object)"Redirect required");
                if (this.processRedirectResponse(conn)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void checkExecuteConditions(HttpState state, HttpConnection conn) throws HttpException {
        if (state == null) {
            throw new IllegalArgumentException("HttpState parameter may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("HttpConnection parameter may not be null");
        }
        if (this.hasBeenUsed()) {
            throw new HttpException("Already used, but not recycled.");
        }
        if (!this.validate()) {
            throw new HttpException("Not valid");
        }
        if (this.inExecute) {
            throw new IllegalStateException("Execute invoked recursively, or exited abnormally.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(HttpState state, HttpConnection conn) throws HttpException, HttpRecoverableException, IOException {
        LOG.trace((Object)"enter HttpMethodBase.execute(HttpState, HttpConnection)");
        this.responseConnection = conn;
        this.checkExecuteConditions(state, conn);
        this.inExecute = true;
        try {
            if (state.isAuthenticationPreemptive()) {
                LOG.debug((Object)"Preemptively sending default basic credentials");
                try {
                    if (HttpAuthenticator.authenticateDefault(this, conn, state)) {
                        LOG.debug((Object)"Default basic credentials applied");
                    }
                    if (conn.isProxied() && HttpAuthenticator.authenticateProxyDefault(this, conn, state)) {
                        LOG.debug((Object)"Default basic proxy credentials applied");
                    }
                }
                catch (AuthenticationException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.realms = new HashSet();
            this.proxyRealms = new HashSet();
            int forwardCount = 0;
            while (forwardCount++ < 100) {
                conn.setLastResponseInputStream(null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Execute loop try " + forwardCount));
                }
                this.statusLine = null;
                this.connectionCloseForced = false;
                this.processRequest(state, conn);
                if (!this.isRetryNeeded(this.statusLine.getStatusCode(), state, conn)) break;
                if (this.responseStream == null) continue;
                this.responseStream.close();
            }
            if (forwardCount >= 100) {
                LOG.error((Object)"Narrowly avoided an infinite loop in execute");
                throw new HttpRecoverableException("Maximum redirects (100) exceeded");
            }
        }
        finally {
            this.inExecute = false;
            if (this.doneWithConnection) {
                this.ensureConnectionRelease();
            }
        }
        return this.statusLine.getStatusCode();
    }

    private boolean processRedirectResponse(HttpConnection conn) {
        if (!this.getFollowRedirects()) {
            LOG.info((Object)"Redirect requested but followRedirects is disabled");
            return false;
        }
        Header locationHeader = this.getResponseHeader("location");
        if (locationHeader == null) {
            LOG.error((Object)("Received redirect response " + this.getStatusCode() + " but no location header"));
            return false;
        }
        String location = locationHeader.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirect requested to location '" + location + "'"));
        }
        URI redirectUri = null;
        URI currentUri = null;
        try {
            currentUri = new URI(conn.getProtocol().getScheme(), null, conn.getHost(), conn.getPort(), this.getPath());
            redirectUri = new URI(location.toCharArray());
            if (redirectUri.isRelativeURI()) {
                if (this.isStrictMode()) {
                    LOG.warn((Object)("Redirected location '" + location + "' is not acceptable in strict mode"));
                    return false;
                }
                LOG.debug((Object)"Redirect URI is not absolute - parsing as relative");
                redirectUri = new URI(currentUri, redirectUri);
            }
        }
        catch (URIException e) {
            LOG.warn((Object)("Redirected location '" + location + "' is malformed"));
            return false;
        }
        try {
            HttpMethodBase.checkValidRedirect(currentUri, redirectUri);
        }
        catch (HttpException ex) {
            LOG.warn((Object)ex.getMessage());
            return false;
        }
        this.realms.clear();
        if (this.proxyAuthScheme instanceof NTLMScheme) {
            this.removeRequestHeader("Proxy-Authorization");
        }
        this.removeRequestHeader("Authorization");
        this.setPath(redirectUri.getEscapedPath());
        this.setQueryString(redirectUri.getEscapedQuery());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirecting from '" + currentUri.getEscapedURI() + "' to '" + redirectUri.getEscapedURI()));
        }
        return true;
    }

    private static void checkValidRedirect(URI currentUri, URI redirectUri) throws HttpException {
        int newPort;
        LOG.trace((Object)"enter HttpMethodBase.checkValidRedirect(HttpConnection, URL)");
        String oldProtocol = currentUri.getScheme();
        String newProtocol = redirectUri.getScheme();
        if (!oldProtocol.equals(newProtocol)) {
            throw new HttpException("Redirect from protocol " + oldProtocol + " to " + newProtocol + " is not supported");
        }
        try {
            String oldHost = currentUri.getHost();
            String newHost = redirectUri.getHost();
            if (!oldHost.equalsIgnoreCase(newHost)) {
                throw new HttpException("Redirect from host " + oldHost + " to " + newHost + " is not supported");
            }
        }
        catch (URIException e) {
            LOG.warn((Object)"Error getting URI host", (Throwable)e);
            throw new HttpException("Invalid Redirect URI from: " + currentUri.getEscapedURI() + " to: " + redirectUri.getEscapedURI());
        }
        int oldPort = currentUri.getPort();
        if (oldPort < 0) {
            oldPort = HttpMethodBase.getDefaultPort(oldProtocol);
        }
        if ((newPort = redirectUri.getPort()) < 0) {
            newPort = HttpMethodBase.getDefaultPort(newProtocol);
        }
        if (oldPort != newPort) {
            throw new HttpException("Redirect from port " + oldPort + " to " + newPort + " is not supported");
        }
    }

    private static int getDefaultPort(String protocol) {
        String proto = protocol.toLowerCase().trim();
        if (proto.equals("http")) {
            return 80;
        }
        if (proto.equals("https")) {
            return 443;
        }
        return -1;
    }

    public boolean hasBeenUsed() {
        return this.used;
    }

    public void recycle() {
        LOG.trace((Object)"enter HttpMethodBase.recycle()");
        this.releaseConnection();
        this.path = null;
        this.followRedirects = false;
        this.doAuthentication = true;
        this.authScheme = null;
        this.realm = null;
        this.proxyAuthScheme = null;
        this.proxyRealm = null;
        this.queryString = null;
        this.getRequestHeaderGroup().clear();
        this.getResponseHeaderGroup().clear();
        this.getResponseTrailerHeaderGroup().clear();
        this.statusLine = null;
        this.used = false;
        this.http11 = true;
        this.responseBody = null;
        this.recoverableExceptionCount = 0;
        this.inExecute = false;
        this.doneWithConnection = false;
        this.connectionCloseForced = false;
    }

    public void releaseConnection() {
        if (this.responseStream != null) {
            try {
                this.responseStream.close();
            }
            catch (IOException e) {
                this.ensureConnectionRelease();
            }
        } else {
            this.ensureConnectionRelease();
        }
    }

    public void removeRequestHeader(String headerName) {
        Header[] headers = this.getRequestHeaderGroup().getHeaders(headerName);
        for (int i = 0; i < headers.length; ++i) {
            this.getRequestHeaderGroup().removeHeader(headers[i]);
        }
    }

    public boolean validate() {
        return true;
    }

    protected int getRequestContentLength() {
        return 0;
    }

    protected void addAuthorizationRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        block3: {
            Header[] challenges;
            LOG.trace((Object)"enter HttpMethodBase.addAuthorizationRequestHeader(HttpState, HttpConnection)");
            if (this.getRequestHeader("Authorization") == null && (challenges = this.getResponseHeaderGroup().getHeaders("WWW-Authenticate")).length > 0) {
                try {
                    this.authScheme = HttpAuthenticator.selectAuthScheme(challenges);
                    HttpAuthenticator.authenticate(this.authScheme, this, conn, state);
                }
                catch (HttpException e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void addContentLengthRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.addContentLengthRequestHeader(HttpState, HttpConnection)");
        int len = this.getRequestContentLength();
        if (this.getRequestHeader("content-length") == null) {
            if (0 < len) {
                this.setRequestHeader("Content-Length", String.valueOf(len));
            } else if (this.http11 && len < 0) {
                this.setRequestHeader("Transfer-Encoding", "chunked");
            }
        }
    }

    protected void addCookieRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.addCookieRequestHeader(HttpState, HttpConnection)");
        this.removeRequestHeader("cookie");
        CookieSpec matcher = CookiePolicy.getSpecByPolicy(state.getCookiePolicy());
        Cookie[] cookies = matcher.match(conn.getHost(), conn.getPort(), this.getPath(), conn.isSecure(), state.getCookies());
        if (cookies != null && cookies.length > 0) {
            if (this.isStrictMode()) {
                this.getRequestHeaderGroup().addHeader(matcher.formatCookieHeader(cookies));
            } else {
                for (int i = 0; i < cookies.length; ++i) {
                    this.getRequestHeaderGroup().addHeader(matcher.formatCookieHeader(cookies[i]));
                }
            }
        }
    }

    protected void addHostRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.addHostRequestHeader(HttpState, HttpConnection)");
        String host = conn.getVirtualHost();
        if (host != null) {
            LOG.debug((Object)("Using virtual host name: " + host));
        } else {
            host = conn.getHost();
        }
        int port = conn.getPort();
        if (this.getRequestHeader("host") != null) {
            LOG.debug((Object)"Request to add Host header ignored: header already added");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Adding Host request header");
        }
        if (conn.getProtocol().getDefaultPort() != port) {
            host = host + ":" + port;
        }
        this.setRequestHeader("Host", host);
    }

    protected void addProxyAuthorizationRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        block3: {
            Header[] challenges;
            LOG.trace((Object)"enter HttpMethodBase.addProxyAuthorizationRequestHeader(HttpState, HttpConnection)");
            if (this.getRequestHeader("Proxy-Authorization") == null && (challenges = this.getResponseHeaderGroup().getHeaders("Proxy-Authenticate")).length > 0) {
                try {
                    this.proxyAuthScheme = HttpAuthenticator.selectAuthScheme(challenges);
                    HttpAuthenticator.authenticateProxy(this.proxyAuthScheme, this, conn, state);
                }
                catch (HttpException e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void addProxyConnectionHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.addProxyConnectionHeader(HttpState, HttpConnection)");
        if (!conn.isTransparent()) {
            this.setRequestHeader("Proxy-Connection", "Keep-Alive");
        }
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.addRequestHeaders(HttpState, HttpConnection)");
        this.addUserAgentRequestHeader(state, conn);
        this.addHostRequestHeader(state, conn);
        this.addCookieRequestHeader(state, conn);
        this.addAuthorizationRequestHeader(state, conn);
        this.addProxyAuthorizationRequestHeader(state, conn);
        this.addProxyConnectionHeader(state, conn);
        this.addContentLengthRequestHeader(state, conn);
    }

    protected void addUserAgentRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.addUserAgentRequestHeaders(HttpState, HttpConnection)");
        if (this.getRequestHeader("user-agent") == null) {
            this.setRequestHeader(USER_AGENT);
        }
    }

    protected void checkNotUsed() throws IllegalStateException {
        if (this.used) {
            throw new IllegalStateException("Already used.");
        }
    }

    protected void checkUsed() throws IllegalStateException {
        if (!this.used) {
            throw new IllegalStateException("Not Used.");
        }
    }

    protected static String generateRequestLine(HttpConnection connection, String name, String requestPath, String query, String version) {
        LOG.trace((Object)"enter HttpMethodBase.generateRequestLine(HttpConnection, String, String, String, String)");
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append(" ");
        if (!connection.isTransparent()) {
            Protocol protocol = connection.getProtocol();
            buf.append(protocol.getScheme().toLowerCase());
            buf.append("://");
            buf.append(connection.getHost());
            if (connection.getPort() != -1 && connection.getPort() != protocol.getDefaultPort()) {
                buf.append(":");
                buf.append(connection.getPort());
            }
        }
        if (requestPath == null) {
            buf.append("/");
        } else {
            if (!connection.isTransparent() && !requestPath.startsWith("/")) {
                buf.append("/");
            }
            buf.append(requestPath);
        }
        if (query != null) {
            if (query.indexOf("?") != 0) {
                buf.append("?");
            }
            buf.append(query);
        }
        buf.append(" ");
        buf.append(version);
        buf.append("\r\n");
        return buf.toString();
    }

    protected void processResponseBody(HttpState state, HttpConnection conn) {
    }

    protected void processResponseHeaders(HttpState state, HttpConnection conn) {
        LOG.trace((Object)"enter HttpMethodBase.processResponseHeaders(HttpState, HttpConnection)");
        Header[] headers = this.getResponseHeaderGroup().getHeaders("set-cookie2");
        if (headers.length == 0) {
            headers = this.getResponseHeaderGroup().getHeaders("set-cookie");
        }
        CookieSpec parser = CookiePolicy.getSpecByPolicy(state.getCookiePolicy());
        for (int i = 0; i < headers.length; ++i) {
            Cookie[] cookies;
            block7: {
                Header header = headers[i];
                cookies = null;
                try {
                    cookies = parser.parse(conn.getHost(), conn.getPort(), this.getPath(), conn.isSecure(), header);
                }
                catch (MalformedCookieException e) {
                    if (!LOG.isWarnEnabled()) break block7;
                    LOG.warn((Object)("Invalid cookie header: \"" + header.getValue() + "\". " + e.getMessage()));
                }
            }
            if (cookies == null) continue;
            for (int j = 0; j < cookies.length; ++j) {
                Cookie cookie = cookies[j];
                try {
                    parser.validate(conn.getHost(), conn.getPort(), this.getPath(), conn.isSecure(), cookie);
                    state.addCookie(cookie);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Cookie accepted: \"" + parser.formatCookie(cookie) + "\""));
                    continue;
                }
                catch (MalformedCookieException e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)("Cookie rejected: \"" + parser.formatCookie(cookie) + "\". " + e.getMessage()));
                }
            }
        }
    }

    protected void processStatusLine(HttpState state, HttpConnection conn) {
    }

    protected void readResponse(HttpState state, HttpConnection conn) throws HttpException {
        LOG.trace((Object)"enter HttpMethodBase.readResponse(HttpState, HttpConnection)");
        try {
            while (this.statusLine == null) {
                this.readStatusLine(state, conn);
                this.processStatusLine(state, conn);
                this.readResponseHeaders(state, conn);
                this.processResponseHeaders(state, conn);
                int status = this.statusLine.getStatusCode();
                if (status < 100 || status >= 200) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Discarding unexpected response: " + this.statusLine.toString()));
                }
                this.statusLine = null;
            }
            this.readResponseBody(state, conn);
            this.processResponseBody(state, conn);
        }
        catch (IOException e) {
            throw new HttpRecoverableException(e.toString());
        }
    }

    protected void readResponseBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.readResponseBody(HttpState, HttpConnection)");
        this.doneWithConnection = false;
        InputStream stream = this.readResponseBody(conn);
        if (stream == null) {
            this.responseBodyConsumed();
        } else {
            conn.setLastResponseInputStream(stream);
            this.setResponseStream(stream);
        }
    }

    private InputStream readResponseBody(HttpConnection conn) throws IOException {
        LOG.trace((Object)"enter HttpMethodBase.readResponseBody(HttpState, HttpConnection)");
        this.responseBody = null;
        InputStream is = conn.getResponseInputStream();
        if (Wire.enabled()) {
            is = new WireLogInputStream(is);
        }
        InputStream result = null;
        Header transferEncodingHeader = this.responseHeaders.getFirstHeader("Transfer-Encoding");
        if (transferEncodingHeader != null) {
            HeaderElement[] encodings;
            int len;
            String transferEncoding = transferEncodingHeader.getValue();
            if (!"chunked".equalsIgnoreCase(transferEncoding) && !"identity".equalsIgnoreCase(transferEncoding) && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Unsupported transfer encoding: " + transferEncoding));
            }
            if ((len = (encodings = transferEncodingHeader.getValues()).length) > 0 && "chunked".equalsIgnoreCase(encodings[len - 1].getName())) {
                if (conn.isResponseAvailable(conn.getSoTimeout())) {
                    result = new ChunkedInputStream(is, this);
                } else {
                    if (this.isStrictMode()) {
                        throw new HttpException("Chunk-encoded body declared but not sent");
                    }
                    LOG.warn((Object)"Chunk-encoded body missing");
                }
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Transfer-Encoding is set but does not contain \"chunked\": " + transferEncoding));
                }
                this.setConnectionCloseForced(true);
                result = is;
            }
        } else {
            int expectedLength = this.getResponseContentLength();
            if (expectedLength == -1) {
                if (HttpMethodBase.canResponseHaveBody(this.statusLine.getStatusCode())) {
                    Header connectionHeader = this.responseHeaders.getFirstHeader("Connection");
                    String connectionDirective = null;
                    if (connectionHeader != null) {
                        connectionDirective = connectionHeader.getValue();
                    }
                    if (!"close".equalsIgnoreCase(connectionDirective)) {
                        LOG.warn((Object)"Response content length is not known");
                        this.setConnectionCloseForced(true);
                    }
                    result = is;
                }
            } else {
                result = new ContentLengthInputStream(is, expectedLength);
            }
        }
        if (result != null) {
            result = new AutoCloseInputStream(result, new ResponseConsumedWatcher(){

                public void responseConsumed() {
                    HttpMethodBase.this.responseBodyConsumed();
                }
            });
        }
        return result;
    }

    protected void readResponseHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.readResponseHeaders(HttpState,HttpConnection)");
        this.getResponseHeaderGroup().clear();
        Header[] headers = HttpParser.parseHeaders(conn.getResponseInputStream());
        if (Wire.enabled()) {
            for (int i = 0; i < headers.length; ++i) {
                Wire.input(headers[i].toExternalForm());
            }
        }
        this.getResponseHeaderGroup().setHeaders(headers);
    }

    protected void readStatusLine(HttpState state, HttpConnection conn) throws IOException, HttpRecoverableException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.readStatusLine(HttpState, HttpConnection)");
        String s = conn.readLine();
        while (s != null && !StatusLine.startsWithHTTP(s)) {
            if (Wire.enabled()) {
                Wire.input(s + "\r\n");
            }
            s = conn.readLine();
        }
        if (s == null) {
            throw new HttpRecoverableException("Error in parsing the status  line from the response: unable to find line starting with \"HTTP\"");
        }
        if (Wire.enabled()) {
            Wire.input(s + "\r\n");
        }
        this.statusLine = new StatusLine(s);
        String httpVersion = this.statusLine.getHttpVersion();
        if (httpVersion.equals("HTTP/1.0")) {
            this.http11 = false;
        } else if (httpVersion.equals("HTTP/1.1")) {
            this.http11 = true;
        } else if (httpVersion.equals("HTTP")) {
            this.http11 = false;
        } else {
            throw new HttpException("Unrecognized server protocol: '" + httpVersion + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRequest(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.writeRequest(HttpState, HttpConnection)");
        this.writeRequestLine(state, conn);
        this.writeRequestHeaders(state, conn);
        conn.writeLine();
        conn.flushRequestOutputStream();
        if (Wire.enabled()) {
            Wire.output("\r\n");
        }
        Header expectheader = this.getRequestHeader("Expect");
        String expectvalue = null;
        if (expectheader != null) {
            expectvalue = expectheader.getValue();
        }
        if (expectvalue != null && expectvalue.compareToIgnoreCase("100-continue") == 0) {
            if (this.isHttp11()) {
                int readTimeout = conn.getSoTimeout();
                try {
                    conn.setSoTimeout(3000);
                    this.readStatusLine(state, conn);
                    this.processStatusLine(state, conn);
                    this.readResponseHeaders(state, conn);
                    this.processResponseHeaders(state, conn);
                    if (this.statusLine.getStatusCode() == 100) {
                        this.statusLine = null;
                        LOG.debug((Object)"OK to continue received");
                    }
                    return;
                }
                catch (InterruptedIOException e) {
                    this.removeRequestHeader("Expect");
                    LOG.info((Object)"100 (continue) read timeout. Resume sending the request");
                }
                finally {
                    conn.setSoTimeout(readTimeout);
                }
            } else {
                this.removeRequestHeader("Expect");
                LOG.info((Object)"'Expect: 100-continue' handshake is only supported by HTTP/1.1 or higher");
            }
        }
        this.writeRequestBody(state, conn);
        conn.flushRequestOutputStream();
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        return true;
    }

    protected void writeRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.writeRequestHeaders(HttpState,HttpConnection)");
        this.addRequestHeaders(state, conn);
        Header[] headers = this.getRequestHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String s = headers[i].toExternalForm();
            if (Wire.enabled()) {
                Wire.output(s);
            }
            conn.print(s);
        }
    }

    protected void writeRequestLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.writeRequestLine(HttpState, HttpConnection)");
        String requestLine = this.getRequestLine(conn);
        if (Wire.enabled()) {
            Wire.output(requestLine);
        }
        conn.print(requestLine);
    }

    private String getRequestLine(HttpConnection conn) {
        return HttpMethodBase.generateRequestLine(conn, this.getName(), this.getPath(), this.getQueryString(), this.getHttpVersion());
    }

    private String getHttpVersion() {
        return this.http11 ? "HTTP/1.1" : "HTTP/1.0";
    }

    private static boolean canResponseHaveBody(int status) {
        LOG.trace((Object)"enter HttpMethodBase.canResponseHaveBody(int)");
        boolean result = true;
        if (status >= 100 && status <= 199 || status == 204 || status == 304) {
            result = false;
        }
        return result;
    }

    private boolean processAuthenticationResponse(HttpState state, HttpConnection conn) {
        LOG.trace((Object)"enter HttpMethodBase.processAuthenticationResponse(HttpState, HttpConnection)");
        if (this.proxyAuthScheme instanceof NTLMScheme) {
            this.removeRequestHeader("Proxy-Authorization");
        }
        if (this.authScheme instanceof NTLMScheme) {
            this.removeRequestHeader("Authorization");
        }
        int statusCode = this.statusLine.getStatusCode();
        Header[] challenges = null;
        Set realmsUsed = null;
        String host = null;
        switch (statusCode) {
            case 401: {
                challenges = this.getResponseHeaderGroup().getHeaders("WWW-Authenticate");
                realmsUsed = this.realms;
                host = conn.getVirtualHost();
                if (host != null) break;
                host = conn.getHost();
                break;
            }
            case 407: {
                challenges = this.getResponseHeaderGroup().getHeaders("Proxy-Authenticate");
                realmsUsed = this.proxyRealms;
                host = conn.getProxyHost();
            }
        }
        boolean authenticated = false;
        if (challenges.length > 0) {
            AuthScheme authscheme = null;
            try {
                authscheme = HttpAuthenticator.selectAuthScheme(challenges);
            }
            catch (MalformedChallengeException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                return true;
            }
            catch (UnsupportedOperationException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                return true;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(host);
            buffer.append('#');
            buffer.append(authscheme.getID());
            String realm = buffer.toString();
            if (realmsUsed.contains(realm)) {
                if (LOG.isInfoEnabled()) {
                    buffer = new StringBuffer();
                    buffer.append("Already tried to authenticate with '");
                    buffer.append(authscheme.getRealm());
                    buffer.append("' authentication realm at ");
                    buffer.append(host);
                    buffer.append(", but still receiving: ");
                    buffer.append(this.statusLine.toString());
                    LOG.info((Object)buffer.toString());
                }
                return true;
            }
            realmsUsed.add(realm);
            try {
                switch (statusCode) {
                    case 401: {
                        this.removeRequestHeader("Authorization");
                        authenticated = HttpAuthenticator.authenticate(authscheme, this, conn, state);
                        this.realm = authscheme.getRealm();
                        this.authScheme = authscheme;
                        break;
                    }
                    case 407: {
                        this.removeRequestHeader("Proxy-Authorization");
                        authenticated = HttpAuthenticator.authenticateProxy(authscheme, this, conn, state);
                        this.proxyRealm = authscheme.getRealm();
                        this.proxyAuthScheme = authscheme;
                    }
                }
            }
            catch (AuthenticationException e) {
                LOG.warn((Object)e.getMessage());
                return true;
            }
            if (!authenticated) {
                LOG.debug((Object)"HttpMethodBase.execute(): Server demands authentication credentials, but none are available, so aborting.");
            } else {
                LOG.debug((Object)"HttpMethodBase.execute(): Server demanded authentication credentials, will try again.");
            }
        }
        return !authenticated;
    }

    public String getProxyAuthenticationRealm() {
        return this.proxyRealm;
    }

    public String getAuthenticationRealm() {
        return this.realm;
    }

    private void processRequest(HttpState state, HttpConnection connection) throws HttpException, IOException {
        LOG.trace((Object)"enter HttpMethodBase.processRequest(HttpState, HttpConnection)");
        int execCount = 0;
        boolean requestSent = false;
        while (true) {
            ++execCount;
            requestSent = false;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Attempt number " + execCount + " to process request"));
            }
            try {
                if (!connection.isOpen()) {
                    LOG.debug((Object)"Opening the connection.");
                    connection.open();
                }
                this.writeRequest(state, connection);
                requestSent = true;
                this.readResponse(state, connection);
                this.used = true;
            }
            catch (HttpRecoverableException httpre) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Closing the connection.");
                }
                connection.close();
                LOG.info((Object)"Recoverable exception caught when processing request");
                ++this.recoverableExceptionCount;
                if (this.getMethodRetryHandler().retryMethod(this, connection, httpre, execCount, requestSent)) continue;
                LOG.warn((Object)"Recoverable exception caught but MethodRetryHandler.retryMethod() returned false, rethrowing exception");
                this.doneWithConnection = true;
                throw httpre;
            }
            catch (IOException e) {
                connection.close();
                this.doneWithConnection = true;
                throw e;
            }
            catch (RuntimeException e) {
                connection.close();
                this.doneWithConnection = true;
                throw e;
            }
            break;
        }
    }

    protected static String getContentCharSet(Header contentheader) {
        LOG.trace((Object)"enter getContentCharSet( Header contentheader )");
        String charset = null;
        if (contentheader != null) {
            try {
                NameValuePair param;
                HeaderElement[] values = contentheader.getValues();
                if (values.length == 1 && (param = values[0].getParameterByName("charset")) != null) {
                    charset = param.getValue();
                }
            }
            catch (HttpException e) {
                LOG.error((Object)e);
            }
        }
        if (charset == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Default charset used: ISO-8859-1");
            }
            charset = "ISO-8859-1";
        }
        return charset;
    }

    public String getRequestCharSet() {
        return HttpMethodBase.getContentCharSet(this.getRequestHeader("Content-Type"));
    }

    public String getResponseCharSet() {
        return HttpMethodBase.getContentCharSet(this.getResponseHeader("Content-Type"));
    }

    public int getRecoverableExceptionCount() {
        return this.recoverableExceptionCount;
    }

    protected void responseBodyConsumed() {
        this.responseStream = null;
        if (this.responseConnection != null) {
            this.responseConnection.setLastResponseInputStream(null);
            if (this.shouldCloseConnection(this.responseConnection)) {
                this.responseConnection.close();
            }
        }
        this.connectionCloseForced = false;
        this.doneWithConnection = true;
        if (!this.inExecute) {
            this.ensureConnectionRelease();
        }
    }

    private void ensureConnectionRelease() {
        if (this.responseConnection != null) {
            this.responseConnection.releaseConnection();
            this.responseConnection = null;
        }
    }

    public HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public void setHostConfiguration(HostConfiguration hostConfiguration) {
        this.hostConfiguration = hostConfiguration;
    }

    public MethodRetryHandler getMethodRetryHandler() {
        if (this.methodRetryHandler == null) {
            this.methodRetryHandler = new DefaultMethodRetryHandler();
        }
        return this.methodRetryHandler;
    }

    public void setMethodRetryHandler(MethodRetryHandler handler) {
        this.methodRetryHandler = handler;
    }

    protected void fakeResponse(StatusLine statusline, HeaderGroup responseheaders, InputStream responseStream) {
        this.used = true;
        this.statusLine = statusline;
        this.responseHeaders = responseheaders;
        this.responseBody = null;
        this.responseStream = responseStream;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String agent = null;
        try {
            agent = System.getProperty("httpclient.useragent");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (agent == null) {
            agent = "Jakarta Commons-HttpClient/2.0rc3";
        }
        USER_AGENT = new Header("User-Agent", agent);
    }
}

