/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.portal.utils;

import java.io.IOException;
import java.util.Enumeration;
import org.esupportail.portal.utils.CASExceptions.CASGenericException;
import org.esupportail.portal.utils.CASExceptions.CASPermException;
import org.esupportail.portal.utils.CASExceptions.CASTempException;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.provider.YaleCasContext;
import org.jasig.portal.services.LogService;

public class CAS {
    private static final String BAD_PGT = "BAD_PGT";
    private static final String INVALID_REQUEST = "INVALID_REQUEST";
    private static final String INTERNAL_ERROR = "INTERNAL_ERROR";
    private static final int RETRY_ON_IOERROR = 3;
    private static final int SLEEP_IOERROR = 1;

    public static String get_pt(ChannelStaticData sd, String targetService) throws CASGenericException {
        String PT = null;
        PT = CAS._get_pt(sd, targetService, 3, 1);
        return PT;
    }

    public static String get_pt(ChannelStaticData sd, String targetService, int retry, int sleep) throws CASGenericException {
        String PT = null;
        PT = CAS._get_pt(sd, targetService, retry, sleep);
        return PT;
    }

    private static String _get_pt(ChannelStaticData sd, String targetService, int retry, int sleep) throws CASGenericException {
        ISecurityContext sctx = null;
        String PT = null;
        if (targetService == null) {
            LogService.log(LogService.ERROR, "CAS::get_pt() : ERROR : service to get a PT is empty.");
            throw new CASPermException("Erreur interne : Pas de service sp\u00e9cifi\u00e9 lors de la demande du PT.");
        }
        sctx = CAS.getCASContext(sd.getPerson().getSecurityContext());
        if (sctx == null) {
            LogService.log(LogService.ERROR, "CAS::get_pt() : ERROR : none CAS security context");
            throw new CASPermException("Erreur interne : Pas de contexte de s\u00e9curit\u00e9 CAS.");
        }
        if (!CAS.isAtuhInContext(sctx)) {
            LogService.log(LogService.ERROR, "CAS::get_pt() : ERROR : the person isn't auth by CAS");
            throw new CASPermException("Erreur interne : Pas authentifi\u00e9 avec CAS.");
        }
        PT = CAS.retrivePT(sctx, targetService, retry, sleep);
        if (PT != null && PT.equals(BAD_PGT)) {
            LogService.log(LogService.ERROR, "CAS::get_pt() : ERROR : bad PGT for retrieve a PT " + PT);
            throw new CASTempException("Erreur interne : Information de s\u00e9curit\u00e9 non valide (PGT inconnu).");
        }
        if (PT != null && PT.equals(INVALID_REQUEST)) {
            LogService.log(LogService.ERROR, "CAS::get_pt() : ERROR : : invalid request to retrieve a PT." + PT);
            throw new CASPermException("Erreur interne : Il manque des param\u00eatres pour le serveur d'authentification.");
        }
        if (PT != null && PT.equals(INTERNAL_ERROR)) {
            LogService.log(LogService.ERROR, "CAS::get_pt() : ERROR : internal error of CAS server" + PT);
            throw new CASPermException("Erreur interne : Erreur interne du serveur d'authentification.");
        }
        if (PT != null && !PT.matches("^PT-.*$")) {
            LogService.log(LogService.ERROR, "CAS::get_pt()t : ERROR : the PT doesn't resemble to a normal PT : " + PT);
            throw new CASPermException("Erreur interne : Information de s\u00e9curit\u00e9 non valide (PT inconnu).");
        }
        LogService.log(LogService.INFO, "CAS::get_pt() : " + PT + " for " + sd.getPerson().getAttribute("username"));
        return PT;
    }

    private static ISecurityContext getCASContext(ISecurityContext rootContext) {
        ISecurityContext sctx = null;
        if (rootContext instanceof YaleCasContext) {
            LogService.log(LogService.DEBUG, "CAS::getCASContext() : CAS is the principal security context");
            sctx = rootContext;
        } else {
            Enumeration enCtx = rootContext.getSubContexts();
            while (enCtx.hasMoreElements()) {
                sctx = (ISecurityContext)enCtx.nextElement();
                LogService.log(LogService.DEBUG, "CAS::getCASContext() : Courses the sub context : " + sctx.getClass().getName());
                if (sctx instanceof YaleCasContext) {
                    LogService.log(LogService.DEBUG, "CAS::getCASContext() : the CAS security context is : " + sctx.getClass().getName());
                    break;
                }
                sctx = null;
            }
        }
        return sctx;
    }

    private static boolean isAtuhInContext(ISecurityContext Context2) {
        if (Context2.isAuthenticated()) {
            LogService.log(LogService.DEBUG, "CAS::isAtuhInContext() : well authenticated in CAS");
            return true;
        }
        return false;
    }

    private static String retrivePT(ISecurityContext Context2, String Service, int retry, int sleep) throws CASGenericException {
        String PT = null;
        YaleCasContext CASctx = null;
        CASctx = (YaleCasContext)Context2;
        while (retry > 0) {
            try {
                PT = CASctx.getCasServiceToken(Service);
            }
            catch (IOException e) {
                LogService.log(LogService.ERROR, "CAS::retrivePT() : ERROR : can't opening CAS server URL (retry N\u00b0 " + retry + ") : " + e.toString());
                PT = null;
            }
            --retry;
            if (PT != null) {
                return PT;
            }
            if (retry <= 0) {
                throw new CASTempException("Erreur interne : Erreur de communication avec le serveur d'authentification.");
            }
            try {
                Thread.sleep(sleep * 1000);
            }
            catch (InterruptedException e) {
                LogService.log(LogService.ERROR, "CAS::retrivePT() : ERROR : can't make a Thread.sleep");
            }
        }
        return PT;
    }
}

