/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonManagerFactory;
import org.jasig.portal.services.Authentication;
import org.jasig.portal.services.LogService;

public class AuthenticationServlet
extends HttpServlet {
    private static final String redirectString;
    private Authentication m_authenticationService = null;

    public void init() throws ServletException {
        this.m_authenticationService = new Authentication();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.getSession().invalidate();
        request.getSession(true);
        IPerson person = null;
        try {
            person = PersonManagerFactory.getPersonManagerInstance().getPerson(request);
            HashMap<String, String> principals = new HashMap<String, String>(1);
            principals.put("username", request.getParameter("userName"));
            HashMap<String, String> credentials = new HashMap<String, String>(1);
            if (request.getParameter("ticket") != null) {
                credentials.put("password", request.getParameter("ticket"));
                LogService.log(LogService.DEBUG, "AuthenticationServler: got ticket='" + request.getParameter("ticket") + "'");
            } else {
                credentials.put("password", request.getParameter("password"));
            }
            this.m_authenticationService.authenticate(principals, credentials, person);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
            person = null;
            request.getSession(false).invalidate();
            request.getSession(true).setAttribute("up_authenticationError", (Object)"true");
        }
        if (person != null && person.getSecurityContext().isAuthenticated()) {
            response.sendRedirect(request.getContextPath() + '/' + redirectString);
        } else {
            request.getSession(false).setAttribute("up_authenticationAttempted", (Object)"true");
            String attemptedUserName = request.getParameter("userName");
            if (attemptedUserName != null) {
                request.getSession(false).setAttribute("up_attemptedUserName", (Object)request.getParameter("userName"));
            }
            response.sendRedirect(request.getContextPath() + '/' + redirectString);
        }
    }

    static {
        String upFile = "render.userLayoutRootNode.uP";
        try {
            upFile = UPFileSpec.buildUPFile(null, 0, "userLayoutRootNode", null, null);
        }
        catch (PortalException pe) {
            LogService.log(LogService.ERROR, "AuthenticationServlet::static " + pe);
        }
        redirectString = upFile;
    }
}

