/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Hashtable;
import java.util.Map;
import org.jasig.portal.IChannel;
import org.jasig.portal.IMultithreadedCacheable;
import org.jasig.portal.IMultithreadedChannel;
import org.jasig.portal.IMultithreadedCharacterChannel;
import org.jasig.portal.IMultithreadedMimeResponse;
import org.jasig.portal.IMultithreadedPrivileged;
import org.jasig.portal.MultithreadedCacheableChannelAdapter;
import org.jasig.portal.MultithreadedCacheableCharacterChannelAdapter;
import org.jasig.portal.MultithreadedCacheableMimeResponseChannelAdapter;
import org.jasig.portal.MultithreadedCacheableMimeResponseCharacterChannelAdapter;
import org.jasig.portal.MultithreadedChannelAdapter;
import org.jasig.portal.MultithreadedCharacterChannelAdapter;
import org.jasig.portal.MultithreadedMimeResponseChannelAdapter;
import org.jasig.portal.MultithreadedMimeResponseCharacterChannelAdapter;
import org.jasig.portal.MultithreadedPrivilegedCacheableChannelAdapter;
import org.jasig.portal.MultithreadedPrivilegedCacheableCharacterChannelAdapter;
import org.jasig.portal.MultithreadedPrivilegedCacheableMimeResponseChannelAdapter;
import org.jasig.portal.MultithreadedPrivilegedCacheableMimeResponseCharacterChannelAdapter;
import org.jasig.portal.MultithreadedPrivilegedChannelAdapter;
import org.jasig.portal.MultithreadedPrivilegedCharacterChannelAdapter;
import org.jasig.portal.MultithreadedPrivilegedMimeResponseChannelAdapter;
import org.jasig.portal.MultithreadedPrivilegedMimeResponseCharacterChannelAdapter;
import org.jasig.portal.PortalException;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.services.LogService;

public class ChannelFactory {
    public static final Hashtable staticChannels = new Hashtable();
    private static ClassLoader classLoader = CarResources.getInstance().getClassLoader();

    public static IChannel instantiateLayoutChannel(String channelSubscribeId, IUserLayoutManager ulm, String sessionId) throws PortalException {
        IUserLayoutChannelDescription channel = (IUserLayoutChannelDescription)ulm.getNode(channelSubscribeId);
        if (channel != null) {
            String className = channel.getClassName();
            String channelPublishId = channel.getChannelPublishId();
            long timeOut = channel.getTimeout();
            try {
                return ChannelFactory.instantiateChannel(channelSubscribeId, channelPublishId, className, timeOut, channel.getParameterMap(), sessionId);
            }
            catch (Exception ex) {
                LogService.log(LogService.ERROR, "ChannelManager::instantiateChannel() : unable to instantiate channel class \"" + className + "\". " + ex);
                return null;
            }
        }
        return null;
    }

    public static IChannel instantiateLayoutChannel(IUserLayoutChannelDescription description, String sessionId) throws PortalException {
        return ChannelFactory.instantiateChannel(description.getChannelSubscribeId(), description.getChannelPublishId(), description.getClassName(), description.getTimeout(), description.getParameterMap(), sessionId);
    }

    private static IChannel instantiateChannel(String channelSubscribeId, String channelPublishId, String className, long timeOut, Map params, String sessionId) throws PortalException {
        String uid = sessionId + "/" + channelSubscribeId;
        return ChannelFactory.instantiateChannel(className, uid);
    }

    public static IChannel instantiateChannel(String className, String uid) throws PortalException {
        IChannel ch = null;
        boolean exists = false;
        Object cobj = staticChannels.get(className);
        if (cobj != null) {
            exists = true;
        } else {
            Class<?> channelClass = null;
            try {
                channelClass = classLoader.loadClass(className);
            }
            catch (Exception e) {
                throw new PortalException("Unable to load class '" + className + "'", e);
            }
            try {
                cobj = channelClass.newInstance();
            }
            catch (Throwable t) {
                throw new PortalException("Unable to instantiate class '" + className + "'", new Exception(t.getMessage()));
            }
        }
        if (cobj instanceof IMultithreadedCharacterChannel) {
            ch = cobj instanceof IMultithreadedCacheable ? (cobj instanceof IMultithreadedPrivileged ? (cobj instanceof IMultithreadedMimeResponse ? new MultithreadedPrivilegedCacheableMimeResponseCharacterChannelAdapter((IMultithreadedCharacterChannel)cobj, uid) : new MultithreadedPrivilegedCacheableCharacterChannelAdapter((IMultithreadedCharacterChannel)cobj, uid)) : (cobj instanceof IMultithreadedMimeResponse ? new MultithreadedCacheableMimeResponseCharacterChannelAdapter((IMultithreadedCharacterChannel)cobj, uid) : new MultithreadedCacheableCharacterChannelAdapter((IMultithreadedCharacterChannel)cobj, uid))) : (cobj instanceof IMultithreadedPrivileged ? (cobj instanceof IMultithreadedMimeResponse ? new MultithreadedPrivilegedMimeResponseCharacterChannelAdapter((IMultithreadedCharacterChannel)cobj, uid) : new MultithreadedPrivilegedCharacterChannelAdapter((IMultithreadedCharacterChannel)cobj, uid)) : (cobj instanceof IMultithreadedMimeResponse ? new MultithreadedMimeResponseCharacterChannelAdapter((IMultithreadedCharacterChannel)cobj, uid) : new MultithreadedCharacterChannelAdapter((IMultithreadedCharacterChannel)cobj, uid)));
            if (!exists) {
                staticChannels.put(className, cobj);
            }
        } else if (cobj instanceof IMultithreadedChannel) {
            ch = cobj instanceof IMultithreadedCacheable ? (cobj instanceof IMultithreadedPrivileged ? (cobj instanceof IMultithreadedMimeResponse ? new MultithreadedPrivilegedCacheableMimeResponseChannelAdapter((IMultithreadedChannel)cobj, uid) : new MultithreadedPrivilegedCacheableChannelAdapter((IMultithreadedChannel)cobj, uid)) : (cobj instanceof IMultithreadedMimeResponse ? new MultithreadedCacheableMimeResponseChannelAdapter((IMultithreadedChannel)cobj, uid) : new MultithreadedCacheableChannelAdapter((IMultithreadedChannel)cobj, uid))) : (cobj instanceof IMultithreadedPrivileged ? (cobj instanceof IMultithreadedMimeResponse ? new MultithreadedPrivilegedMimeResponseChannelAdapter((IMultithreadedChannel)cobj, uid) : new MultithreadedPrivilegedChannelAdapter((IMultithreadedChannel)cobj, uid)) : (cobj instanceof IMultithreadedMimeResponse ? new MultithreadedMimeResponseChannelAdapter((IMultithreadedChannel)cobj, uid) : new MultithreadedChannelAdapter((IMultithreadedChannel)cobj, uid)));
            if (!exists) {
                staticChannels.put(className, cobj);
            }
        } else {
            ch = (IChannel)cobj;
        }
        return ch;
    }
}

