/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.ICCRegistry;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.LogService;

public class ChannelStaticData
extends Hashtable {
    private long m_timeout = Long.MAX_VALUE;
    private Context m_portalContext = null;
    private String m_channelPublishId = null;
    private String m_channelSubscribeId = null;
    private IPerson m_person = null;
    private ICCRegistry iccr = null;

    public IAuthorizationPrincipal getAuthorizationPrincipal() {
        return ChannelStaticData.getAuthorizationPrincipal(this.getPerson());
    }

    public static IAuthorizationPrincipal getAuthorizationPrincipal(IPerson person) {
        EntityIdentifier pid = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = null;
        try {
            ap = AuthorizationService.instance().newPrincipal(pid.getKey(), pid.getType());
        }
        catch (AuthorizationException ae) {
            LogService.log(LogService.ERROR, "Could not get authorization service: " + ae);
        }
        return ap;
    }

    public String getChannelPublishId() {
        return this.m_channelPublishId;
    }

    public String getChannelSubscribeId() {
        return this.m_channelSubscribeId;
    }

    public Context getJNDIContext() {
        return this.m_portalContext;
    }

    public synchronized String getParameter(String key) {
        return (String)super.get(key);
    }

    public IPerson getPerson() {
        return this.m_person;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public void setChannelPublishId(String channelPublishId) {
        this.m_channelPublishId = channelPublishId;
    }

    public void setChannelSubscribeId(String channelSubscribeId) {
        this.m_channelSubscribeId = channelSubscribeId;
    }

    public void setJNDIContext(Context c) {
        this.m_portalContext = c;
    }

    public String setParameter(String key, String value) {
        return super.put(key, value);
    }

    public void setParameters(Map params) {
        this.putAll(params);
    }

    public void setPerson(IPerson person) {
        this.m_person = person;
    }

    public void setTimeout(long value) {
        this.m_timeout = value;
    }

    public ICCRegistry getICCRegistry() {
        return this.iccr;
    }

    public void setICCRegistry(ICCRegistry registry) {
        this.iccr = registry;
    }
}

