/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionBindingEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.StructureStylesheetDescription;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.UserLayoutStoreFactory;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserPreferencesManager;
import org.jasig.portal.UserProfile;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.jndi.JNDIManager;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.UserLayoutManagerFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.PropsMatcher;

public class GuestUserPreferencesManager
extends UserPreferencesManager {
    Map stateTable = Collections.synchronizedMap(new HashMap());
    Hashtable sp_layouts;
    Hashtable up_layouts;
    Hashtable sp_cleanUPs;
    Hashtable up_cleanUPs = new Hashtable();
    Hashtable ts_descripts;
    Hashtable ss_descripts;
    Hashtable cached_profiles;
    IPerson m_person;
    LocaleManager localeManager;
    static final boolean SAVE_PROFILE_GUESSES = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.GuestUserPreferencesManager.save_profile_guesses");

    public GuestUserPreferencesManager(IPerson person) {
        super(person);
        this.sp_cleanUPs = new Hashtable();
        this.sp_layouts = new Hashtable();
        this.up_layouts = new Hashtable();
        this.cached_profiles = new Hashtable();
        this.ts_descripts = new Hashtable();
        this.ss_descripts = new Hashtable();
        this.m_person = person;
        this.ulsdb = UserLayoutStoreFactory.getUserLayoutStoreImpl();
    }

    public void unbindSession(String sessionId) {
        this.stateTable.remove(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSession(HttpServletRequest req) throws PortalException {
        MState newState;
        block37: {
            newState = new MState();
            try {
                UserProfile upl;
                String userAgent = req.getHeader("User-Agent");
                if (userAgent == null || userAgent.equals("")) {
                    userAgent = "null";
                }
                if ((upl = (UserProfile)this.cached_profiles.get(userAgent)) == null) {
                    Hashtable hashtable = this.cached_profiles;
                    synchronized (hashtable) {
                        upl = this.ulsdb.getUserProfile(this.m_person, userAgent);
                        if (upl == null) {
                            upl = this.ulsdb.getSystemProfile(userAgent);
                        }
                        if (upl != null) {
                            this.cached_profiles.put(userAgent, upl);
                        }
                    }
                }
                if (upl == null) {
                    if (uaMatcher == null) {
                        URL url = null;
                        try {
                            url = this.getClass().getResource("/properties/browser.mappings");
                            if (url != null) {
                                uaMatcher = new PropsMatcher(url.openStream());
                            }
                        }
                        catch (IOException ioe) {
                            LogService.log(LogService.ERROR, "GuestUserPreferencesManager::GuestUserPreferencesManager() : Exception occurred while loading browser mapping file: " + url + ". " + ioe);
                        }
                    }
                    if (uaMatcher != null) {
                        String profileId = uaMatcher.match(userAgent);
                        if (profileId != null) {
                            LogService.log(LogService.DEBUG, "GuestUserPreferencesManager::GuestUserPreferencesManager() : userAgent \"" + userAgent + "\" has matched to a profile " + profileId);
                            upl = this.ulsdb.getSystemProfileById(Integer.parseInt(profileId));
                            if (SAVE_PROFILE_GUESSES) {
                                this.ulsdb.setSystemBrowserMapping(userAgent, upl.getProfileId());
                            }
                        } else {
                            LogService.log(LogService.DEBUG, "GuestUserPreferencesManager::GuestUserPreferencesManager() : userAgent \"" + userAgent + "\" has not matched any profile.");
                        }
                    }
                }
                if (upl != null) {
                    UserPreferences cleanUP;
                    if (upl.isSystemProfile()) {
                        newState.ulm = (IUserLayoutManager)this.sp_layouts.get(new Integer(upl.getProfileId()));
                    } else {
                        newState.ulm = (IUserLayoutManager)this.up_layouts.get(new Integer(upl.getProfileId()));
                    }
                    if (newState.ulm == null) {
                        try {
                            upl.setLocaleManager(this.localeManager);
                            newState.ulm = UserLayoutManagerFactory.immutableUserLayoutManager(UserLayoutManagerFactory.getUserLayoutManager(this.m_person, upl));
                            if (upl.isSystemProfile()) {
                                this.sp_layouts.put(new Integer(upl.getProfileId()), newState.ulm);
                            } else {
                                this.up_layouts.put(new Integer(upl.getProfileId()), newState.ulm);
                            }
                        }
                        catch (PortalException pe) {
                            throw pe;
                        }
                        catch (Exception e) {
                            throw new PortalException("GuestUserPreferencesManager::registerSession() : caught an exception while trying to retreive a userLayout for user=\"" + this.m_person.getID() + "\", profile=\"" + upl.getProfileName() + "\".", e);
                        }
                    }
                    if ((cleanUP = upl.isSystemProfile() ? (UserPreferences)this.sp_cleanUPs.get(new Integer(upl.getProfileId())) : (UserPreferences)this.up_cleanUPs.get(new Integer(upl.getProfileId()))) == null) {
                        try {
                            cleanUP = this.ulsdb.getUserPreferences(this.m_person, upl);
                            if (cleanUP != null) {
                                if (upl.isSystemProfile()) {
                                    this.sp_cleanUPs.put(new Integer(upl.getProfileId()), cleanUP);
                                } else {
                                    this.up_cleanUPs.put(new Integer(upl.getProfileId()), cleanUP);
                                }
                            }
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, "GuestUserPreferencesManager::registerSession() : unable to find UP for a profile \"" + upl.getProfileName() + "\"");
                            cleanUP = new UserPreferences(upl);
                        }
                    }
                    if (cleanUP != null) {
                        newState.complete_up = new UserPreferences(cleanUP);
                    } else {
                        LogService.log(LogService.ERROR, "GuestUserPreferencesManager::registerSession() : unable to find UP for a profile \"" + upl.getProfileName() + "\"");
                        newState.complete_up = new UserPreferences(upl);
                    }
                    JNDIManager.initializeSessionContext(req.getSession(), Integer.toString(this.m_person.getID()), Integer.toString(upl.getLayoutId()), newState.ulm.getUserLayoutDOM());
                    break block37;
                }
                newState.unmapped_user_agent = true;
                LogService.log(LogService.DEBUG, "GuestUserPreferencesManager::registerSession() : unable to find a profile for user \"" + this.m_person.getID() + "\" and userAgent=\"" + userAgent + "\".");
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    throw new PortalException((Exception)t);
                }
                throw new PortalException(t.toString());
            }
        }
        this.stateTable.put(req.getSession(false).getId(), newState);
    }

    public void processUserPreferencesParameters(HttpServletRequest req) {
        String[] tcattrs;
        String[] scattrs;
        String[] sfattrs;
        String[] tparams;
        String[] sparams;
        MState state = (MState)this.stateTable.get(req.getSession(false).getId());
        if (state == null) {
            LogService.log(LogService.ERROR, "GuestUserPreferencesManager::processUserPreferencesParameters() : trying to envoke a method on a non-registered sessionId=\"" + req.getSession(false).getId() + "\".");
            return;
        }
        String root = req.getParameter("uP_root");
        if (root != null) {
            if (root.equals("me")) {
                UPFileSpec upfs = new UPFileSpec(req);
                root = upfs.getTargetNodeId();
            }
            if (root != null) {
                state.complete_up.getStructureStylesheetUserPreferences().putParameterValue("userLayoutRoot", root);
            } else {
                LogService.log(LogService.ERROR, "GuestUserPreferencesManager::processUserPreferencesParameters() : unable to extract channel ID. servletPath=\"" + req.getServletPath() + "\".");
            }
        }
        if ((sparams = req.getParameterValues("uP_sparam")) != null) {
            for (int i = 0; i < sparams.length; ++i) {
                String pValue = req.getParameter(sparams[i]);
                state.complete_up.getStructureStylesheetUserPreferences().putParameterValue(sparams[i], pValue);
                LogService.log(LogService.DEBUG, "GuestUserPreferencesManager::processUserPreferencesParameters() : setting sparam \"" + sparams[i] + "\"=\"" + pValue + "\".");
            }
        }
        if ((tparams = req.getParameterValues("uP_tparam")) != null) {
            for (int i = 0; i < tparams.length; ++i) {
                String pValue = req.getParameter(tparams[i]);
                state.complete_up.getThemeStylesheetUserPreferences().putParameterValue(tparams[i], pValue);
                LogService.log(LogService.DEBUG, "GuestUserPreferencesManager::processUserPreferencesParameters() : setting tparam \"" + tparams[i] + "\"=\"" + pValue + "\".");
            }
        }
        if ((sfattrs = req.getParameterValues("uP_sfattr")) != null) {
            for (int i = 0; i < sfattrs.length; ++i) {
                String aName = sfattrs[i];
                String[] aNode = req.getParameterValues(aName + "_folderId");
                if (aNode == null || aNode.length <= 0) continue;
                for (int j = 0; j < aNode.length; ++j) {
                    String aValue = req.getParameter(aName + "_" + aNode[j] + "_value");
                    state.complete_up.getStructureStylesheetUserPreferences().setFolderAttributeValue(aNode[j], aName, aValue);
                    LogService.log(LogService.DEBUG, "GuestUserPreferencesManager::processUserPreferencesParameters() : setting sfattr \"" + aName + "\" of \"" + aNode[j] + "\" to \"" + aValue + "\".");
                }
            }
        }
        if ((scattrs = req.getParameterValues("uP_scattr")) != null) {
            for (int i = 0; i < scattrs.length; ++i) {
                String aName = scattrs[i];
                String[] aNode = req.getParameterValues(aName + "_channelId");
                if (aNode == null || aNode.length <= 0) continue;
                for (int j = 0; j < aNode.length; ++j) {
                    String aValue = req.getParameter(aName + "_" + aNode[j] + "_value");
                    state.complete_up.getStructureStylesheetUserPreferences().setChannelAttributeValue(aNode[j], aName, aValue);
                    LogService.log(LogService.DEBUG, "GuestUserPreferencesManager::processUserPreferencesParameters() : setting scattr \"" + aName + "\" of \"" + aNode[j] + "\" to \"" + aValue + "\".");
                }
            }
        }
        if ((tcattrs = req.getParameterValues("uP_tcattr")) != null) {
            for (int i = 0; i < tcattrs.length; ++i) {
                String aName = tcattrs[i];
                String[] aNode = req.getParameterValues(aName + "_channelId");
                if (aNode == null || aNode.length <= 0) continue;
                for (int j = 0; j < aNode.length; ++j) {
                    String aValue = req.getParameter(aName + "_" + aNode[j] + "_value");
                    state.complete_up.getThemeStylesheetUserPreferences().setChannelAttributeValue(aNode[j], aName, aValue);
                    LogService.log(LogService.DEBUG, "GuestUserPreferencesManager::processUserPreferencesParameters() : setting tcattr \"" + aName + "\" of \"" + aNode[j] + "\" to \"" + aValue + "\".");
                }
            }
        }
    }

    protected String getChannelGlobalId(String channelSubscribeId, String sessionId) throws PortalException {
        IUserLayoutChannelDescription channel = (IUserLayoutChannelDescription)this.getUserLayoutManager(sessionId).getNode(channelSubscribeId);
        if (channel != null) {
            return channel.getChannelPublishId();
        }
        return null;
    }

    public boolean isUserAgentUnmapped(String sessionId) {
        MState state = (MState)this.stateTable.get(sessionId);
        if (state == null) {
            LogService.log(LogService.ERROR, "GuestUserPreferencesManager::userAgentUnmapped() : trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
            return false;
        }
        return state.unmapped_user_agent;
    }

    public boolean isUserAgentUnmapped() {
        throw new UnsupportedOperationException();
    }

    public UserPreferences getUserPreferences(String sessionId) {
        MState state = (MState)this.stateTable.get(sessionId);
        if (state == null) {
            LogService.log(LogService.ERROR, "GuestUserPreferencesManager::getUserPreferences() : trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
            return null;
        }
        return state.complete_up;
    }

    public UserPreferences getUserPreferences() {
        throw new UnsupportedOperationException();
    }

    public void setNewUserLayoutAndUserPreferences(IUserLayoutManager newLayout, UserPreferences newPreferences, String sessionId) throws PortalException {
    }

    public void setNewUserLayoutAndUserPreferences(IUserLayoutManager newLayout, UserPreferences newPreferences) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public UserPreferences getUserPreferencesCopy(String sessionId) {
        return new UserPreferences(this.getUserPreferences(sessionId));
    }

    public UserPreferences getUserPreferencesCopy() {
        throw new UnsupportedOperationException();
    }

    public UserProfile getCurrentProfile(String sessionId) {
        return this.getUserPreferences(sessionId).getProfile();
    }

    public UserProfile getCurrentProfile() {
        throw new UnsupportedOperationException();
    }

    public ThemeStylesheetDescription getThemeStylesheetDescription(String sessionId) throws Exception {
        MState state = (MState)this.stateTable.get(sessionId);
        if (state == null) {
            LogService.log(LogService.ERROR, "GuestUserPreferencesManager::getThemeStylesheetDescription() : trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
            return null;
        }
        if (state.tsd == null) {
            int sid = state.complete_up.getProfile().getThemeStylesheetId();
            state.tsd = (ThemeStylesheetDescription)this.ts_descripts.get(new Integer(sid));
            if (state.tsd == null) {
                state.tsd = this.ulsdb.getThemeStylesheetDescription(sid);
                this.ts_descripts.put(new Integer(sid), state.tsd);
            }
        }
        return state.tsd;
    }

    public ThemeStylesheetDescription getThemeStylesheetDescription() {
        throw new UnsupportedOperationException();
    }

    public StructureStylesheetDescription getStructureStylesheetDescription(String sessionId) throws Exception {
        MState state = (MState)this.stateTable.get(sessionId);
        if (state == null) {
            LogService.log(LogService.ERROR, "GuestUserPreferencesManager::getThemeStylesheetDescription() : trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
            return null;
        }
        if (state.ssd == null) {
            int sid = state.complete_up.getProfile().getStructureStylesheetId();
            state.ssd = (StructureStylesheetDescription)this.ss_descripts.get(new Integer(sid));
            if (state.ssd == null) {
                state.ssd = this.ulsdb.getStructureStylesheetDescription(sid);
                this.ss_descripts.put(new Integer(sid), state.ssd);
            }
        }
        return state.ssd;
    }

    public StructureStylesheetDescription getStructureStylesheetDescription() {
        throw new UnsupportedOperationException();
    }

    public IUserLayoutManager getUserLayoutManager(String sessionId) {
        MState state = (MState)this.stateTable.get(sessionId);
        if (state == null) {
            LogService.log(LogService.ERROR, "GuestUserPreferencesManager::getUserLayout() : trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
            return null;
        }
        return state.ulm;
    }

    public IUserLayoutManager getUserLayoutManager() {
        throw new UnsupportedOperationException();
    }

    public void finishedSession(HttpSessionBindingEvent bindingEvent, String sessionId) {
        this.stateTable.remove(sessionId);
    }

    public void finishedSession(HttpSessionBindingEvent bindingEvent) {
        throw new UnsupportedOperationException();
    }

    public void setLocaleManager(LocaleManager lm) {
        this.localeManager = lm;
    }

    private class MState {
        private ThemeStylesheetDescription tsd = null;
        private StructureStylesheetDescription ssd = null;
        private boolean unmapped_user_agent = false;
        private UserPreferences complete_up = null;
        private IUserLayoutManager ulm;
    }
}

