/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.serialize.BaseMarkupSerializer;
import org.jasig.portal.serialize.CachingHTMLSerializer;
import org.jasig.portal.serialize.CachingXHTMLSerializer;
import org.jasig.portal.serialize.OutputFormat;
import org.jasig.portal.serialize.XMLSerializer;
import org.jasig.portal.services.LogService;

public class MediaManager {
    protected OrderedProps mediaProps = null;
    protected OrderedProps mimeProps = null;
    protected OrderedProps serializerProps = null;
    private static boolean outputIndenting = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.MediaManager.output_indenting");
    private static boolean omitDoctype = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.MediaManager.omit_doctype");
    public static final String NULL_USER_AGENT = "null";

    public MediaManager() {
    }

    public MediaManager(String mediaPropsFile, String mimePropsFile, String serializerPropsFile) {
        this.setMediaProps(mediaPropsFile);
        this.setMimeProps(mimePropsFile);
        this.setSerializerProps(serializerPropsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaProps(String uri) {
        block5: {
            URL url = null;
            try {
                url = uri == null ? this.getClass().getResource("/properties/media.properties") : new URL(uri);
                if (url == null) break block5;
                InputStream in = url.openStream();
                try {
                    this.mediaProps = new OrderedProps(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                LogService.log(LogService.ERROR, "MediaManager::setMediaProps : Exception occurred while loading media properties file: " + uri + ". " + ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMimeProps(String uri) {
        block5: {
            URL url = null;
            try {
                url = uri == null ? this.getClass().getResource("/properties/mime.properties") : new URL(uri);
                if (url == null) break block5;
                InputStream in = url.openStream();
                try {
                    this.mimeProps = new OrderedProps(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                LogService.log(LogService.ERROR, "MediaManager::setMimeProps : Exception occurred while loading mime properties file: " + uri + ". " + ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSerializerProps(String uri) {
        block5: {
            URL url = null;
            try {
                url = uri == null ? this.getClass().getResource("/properties/serializer.properties") : new URL(uri);
                if (url == null) break block5;
                InputStream in = url.openStream();
                try {
                    this.serializerProps = new OrderedProps(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                LogService.log(LogService.ERROR, "MediaManager::setSerializerProps : Exception occurred while loading serializer properties file: " + uri + ". " + ioe);
            }
        }
    }

    public String getMedia(HttpServletRequest req) {
        if (this.mediaProps == null) {
            this.setMediaProps(null);
        }
        if (this.mediaProps != null) {
            String ua = req.getHeader("User-Agent");
            if (ua == null || ua.equals("")) {
                ua = NULL_USER_AGENT;
            }
            return this.mediaProps.getValue(ua);
        }
        return null;
    }

    public String getMedia(BrowserInfo bi) {
        if (this.mediaProps == null) {
            this.setMediaProps(null);
        }
        if (this.mediaProps != null) {
            return this.mediaProps.getValue(bi.getUserAgent());
        }
        return null;
    }

    public String getDefaultMedia() {
        if (this.mediaProps == null) {
            this.setMediaProps(null);
        }
        if (this.mediaProps != null) {
            return this.mediaProps.getDefaultValue();
        }
        return null;
    }

    public String getReturnMimeType(HttpServletRequest req) {
        return this.getReturnMimeType(this.getMedia(req));
    }

    public String getReturnMimeType(String mediaType) {
        if (this.mimeProps == null) {
            this.setMimeProps(null);
        }
        if (this.mimeProps != null) {
            return this.mimeProps.getValue(mediaType);
        }
        return null;
    }

    public BaseMarkupSerializer getSerializer(String mediaType, Writer out) {
        String serializerName = null;
        if (this.serializerProps == null) {
            this.setSerializerProps(null);
        }
        if (this.serializerProps != null) {
            serializerName = this.serializerProps.getValue(mediaType);
        }
        if (serializerName != null) {
            return this.getSerializerByName(serializerName, out);
        }
        LogService.log(LogService.ERROR, "MediaManager::getSerializer() : Unable to initialize serializerProperties. Returning a null serializer object");
        return null;
    }

    public BaseMarkupSerializer getSerializerByName(String serializerName, OutputStream out) throws UnsupportedEncodingException {
        return this.getSerializerByName(serializerName, new OutputStreamWriter(out, "UTF-8"));
    }

    public BaseMarkupSerializer getSerializerByName(String serializerName, Writer out) {
        if (serializerName != null && serializerName.equals("WML")) {
            OutputFormat frmt = new OutputFormat("wml", "UTF-8", true);
            frmt.setDoctype("-//WAPFORUM//DTD WML 1.1//EN", "http://www.wapforum.org/DTD/wml_1.1.xml");
            return new XMLSerializer(out, frmt);
        }
        if (serializerName != null && serializerName.equals("XML")) {
            OutputFormat frmt = new OutputFormat("XML", "UTF-8", true);
            return new XMLSerializer(out, frmt);
        }
        if (serializerName != null && serializerName.equals("XHTML")) {
            OutputFormat frmt = new OutputFormat("XHTML", "UTF-8", true);
            frmt.setPreserveSpace(true);
            frmt.setIndenting(outputIndenting);
            frmt.setDoctype("-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
            frmt.setOmitDocumentType(omitDoctype);
            return new CachingXHTMLSerializer(out, frmt);
        }
        OutputFormat frmt = new OutputFormat("HTML", "UTF-8", true);
        frmt.setPreserveSpace(true);
        frmt.setIndenting(outputIndenting);
        frmt.setDoctype("-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd");
        frmt.setOmitDocumentType(omitDoctype);
        return new CachingHTMLSerializer(out, frmt);
    }

    public BaseMarkupSerializer getSerializer(String mediaType, OutputStream out) throws UnsupportedEncodingException {
        return this.getSerializer(mediaType, (Writer)new OutputStreamWriter(out, "UTF-8"));
    }

    public BaseMarkupSerializer getSerializer(HttpServletRequest req, Writer out) {
        if (this.mediaProps == null) {
            this.setMediaProps(null);
        }
        if (this.mediaProps != null) {
            String ua = req.getHeader("User-Agent");
            if (ua == null || ua.equals("")) {
                ua = NULL_USER_AGENT;
            }
            return this.getSerializer(this.mediaProps.getValue(ua), out);
        }
        LogService.log(LogService.ERROR, "MediaManager::getSerializer() : Unable to initialize mediaProperties. Returning a null serializer object");
        return null;
    }

    public BaseMarkupSerializer getSerializer(HttpServletRequest req, OutputStream out) throws UnsupportedEncodingException {
        return this.getSerializer(req, (Writer)new OutputStreamWriter(out, "UTF-8"));
    }

    class OrderedProps {
        private Vector attVec = new Vector(15);

        OrderedProps(InputStream inputStream) throws IOException {
            String currentLine;
            BufferedReader input = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String Key2 = null;
            while ((currentLine = input.readLine()) != null) {
                StringTokenizer currentTokens = new StringTokenizer(currentLine, "=\t\r\n");
                if (currentTokens.hasMoreTokens()) {
                    Key2 = currentTokens.nextToken().trim();
                }
                if (Key2 == null || Key2.startsWith("#") || !currentTokens.hasMoreTokens()) continue;
                String[] temp = new String[]{Key2, currentTokens.nextToken().trim()};
                this.attVec.addElement(temp);
            }
            input.close();
        }

        String getValue(String s) {
            int j = this.attVec.size();
            for (int i = 0; i < j; ++i) {
                String[] temp = (String[])this.attVec.elementAt(i);
                if (s.indexOf(temp[0]) <= -1) continue;
                return temp[1];
            }
            return "unknown";
        }

        String getDefaultValue() {
            return ((String[])this.attVec.elementAt(0))[1];
        }
    }
}

