/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import org.jasig.portal.ErrorID;
import org.jasig.portal.Errors;

public class PortalException
extends Exception {
    boolean reinstantiable = true;
    boolean refreshable = true;
    boolean logPending = true;
    ErrorID errorID = Errors.legacy;
    String parameter = null;
    Date timestamp = new Date();
    Exception recordedException;

    public PortalException() {
    }

    public PortalException(Exception exc) {
        this.recordedException = exc;
    }

    public PortalException(String msg) {
        super(msg);
    }

    public PortalException(ErrorID errorid) {
        super(errorid.getMessage());
        this.errorID = errorid;
    }

    public PortalException(String msg, Exception exc) {
        super(msg);
        this.recordedException = exc;
    }

    public PortalException(ErrorID errorid, Exception exc) {
        super(errorid.getMessage());
        this.errorID = errorid;
        this.recordedException = exc;
    }

    public boolean isRefreshable() {
        return this.refreshable;
    }

    public boolean allowRefresh() {
        return this.isRefreshable();
    }

    public boolean isReinstantiable() {
        return this.reinstantiable;
    }

    public boolean allowReinstantiation() {
        return this.isReinstantiable();
    }

    public Exception getRecordedException() {
        return this.recordedException;
    }

    public void setRefreshable(boolean refresh) {
        this.refreshable = refresh;
    }

    public void setReinstantiable(boolean reinstantiate) {
        this.reinstantiable = reinstantiate;
    }

    public void setRecordedException(Exception exc) {
        this.recordedException = exc;
    }

    public boolean isLogPending() {
        return this.logPending;
    }

    public void setLogPending(boolean b) {
        this.logPending = b;
    }

    public ErrorID getErrorID() {
        return this.errorID;
    }

    public void setErrorID(ErrorID errorID) {
        this.errorID = errorID;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String string) {
        this.parameter = string;
    }

    public PortalException(String msg, boolean refresh, boolean reinstantiate) {
        super(msg);
        this.setReinstantiable(reinstantiate);
        this.setRefreshable(refresh);
    }

    public PortalException(String msg, Exception exc, boolean refresh, boolean reinstantiate) {
        this(msg, refresh, reinstantiate);
        this.setRecordedException(exc);
    }

    public String getMessage() {
        String lmsg;
        StringBuffer sb = new StringBuffer(String.valueOf(super.getMessage()));
        Exception ex = this.getRecordedException();
        if (ex != null && (lmsg = ex.getMessage()) != null) {
            sb.append("\n   [based on exception: ");
            sb.append(lmsg);
            sb.append("]");
        }
        return sb.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.out);
    }

    public void printStackTrace(PrintWriter writer) {
        if (this.getRecordedException() != null) {
            this.getRecordedException().printStackTrace(writer);
        } else {
            super.printStackTrace(writer);
        }
    }

    public void printStackTrace(PrintStream stream) {
        this.printStackTrace(new PrintWriter(stream, true));
    }

    public Date getTimestamp() {
        return this.timestamp;
    }
}

