/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.CounterStoreFactory;

public class RDBMUserIdentityStore
implements IUserIdentityStore {
    private static final String templateAttrName = "uPortalTemplateUserName";
    private static final int guestUID = 1;
    static int DEBUG = 0;
    protected RDBMServices rdbmService = new RDBMServices();

    public int getPortalUID(IPerson person) throws AuthorizationException {
        int uPortalUID = -1;
        uPortalUID = this.getPortalUID(person, false);
        return uPortalUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePortalUID(int uPortalUID) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            if (RDBMServices.supportsTransactions) {
                con.setAutoCommit(false);
            }
            try {
                String SQLDelete = "DELETE FROM UP_USER WHERE USER_ID = " + uPortalUID;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::removePortalUID(): " + SQLDelete);
                stmt.executeUpdate(SQLDelete);
                SQLDelete = "DELETE FROM UP_USER_LAYOUT  WHERE USER_ID = " + uPortalUID;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::removePortalUID(): " + SQLDelete);
                stmt.executeUpdate(SQLDelete);
                SQLDelete = "DELETE FROM UP_USER_PARAM WHERE USER_ID = " + uPortalUID;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::removePortalUID(): " + SQLDelete);
                stmt.executeUpdate(SQLDelete);
                SQLDelete = "DELETE FROM UP_USER_PROFILE  WHERE USER_ID = " + uPortalUID;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::removePortalUID(): " + SQLDelete);
                stmt.executeUpdate(SQLDelete);
                SQLDelete = "DELETE FROM UP_SS_USER_ATTS WHERE USER_ID = " + uPortalUID;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::removePortalUID(): " + SQLDelete);
                stmt.executeUpdate(SQLDelete);
                SQLDelete = "DELETE FROM UP_SS_USER_PARM  WHERE USER_ID = " + uPortalUID;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::removePortalUID(): " + SQLDelete);
                stmt.executeUpdate(SQLDelete);
                SQLDelete = "DELETE FROM UP_LAYOUT_PARAM WHERE USER_ID = " + uPortalUID;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::removePortalUID(): " + SQLDelete);
                stmt.executeUpdate(SQLDelete);
                SQLDelete = "DELETE FROM UP_USER_UA_MAP WHERE USER_ID = " + uPortalUID;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::removePortalUID(): " + SQLDelete);
                stmt.executeUpdate(SQLDelete);
                SQLDelete = "DELETE FROM UP_LAYOUT_STRUCT  WHERE USER_ID = " + uPortalUID;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::removePortalUID(): " + SQLDelete);
                stmt.executeUpdate(SQLDelete);
                if (RDBMServices.supportsTransactions) {
                    con.commit();
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException se) {
            try {
                if (RDBMServices.supportsTransactions) {
                    con.rollback();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            if (DEBUG > 0) {
                System.err.println("SQLException: " + se.getMessage());
                System.err.println("SQLState:  " + se.getSQLState());
                System.err.println("Message:  " + se.getMessage());
                System.err.println("Vendor:  " + se.getErrorCode());
            }
            AuthorizationException ae = new AuthorizationException("SQL Database Error");
            LogService.log(LogService.ERROR, "RDBMUserIdentityStore::removePortalUID(): " + ae);
            throw ae;
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public synchronized int getPortalUID(IPerson person, boolean createPortalData) throws AuthorizationException {
        Connection con;
        int uPortalUID;
        block63: {
            ResultSet rset;
            Statement insertStmt;
            Statement stmt;
            block60: {
                void var10_17;
                void var12_19;
                void var11_18;
                int newUID;
                int templateUSER_DFLT_LAY_ID;
                int templateUSER_DFLT_USR_ID;
                int templateUID;
                uPortalUID = -1;
                con = RDBMServices.getConnection();
                stmt = null;
                insertStmt = null;
                rset = null;
                try {
                    stmt = con.createStatement();
                    insertStmt = con.createStatement();
                }
                catch (SQLException se) {
                    try {
                        RDBMServices.releaseConnection(con);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    LogService.log(LogService.ERROR, "RDBMUserIdentityStore::getPortalUID(): Could not create database statement", se);
                    throw new AuthorizationException("RDBMUserIdentityStore: Could not create database statement");
                }
                String query = "SELECT USER_ID, USER_NAME FROM UP_USER WHERE USER_NAME = '" + person.getAttribute("username") + "'";
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + query);
                rset = stmt.executeQuery(query);
                if (rset.next()) {
                    uPortalUID = rset.getInt("USER_ID");
                    break block60;
                }
                if (!createPortalData) {
                    throw new AuthorizationException("No portal information exists for user " + person.getAttribute("username"));
                }
                Date templateLST_CHAN_UPDT_DT = new Date(System.currentTimeMillis());
                String defaultTemplateUserName = PropertiesManager.getProperty("org.jasig.portal.services.Authentication.defaultTemplateUserName");
                String templateName = (String)person.getAttribute(templateAttrName);
                if (DEBUG > 0) {
                    System.err.println("Attempting to autocreate user from template " + templateName);
                }
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): template name is " + templateName);
                if (templateName == null || templateName.equals("")) {
                    templateName = defaultTemplateUserName;
                }
                query = "SELECT USER_ID, USER_DFLT_USR_ID, USER_DFLT_LAY_ID, NEXT_STRUCT_ID, LST_CHAN_UPDT_DT FROM UP_USER WHERE USER_NAME = '" + templateName + "'";
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + query);
                rset.close();
                rset = stmt.executeQuery(query);
                if (rset.next()) {
                    templateUSER_DFLT_USR_ID = templateUID = rset.getInt("USER_ID");
                    templateUSER_DFLT_LAY_ID = rset.getInt("USER_DFLT_LAY_ID");
                } else {
                    if (templateName.equals(defaultTemplateUserName)) {
                        throw new AuthorizationException("No information found for template user = " + templateName + ". Cannot create new account for " + person.getAttribute("username"));
                    }
                    templateName = defaultTemplateUserName;
                    query = "SELECT USER_ID, USER_DFLT_USR_ID, USER_DFLT_LAY_ID, NEXT_STRUCT_ID, LST_CHAN_UPDT_DT FROM UP_USER WHERE USER_NAME = '" + templateName + "'";
                    LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + query);
                    rset.close();
                    rset = stmt.executeQuery(query);
                    if (rset.next()) {
                        templateUSER_DFLT_USR_ID = templateUID = rset.getInt("USER_ID");
                        templateUSER_DFLT_LAY_ID = rset.getInt("USER_DFLT_LAY_ID");
                    } else {
                        throw new AuthorizationException("No information found for template user = " + templateName + ". Cannot create new account for " + person.getAttribute("username"));
                    }
                }
                try {
                    newUID = CounterStoreFactory.getCounterStoreImpl().getIncrementIntegerId("UP_USER");
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, "RDBMUserIdentityStore::getPortalUID(): error getting next sequence: ", e);
                    throw new AuthorizationException("RDBMUserIdentityStore error, see error log.");
                }
                try {
                    IGroupMember me = GroupService.getGroupMember(person.getEntityIdentifier());
                    IEntity template = GroupService.getEntity(templateName, Class.forName("org.jasig.portal.security.IPerson"));
                    Iterator templateGroups = template.getContainingGroups();
                    while (templateGroups.hasNext()) {
                        IEntityGroup eg = (IEntityGroup)templateGroups.next();
                        eg.addMember(me);
                        eg.updateMembers();
                    }
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, "RDBMUserIdentityStore::getPortalUID(): error adding new user to groups: ", e);
                }
                try {
                    if (RDBMServices.supportsTransactions) {
                        con.setAutoCommit(false);
                    }
                }
                catch (SQLException se) {
                    LogService.log(LogService.WARN, "RDBMUserIdentityStore: Could not turn off autocommit", se);
                }
                String Insert = new String();
                Insert = "INSERT INTO UP_USER (USER_ID, USER_NAME, USER_DFLT_USR_ID, USER_DFLT_LAY_ID, NEXT_STRUCT_ID, LST_CHAN_UPDT_DT)  VALUES (" + newUID + ", '" + person.getAttribute("username") + "'," + (int)var11_18 + ", " + (int)var12_19 + ", " + "null, " + "null)";
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + Insert);
                stmt.executeUpdate(Insert);
                query = "SELECT USER_ID,LAYOUT_ID,LAYOUT_TITLE,INIT_STRUCT_ID FROM UP_USER_LAYOUT WHERE USER_ID=" + (int)var10_17;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + query);
                if (DEBUG > 0) {
                    System.err.println(query);
                }
                rset.close();
                rset = stmt.executeQuery(query);
                while (rset.next()) {
                    Insert = "INSERT INTO UP_USER_LAYOUT (USER_ID,LAYOUT_ID,LAYOUT_TITLE,INIT_STRUCT_ID) VALUES(" + newUID + "," + rset.getInt("LAYOUT_ID") + "," + "'" + rset.getString("LAYOUT_TITLE") + "'," + "NULL)";
                    LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + Insert);
                    if (DEBUG > 0) {
                        System.err.println(Insert);
                    }
                    insertStmt.executeUpdate(Insert);
                }
                query = "SELECT USER_ID,USER_PARAM_NAME,USER_PARAM_VALUE FROM UP_USER_PARAM WHERE USER_ID=" + (int)var10_17;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + query);
                if (DEBUG > 0) {
                    System.err.println(query);
                }
                rset.close();
                rset = stmt.executeQuery(query);
                while (rset.next()) {
                    Insert = "INSERT INTO UP_USER_PARAM (USER_ID, USER_PARAM_NAME, USER_PARAM_VALUE ) VALUES(" + newUID + "," + ",'" + rset.getString("USER_PARAM_NAME") + "'," + ",'" + rset.getString("USER_PARAM_VALUE") + "')";
                    LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + Insert);
                    if (DEBUG > 0) {
                        System.err.println(Insert);
                    }
                    stmt.executeUpdate(Insert);
                }
                query = "SELECT USER_ID, PROFILE_ID, PROFILE_NAME, DESCRIPTION FROM UP_USER_PROFILE WHERE USER_ID=" + (int)var10_17;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + query);
                if (DEBUG > 0) {
                    System.err.println(query);
                }
                rset.close();
                rset = stmt.executeQuery(query);
                while (rset.next()) {
                    Insert = "INSERT INTO UP_USER_PROFILE (USER_ID, PROFILE_ID, PROFILE_NAME, DESCRIPTION, LAYOUT_ID, STRUCTURE_SS_ID, THEME_SS_ID ) VALUES(" + newUID + "," + rset.getInt("PROFILE_ID") + "," + "'" + rset.getString("PROFILE_NAME") + "'," + "'" + rset.getString("DESCRIPTION") + "'," + "NULL," + "NULL," + "NULL)";
                    LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + Insert);
                    if (DEBUG > 0) {
                        System.err.println(Insert);
                    }
                    insertStmt.executeUpdate(Insert);
                }
                query = " SELECT USER_ID, USER_AGENT, PROFILE_ID FROM UP_USER_UA_MAP WHERE USER_ID=" + (int)var10_17;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + query);
                if (DEBUG > 0) {
                    System.err.println(query);
                }
                rset.close();
                rset = stmt.executeQuery(query);
                while (rset.next()) {
                    Insert = "INSERT INTO UP_USER_UA_MAP (USER_ID, USER_AGENT, PROFILE_ID) VALUES(" + newUID + "," + "'" + rset.getString("USER_AGENT") + "'," + rset.getInt("PROFILE_ID") + ")";
                    LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + Insert);
                    if (DEBUG > 0) {
                        System.err.println(Insert);
                    }
                    insertStmt.executeUpdate(Insert);
                }
                query = "SELECT USER_ID, PROFILE_ID, SS_ID, SS_TYPE, PARAM_NAME, PARAM_VAL  FROM UP_SS_USER_PARM WHERE USER_ID=" + (int)var10_17;
                LogService.log(LogService.DEBUG, "RDBMUserIdentityStore::getPortalUID(): " + query);
                if (DEBUG > 0) {
                    System.err.println(query);
                }
                rset.close();
                rset = stmt.executeQuery(query);
                while (rset.next()) {
                    Insert = "INSERT INTO UP_SS_USER_PARM (USER_ID, PROFILE_ID, SS_ID, SS_TYPE, PARAM_NAME, PARAM_VAL) VALUES(" + newUID + "," + rset.getInt("PROFILE_ID") + "," + rset.getInt("SS_ID") + "," + rset.getInt("SS_TYPE") + "," + "'" + rset.getString("PARAM_NAME") + "'," + "'" + rset.getString("PARAM_VAL") + "')";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setUserLayout(): " + Insert);
                    if (DEBUG > 0) {
                        System.err.println(Insert);
                    }
                    insertStmt.executeUpdate(Insert);
                }
                if (RDBMServices.supportsTransactions) {
                    con.commit();
                    uPortalUID = newUID;
                    break block60;
                }
                uPortalUID = newUID;
            }
            Object var21_27 = null;
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
            try {
                if (insertStmt != null) {
                    insertStmt.close();
                }
                break block63;
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
            {
                break block63;
                catch (SQLException se) {
                    LogService.log(LogService.ERROR, "RDBMUserIdentityStore::getPortalUID(): " + se);
                    try {
                        if (RDBMServices.supportsTransactions) {
                            con.rollback();
                        }
                    }
                    catch (SQLException e) {
                        LogService.log(LogService.WARN, "RDBMUserIdentityStore.getPortalUID(): Unable to rollback transaction", se);
                    }
                    if (DEBUG > 0) {
                        System.err.println("SQLException: " + se.getMessage());
                        System.err.println("SQLState:  " + se.getSQLState());
                        System.err.println("Message:  " + se.getMessage());
                        System.err.println("Vendor:  " + se.getErrorCode());
                    }
                    throw new AuthorizationException("SQL database error while retrieving user's portal UID");
                }
            }
            catch (Throwable throwable) {
                Object var21_28 = null;
                try {
                    if (rset != null) {
                        rset.close();
                    }
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, e);
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, e);
                }
                try {
                    if (insertStmt != null) {
                        insertStmt.close();
                    }
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, e);
                }
                RDBMServices.releaseConnection(con);
                throw throwable;
            }
        }
        RDBMServices.releaseConnection(con);
        return uPortalUID;
    }

    protected static final void commit(Connection connection) {
        try {
            if (RDBMServices.supportsTransactions) {
                connection.commit();
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMUserIdentityStore::commit(): " + e);
        }
    }

    protected static final void rollback(Connection connection) {
        try {
            if (RDBMServices.supportsTransactions) {
                connection.rollback();
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMUserIdentityStore::rollback(): " + e);
        }
    }
}

