/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.services.LogService;

public class StructureStylesheetUserPreferences
extends ThemeStylesheetUserPreferences {
    protected Hashtable folderAttributeNumbers;
    protected Hashtable folderAttributeValues;
    protected ArrayList defaultFolderAttributeValues;

    public StructureStylesheetUserPreferences() {
        this.folderAttributeNumbers = new Hashtable();
        this.folderAttributeValues = new Hashtable();
        this.defaultFolderAttributeValues = new ArrayList();
    }

    public StructureStylesheetUserPreferences(StructureStylesheetUserPreferences fsup) {
        super(fsup);
        this.folderAttributeNumbers = new Hashtable(fsup.folderAttributeNumbers);
        this.folderAttributeValues = new Hashtable(fsup.folderAttributeValues);
        this.defaultFolderAttributeValues = new ArrayList(fsup.defaultFolderAttributeValues);
    }

    public String getFolderAttributeValue(String folderID, String attributeName) {
        Integer attributeNumber = (Integer)this.folderAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            LogService.log(LogService.ERROR, "StructureStylesheetUserPreferences::getFolderAttributeValue() : Attempting to obtain a non-existing attribute \"" + attributeName + "\".");
            return null;
        }
        String value = null;
        List l = (List)this.folderAttributeValues.get(folderID);
        if (l == null) {
            return (String)this.defaultFolderAttributeValues.get(attributeNumber);
        }
        if (attributeNumber < l.size()) {
            value = (String)l.get(attributeNumber);
        }
        if (value == null) {
            try {
                value = (String)this.defaultFolderAttributeValues.get(attributeNumber);
            }
            catch (IndexOutOfBoundsException e) {
                LogService.log(LogService.ERROR, "StructureStylesheetUserPreferences::getFolderAttributeValue() : internal error - attribute name is registered, but no default value is provided.");
                return null;
            }
        }
        return value;
    }

    public String getDefinedFolderAttributeValue(String folderID, String attributeName) {
        Integer attributeNumber = (Integer)this.folderAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            LogService.log(LogService.ERROR, "ThemeStylesheetUserPreferences::hasDefinedFolderAttributeValue() : Attempting to obtain a non-existing attribute \"" + attributeName + "\".");
            return null;
        }
        List l = (List)this.folderAttributeValues.get(folderID);
        if (l == null) {
            return null;
        }
        if (attributeNumber < l.size()) {
            return (String)l.get(attributeNumber);
        }
        return null;
    }

    public void setFolderAttributeValue(String folderID, String attributeName, String attributeValue) {
        Integer attributeNumber = (Integer)this.folderAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            LogService.log(LogService.ERROR, "StructureStylesheetUserPreferences::setFolderAttribute() : Attempting to set a non-existing folder attribute \"" + attributeName + "\".");
            return;
        }
        List l = (List)this.folderAttributeValues.get(folderID);
        if (l == null) {
            l = this.createFolder(folderID);
        }
        try {
            l.set(attributeNumber, attributeValue);
        }
        catch (IndexOutOfBoundsException e) {
            for (int i = l.size(); i < attributeNumber; ++i) {
                l.add(null);
            }
            l.add(attributeValue);
        }
    }

    public void addFolderAttribute(String attributeName, String defaultValue) {
        if (this.folderAttributeNumbers.get(attributeName) != null) {
            LogService.log(LogService.ERROR, "StructureStylesheetUserPreferences::addFolderAttribute() : Attempting to re-add an existing folder attribute \"" + attributeName + "\".");
        } else {
            this.folderAttributeNumbers.put(attributeName, new Integer(this.defaultFolderAttributeValues.size()));
            this.defaultFolderAttributeValues.add(defaultValue);
        }
    }

    public void setFolderAttributeDefaultValue(String attributeName, String defaultValue) {
        Integer attributeNumber = (Integer)this.folderAttributeNumbers.get(attributeName);
        this.defaultFolderAttributeValues.set(attributeNumber, defaultValue);
    }

    public void removeFolderAttribute(String attributeName) {
        Integer attributeNumber = (Integer)this.folderAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            LogService.log(LogService.ERROR, "StructureStylesheetUserPreferences::removeFolderAttribute() : Attempting to remove a non-existing folder attribute \"" + attributeName + "\".");
        } else {
            this.folderAttributeNumbers.remove(attributeName);
        }
    }

    public Enumeration getFolderAttributeNames() {
        return this.folderAttributeNumbers.keys();
    }

    public void addFolder(String folderID) {
        ArrayList l = new ArrayList(this.defaultFolderAttributeValues.size());
        if (this.folderAttributeValues.put(folderID, l) != null) {
            LogService.log(LogService.DEBUG, "StructureStylesheetUserPreferences::addFolder() : Readding an existing folder (folderID=\"" + folderID + "\"). All values will be set to default.");
        }
    }

    public void removeFolder(String folderID) {
        if (this.folderAttributeValues.remove(folderID) == null) {
            LogService.log(LogService.ERROR, "StructureStylesheetUserPreferences::removeFolder() : Attempting to remove an non-existing folder (folderID=\"" + folderID + "\").");
        }
    }

    public Enumeration getFolders() {
        return this.folderAttributeValues.keys();
    }

    public boolean hasFolder(String folderID) {
        return this.folderAttributeValues.containsKey(folderID);
    }

    private ArrayList createFolder(String folderID) {
        ArrayList l = new ArrayList(this.defaultFolderAttributeValues.size());
        this.folderAttributeValues.put(folderID, l);
        return l;
    }

    private Hashtable copyFolderAttributeNames() {
        return this.folderAttributeNumbers;
    }

    public String getCacheKey() {
        StringBuffer sbKey = new StringBuffer();
        Enumeration e = this.folderAttributeValues.keys();
        while (e.hasMoreElements()) {
            String folderId = (String)e.nextElement();
            sbKey.append("(folder:").append(folderId).append(':');
            List l = (List)this.folderAttributeValues.get(folderId);
            for (int i = 0; i < l.size(); ++i) {
                String value = (String)l.get(i);
                if (value == null) {
                    value = (String)this.defaultFolderAttributeValues.get(i);
                }
                sbKey.append(value).append(",");
            }
            sbKey.append(")");
        }
        return super.getCacheKey().concat(sbKey.toString());
    }
}

