/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionBindingEvent;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.IUserLayoutStore;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.PortalException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.StructureStylesheetDescription;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.UserLayoutStoreFactory;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.jndi.JNDIManager;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.TransientUserLayoutManagerWrapper;
import org.jasig.portal.layout.UserLayoutManagerFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.PropsMatcher;

public class UserPreferencesManager
implements IUserPreferencesManager {
    static PropsMatcher uaMatcher;
    private IUserLayoutManager ulm;
    private UserPreferences complete_up;
    private ThemeStylesheetDescription tsd;
    private StructureStylesheetDescription ssd;
    private boolean unmapped_user_agent;
    IPerson m_person;
    IUserLayoutStore ulsdb;
    private static final boolean saveUserPreferencesAtLogout;
    static /* synthetic */ Class class$org$jasig$portal$UserPreferencesManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserPreferencesManager(HttpServletRequest req, IPerson person) throws PortalException {
        block19: {
            this.unmapped_user_agent = false;
            this.ulsdb = null;
            this.ulm = null;
            try {
                UserProfile upl;
                this.m_person = person;
                this.ulsdb = UserLayoutStoreFactory.getUserLayoutStoreImpl();
                String userAgent = req.getHeader("User-Agent");
                if (userAgent == null || userAgent.equals("")) {
                    userAgent = "null";
                }
                if ((upl = this.ulsdb.getUserProfile(this.m_person, userAgent)) == null) {
                    upl = this.ulsdb.getSystemProfile(userAgent);
                }
                if (upl == null) {
                    String profileId;
                    block18: {
                        if (uaMatcher == null) {
                            URL url = null;
                            try {
                                url = this.getClass().getResource("/properties/browser.mappings");
                                if (url == null) break block18;
                                InputStream in = url.openStream();
                                try {
                                    uaMatcher = new PropsMatcher(in);
                                }
                                finally {
                                    in.close();
                                }
                            }
                            catch (IOException ioe) {
                                LogService.log(LogService.ERROR, "UserPreferencesManager::UserPreferencesManager() : Exception occurred while loading browser mapping file: " + url + ". " + ioe);
                            }
                        }
                    }
                    if (uaMatcher != null && (profileId = uaMatcher.match(userAgent)) != null) {
                        upl = this.ulsdb.getSystemProfileById(Integer.parseInt(profileId));
                    }
                }
                if (upl != null) {
                    this.ulm = UserLayoutManagerFactory.getUserLayoutManager(this.m_person, upl);
                    try {
                        this.complete_up = this.ulsdb.getUserPreferences(this.m_person, upl);
                    }
                    catch (Exception e) {
                        LogService.log(LogService.ERROR, "UserPreferencesManager(): caught an exception trying to retreive user preferences for user=\"" + this.m_person.getID() + "\", profile=\"" + upl.getProfileName() + "\".", e);
                        this.complete_up = new UserPreferences(upl);
                    }
                    try {
                        JNDIManager.initializeSessionContext(req.getSession(), Integer.toString(this.m_person.getID()), Integer.toString(upl.getLayoutId()), this.ulm.getUserLayoutDOM());
                    }
                    catch (PortalException ipe) {
                        LogService.log(LogService.ERROR, "UserPreferencesManager(): Could not properly initialize user context", ipe);
                    }
                    break block19;
                }
                this.unmapped_user_agent = true;
                LogService.log(LogService.DEBUG, "UserPreferencesManager::UserPreferencesManager() : unable to find a profile for user \"" + this.m_person.getID() + "\" and userAgent=\"" + userAgent + "\".");
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserPreferencesManager(HttpServletRequest req, IPerson person, LocaleManager localeManager) throws PortalException {
        block19: {
            this.unmapped_user_agent = false;
            this.ulsdb = null;
            this.ulm = null;
            try {
                this.m_person = person;
                this.ulsdb = UserLayoutStoreFactory.getUserLayoutStoreImpl();
                String userAgent = req.getHeader("User-Agent");
                UserProfile upl = this.ulsdb.getUserProfile(this.m_person, userAgent);
                if (upl == null) {
                    upl = this.ulsdb.getSystemProfile(userAgent);
                }
                if (upl == null) {
                    String profileId;
                    block18: {
                        if (uaMatcher == null) {
                            URL url = null;
                            try {
                                url = this.getClass().getResource("/properties/browser.mappings");
                                if (url == null) break block18;
                                InputStream in = url.openStream();
                                try {
                                    uaMatcher = new PropsMatcher(in);
                                }
                                finally {
                                    in.close();
                                }
                            }
                            catch (IOException ioe) {
                                LogService.log(LogService.ERROR, "UserPreferencesManager::UserPreferencesManager() : Exception occurred while loading browser mapping file: " + url + ". " + ioe);
                            }
                        }
                    }
                    if (uaMatcher != null && (profileId = uaMatcher.match(userAgent)) != null) {
                        upl = this.ulsdb.getSystemProfileById(Integer.parseInt(profileId));
                    }
                }
                if (upl != null) {
                    if (localeManager.isLocaleAware()) {
                        upl.setLocaleManager(localeManager);
                    }
                    this.ulm = UserLayoutManagerFactory.getUserLayoutManager(this.m_person, upl);
                    try {
                        this.complete_up = this.ulsdb.getUserPreferences(this.m_person, upl);
                    }
                    catch (Exception e) {
                        LogService.log(LogService.ERROR, "UserPreferencesManager(): caught an exception trying to retreive user preferences for user=\"" + this.m_person.getID() + "\", profile=\"" + upl.getProfileName() + "\".", e);
                        this.complete_up = new UserPreferences(upl);
                    }
                    try {
                        JNDIManager.initializeSessionContext(req.getSession(), Integer.toString(this.m_person.getID()), Integer.toString(upl.getLayoutId()), this.ulm.getUserLayoutDOM());
                    }
                    catch (PortalException ipe) {
                        LogService.log(LogService.ERROR, "UserPreferencesManager(): Could not properly initialize user context", ipe);
                    }
                    break block19;
                }
                this.unmapped_user_agent = true;
                LogService.log(LogService.DEBUG, "UserPreferencesManager::UserPreferencesManager() : unable to find a profile for user \"" + this.m_person.getID() + "\" and userAgent=\"" + userAgent + "\".");
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
        }
    }

    public UserPreferencesManager(IPerson person) {
        this.unmapped_user_agent = false;
        this.ulsdb = null;
        this.m_person = person;
    }

    public void processUserPreferencesParameters(HttpServletRequest req) {
        String[] tcattrs;
        String[] scattrs;
        String[] sfattrs;
        String[] tparams;
        String[] sparams;
        String localesString;
        String fname;
        String root;
        String saveWhat = req.getParameter("uP_save");
        if (saveWhat != null) {
            try {
                if (saveWhat.equals("preferences")) {
                    this.ulsdb.putUserPreferences(this.m_person, this.complete_up);
                } else if (saveWhat.equals("layout")) {
                    this.ulm.saveUserLayout();
                } else if (saveWhat.equals("all")) {
                    this.ulsdb.putUserPreferences(this.m_person, this.complete_up);
                    this.ulm.saveUserLayout();
                }
                LogService.log(LogService.DEBUG, "UserPreferencesManager::processUserPreferencesParameters() : persisted " + saveWhat + " changes.");
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, "UserPreferencesManager::processUserPreferencesParameters() : unable to persist " + saveWhat + " changes. " + e);
            }
        }
        if ((root = req.getParameter("uP_root")) != null) {
            if (root.equals("me")) {
                UPFileSpec upfs = new UPFileSpec(req);
                root = upfs.getTargetNodeId();
            }
            if (root != null) {
                this.complete_up.getStructureStylesheetUserPreferences().putParameterValue("userLayoutRoot", root);
            } else {
                LogService.log(LogService.ERROR, "UserPreferencesManager::processUserPreferencesParameters() : unable to extract channel ID. servletPath=\"" + req.getServletPath() + "\".");
            }
        }
        if ((fname = req.getParameter("uP_fname")) != null) {
            String subId = null;
            try {
                subId = this.ulm.getSubscribeId(fname);
            }
            catch (PortalException pe) {
                LogService.log(LogService.ERROR, "UserPreferencesManager::processUserPreferencesParameters(): Unable to get subscribe ID for fname=" + fname);
            }
            if (this.ulm instanceof TransientUserLayoutManagerWrapper) {
                TransientUserLayoutManagerWrapper iulm = (TransientUserLayoutManagerWrapper)this.ulm;
                iulm.setFocusedId(subId);
            }
            this.complete_up.getStructureStylesheetUserPreferences().putParameterValue("userLayoutRoot", subId);
            LogService.log(LogService.DEBUG, "UserPreferencesManager::processUserPreferencesParameters() : setting sfname \" userLayoutRoot\"=\"" + subId + "\".");
        }
        if ((localesString = req.getParameter("uP_locales")) != null) {
            LocaleManager localeManager = this.complete_up.getProfile().getLocaleManager();
            localeManager.setSessionLocales(LocaleManager.parseLocales(localesString));
        }
        if ((sparams = req.getParameterValues("uP_sparam")) != null) {
            for (int i = 0; i < sparams.length; ++i) {
                String pValue = req.getParameter(sparams[i]);
                this.complete_up.getStructureStylesheetUserPreferences().putParameterValue(sparams[i], pValue);
                LogService.log(LogService.DEBUG, "UserPreferencesManager::processUserPreferencesParameters() : setting sparam \"" + sparams[i] + "\"=\"" + pValue + "\".");
            }
        }
        if ((tparams = req.getParameterValues("uP_tparam")) != null) {
            for (int i = 0; i < tparams.length; ++i) {
                String pValue = req.getParameter(tparams[i]);
                this.complete_up.getThemeStylesheetUserPreferences().putParameterValue(tparams[i], pValue);
                LogService.log(LogService.DEBUG, "UserPreferencesManager::processUserPreferencesParameters() : setting tparam \"" + tparams[i] + "\"=\"" + pValue + "\".");
            }
        }
        if ((sfattrs = req.getParameterValues("uP_sfattr")) != null) {
            for (int i = 0; i < sfattrs.length; ++i) {
                String aName = sfattrs[i];
                String[] aNode = req.getParameterValues(aName + "_folderId");
                if (aNode == null || aNode.length <= 0) continue;
                for (int j = 0; j < aNode.length; ++j) {
                    String aValue = req.getParameter(aName + "_" + aNode[j] + "_value");
                    this.complete_up.getStructureStylesheetUserPreferences().setFolderAttributeValue(aNode[j], aName, aValue);
                    LogService.log(LogService.DEBUG, "UserPreferencesManager::processUserPreferencesParameters() : setting sfattr \"" + aName + "\" of \"" + aNode[j] + "\" to \"" + aValue + "\".");
                }
            }
        }
        if ((scattrs = req.getParameterValues("uP_scattr")) != null) {
            for (int i = 0; i < scattrs.length; ++i) {
                String aName = scattrs[i];
                String[] aNode = req.getParameterValues(aName + "_channelId");
                if (aNode == null || aNode.length <= 0) continue;
                for (int j = 0; j < aNode.length; ++j) {
                    String aValue = req.getParameter(aName + "_" + aNode[j] + "_value");
                    this.complete_up.getStructureStylesheetUserPreferences().setChannelAttributeValue(aNode[j], aName, aValue);
                    LogService.log(LogService.DEBUG, "UserPreferencesManager::processUserPreferencesParameters() : setting scattr \"" + aName + "\" of \"" + aNode[j] + "\" to \"" + aValue + "\".");
                }
            }
        }
        if ((tcattrs = req.getParameterValues("uP_tcattr")) != null) {
            for (int i = 0; i < tcattrs.length; ++i) {
                String aName = tcattrs[i];
                String[] aNode = req.getParameterValues(aName + "_channelId");
                if (aNode == null || aNode.length <= 0) continue;
                for (int j = 0; j < aNode.length; ++j) {
                    String aValue = req.getParameter(aName + "_" + aNode[j] + "_value");
                    this.complete_up.getThemeStylesheetUserPreferences().setChannelAttributeValue(aNode[j], aName, aValue);
                    LogService.log(LogService.DEBUG, "UserPreferencesManager::processUserPreferencesParameters() : setting tcattr \"" + aName + "\" of \"" + aNode[j] + "\" to \"" + aValue + "\".");
                }
            }
        }
    }

    public IPerson getPerson() {
        return this.m_person;
    }

    protected String getChannelPublishId(String channelSubscribeId) throws PortalException {
        IUserLayoutChannelDescription channel = (IUserLayoutChannelDescription)this.getUserLayoutManager().getNode(channelSubscribeId);
        if (channel != null) {
            return channel.getChannelPublishId();
        }
        return null;
    }

    public boolean isUserAgentUnmapped() {
        return this.unmapped_user_agent;
    }

    public void setNewUserLayoutAndUserPreferences(IUserLayoutManager newUlm, UserPreferences newPreferences) throws PortalException {
        try {
            if (newPreferences != null) {
                if (this.complete_up.getProfile().getProfileId() != newPreferences.getProfile().getProfileId() || this.complete_up.getProfile().isSystemProfile() != newPreferences.getProfile().isSystemProfile()) {
                    this.ulm = newUlm != null && newUlm.getLayoutId() == newPreferences.getProfile().getLayoutId() ? newUlm : UserLayoutManagerFactory.getUserLayoutManager(this.m_person, newPreferences.getProfile());
                }
                this.ulsdb.putUserPreferences(this.m_person, newPreferences);
                this.complete_up = newPreferences;
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
            throw new GeneralRenderingException(e.getMessage());
        }
    }

    public IUserLayoutManager getUserLayoutManager() {
        return this.ulm;
    }

    public void finishedSession(HttpSessionBindingEvent bindingEvent) {
        try {
            if (saveUserPreferencesAtLogout) {
                this.ulsdb.putUserPreferences(this.m_person, this.complete_up);
            }
            this.ulm.saveUserLayout();
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "UserPreferencesManager::finishedSession() : unable to persist layout upon session termination !", e);
        }
    }

    public UserPreferences getUserPreferencesCopy() {
        return new UserPreferences(this.getUserPreferences());
    }

    public UserProfile getCurrentProfile() {
        return this.getUserPreferences().getProfile();
    }

    public ThemeStylesheetDescription getThemeStylesheetDescription() throws Exception {
        if (this.tsd == null) {
            this.tsd = this.ulsdb.getThemeStylesheetDescription(this.getCurrentProfile().getThemeStylesheetId());
        }
        return this.tsd;
    }

    public StructureStylesheetDescription getStructureStylesheetDescription() throws Exception {
        if (this.ssd == null) {
            this.ssd = this.ulsdb.getStructureStylesheetDescription(this.getCurrentProfile().getStructureStylesheetId());
        }
        return this.ssd;
    }

    public UserPreferences getUserPreferences() {
        return this.complete_up;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        saveUserPreferencesAtLogout = PropertiesManager.getPropertyAsBoolean((class$org$jasig$portal$UserPreferencesManager == null ? (class$org$jasig$portal$UserPreferencesManager = UserPreferencesManager.class$("org.jasig.portal.UserPreferencesManager")) : class$org$jasig$portal$UserPreferencesManager).getName() + ".save_UserPreferences_at_logout");
    }
}

