/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.car.Path;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.SAX2BufferImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class DescriptorHandler
extends DefaultHandler {
    public static final String RCS_ID = "@(#) $Header: /home/cvs/jasig/portal/source/org/jasig/portal/car/DescriptorHandler.java,v 1.4 2003/11/04 01:03:49 wgthom Exp $";
    private Properties workers = null;
    private ContentHandler services = null;
    private JarFile jarFile = null;
    private PathRouter currentRouter = null;
    private Path currentPath = null;
    private PathRouter[] routers = null;
    public static final Path WORKERS = Path.fromXML("<component><worker>");
    public static final Path SERVICES = Path.fromXML("<component><service>");
    public static final Path EXTENSIONS = Path.fromXML("<component><ext>");
    private static final PathRouter[] ROUTER_ARRAY = new PathRouter[0];

    public DescriptorHandler(JarFile jarFile) {
        this(jarFile, null);
    }

    public DescriptorHandler(JarFile jarFile, Path[] pathsToLoad) {
        this.jarFile = jarFile;
        this.currentPath = new Path();
        if (pathsToLoad != null) {
            Vector<PathRouter> routerSet = new Vector<PathRouter>();
            for (int i = 0; i < pathsToLoad.length; ++i) {
                if (pathsToLoad[i] == WORKERS) {
                    this.workers = new Properties();
                    WorkerHandler handler = new WorkerHandler(this.workers);
                    routerSet.add(new PathRouter(WORKERS, handler));
                    continue;
                }
                if (pathsToLoad[i] == SERVICES) {
                    this.services = new SAX2BufferImpl();
                    routerSet.add(new PathRouter(SERVICES, this.services));
                    continue;
                }
                if (pathsToLoad[i] != EXTENSIONS) continue;
                ExtensionHandler ext = new ExtensionHandler();
                routerSet.add(new PathRouter(EXTENSIONS, ext));
            }
            this.routers = routerSet.toArray(ROUTER_ARRAY);
            this.parseDescriptor();
        }
    }

    private static void triggerExtensionProcessing() {
        new Thread(){

            public void run() {
                this.setName("CAR Descriptor Extensions Processor");
                CarResources cRes = null;
                ClassLoader cLoader = null;
                while (cRes == null || cLoader == null) {
                    try {
                        Thread.sleep(1000L);
                        if (cRes == null) {
                            cRes = CarResources.getInstance();
                        }
                        if (cRes == null) continue;
                        cLoader = cRes.getClassLoader();
                    }
                    catch (InterruptedException ie) {}
                }
                Path[] paths = new Path[]{EXTENSIONS};
                Enumeration jars = cRes.jarsWithDescriptors.elements();
                while (jars.hasMoreElements()) {
                    new DescriptorHandler((JarFile)jars.nextElement(), paths);
                }
            }
        }.start();
    }

    public synchronized void getWorkers(Properties p) {
        if (this.workers == null) {
            WorkerHandler handler = new WorkerHandler(p);
            this.routers = new PathRouter[]{new PathRouter(WORKERS, handler)};
            this.parseDescriptor();
            return;
        }
        Enumeration<?> e = this.workers.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            p.put(name, this.workers.getProperty(name));
        }
    }

    public synchronized void getServices(ContentHandler c) throws SAXException {
        if (this.services == null) {
            this.routers = new PathRouter[]{new PathRouter(SERVICES, c)};
            this.parseDescriptor();
            return;
        }
        SAX2BufferImpl buffer = (SAX2BufferImpl)this.services;
        buffer.stopBuffering();
        buffer.outputBuffer(c);
    }

    private void parseDescriptor() {
        ZipEntry entry = this.jarFile.getEntry("META-INF/comp.xml");
        SAXParser parser = null;
        InputStream is = null;
        if (entry == null) {
            return;
        }
        try {
            is = this.jarFile.getInputStream(entry);
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ZipException ze) {
            LogService.log(LogService.DEBUG, "The zip entry META-INF/comp.xml in " + this.jarFile.getName() + " has an invalid format. Details: " + ze);
        }
        catch (IOException ioe) {
            LogService.log(LogService.DEBUG, "Unable to read entry META-INF/comp.xml in " + this.jarFile.getName() + ". Details: " + ioe);
        }
        catch (SecurityException se) {
            LogService.log(LogService.DEBUG, "Unable to read entry META-INF/comp.xml in " + this.jarFile.getName() + " because some entries are incorrectly signed. " + "Details: " + se);
        }
        catch (FactoryConfigurationError fce) {
            LogService.log(LogService.DEBUG, "Unable to read entry META-INF/comp.xml in " + this.jarFile.getName() + " because a parser factory could not be created." + " Details: " + fce);
        }
        catch (ParserConfigurationException pce) {
            LogService.log(LogService.DEBUG, "Unable to read entry META-INF/comp.xml in " + this.jarFile.getName() + " because a parser could not be created." + " Details: " + pce);
        }
        catch (SAXException sxe) {
            LogService.log(LogService.DEBUG, "Unable to read entry META-INF/comp.xml in " + this.jarFile.getName() + " because a parser could not be created." + " Details: " + sxe);
        }
        try {
            parser.parse(is, (DefaultHandler)this);
        }
        catch (RuntimeException re) {
            LogService.log(LogService.DEBUG, "Unable to completely parse entry META-INF/comp.xml in " + this.jarFile.getName() + " because a fatal parser error occurred. " + "Details: " + re.getMessage());
        }
        catch (IOException ioe) {
            LogService.log(LogService.DEBUG, "Unable to completely parse entry META-INF/comp.xml in " + this.jarFile.getName() + ". Details: " + ioe);
        }
        catch (SAXException sxe) {
            LogService.log(LogService.DEBUG, "Unable to completely parse entry META-INF/comp.xml in " + this.jarFile.getName() + ". Details: " + sxe);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        LogService.log(LogService.DEBUG, "A non-fatal parsing error occurred while parsing META-INF/comp.xml in " + this.jarFile.getName() + ". Details: " + exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw new RuntimeException(exception.toString());
    }

    public void warning(SAXParseException exception) throws SAXException {
        LogService.log(LogService.DEBUG, "A parsing warning occurred while parsing META-INF/comp.xml in " + this.jarFile.getName() + ". Details: " + exception);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.currentPath.append(qName);
        if (this.currentRouter == null) {
            for (int i = 0; this.currentRouter == null && i < this.routers.length; ++i) {
                if (!this.routers[i].looksFor(this.currentPath)) continue;
                this.currentRouter = this.routers[i];
            }
        }
        if (this.currentRouter != null) {
            this.currentRouter.handler.startElement(namespaceURI, localName, qName, atts);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.currentRouter != null) {
            this.currentRouter.handler.endElement(namespaceURI, localName, qName);
            if (this.currentRouter.looksFor(this.currentPath)) {
                this.currentRouter = null;
            }
        }
        this.currentPath.removeLast();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentRouter != null) {
            this.currentRouter.handler.characters(ch, start, length);
        }
    }

    static {
        DescriptorHandler.triggerExtensionProcessing();
    }

    private class PathRouter {
        Path pathLookedFor = null;
        ContentHandler handler = null;

        PathRouter(Path p, ContentHandler handler) {
            this.pathLookedFor = p;
            this.handler = handler;
        }

        ContentHandler handler() {
            return this.handler;
        }

        boolean looksFor(Path aPath) {
            return this.pathLookedFor.equals(aPath);
        }
    }

    private class ExtensionHandler
    extends DefaultHandler {
        ContentHandler extHandler = null;

        private ExtensionHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.extHandler != null) {
                this.extHandler.characters(ch, start, length);
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.extHandler != null) {
                this.extHandler.startElement(namespaceURI, localName, qName, atts);
            }
            if (qName.equals("ext") && DescriptorHandler.this.currentPath.equals(EXTENSIONS)) {
                this.extHandler = null;
                String handlerClass = atts.getValue("contentHandler");
                if (handlerClass == null) {
                    LogService.log(LogService.ERROR, "Ignoring invalid extension while processing deployment descriptor for " + DescriptorHandler.this.jarFile.getName() + ". Attribute 'contentHandler' must be " + "specified.");
                    return;
                }
                Class<?> c = null;
                Object obj = null;
                try {
                    CarResources cRes = CarResources.getInstance();
                    ClassLoader cl = cRes.getClassLoader();
                    c = cl.loadClass(handlerClass);
                }
                catch (ClassNotFoundException clfe) {
                    LogService.log(LogService.ERROR, "Specified contentHandler class " + handlerClass + " not found. Ignoring extension block " + "in deployment descriptor of " + DescriptorHandler.this.jarFile.getName() + ".");
                    return;
                }
                try {
                    obj = c.newInstance();
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, "Unable to create specified contentHandler class " + handlerClass + " for extension block" + " in deployment descriptor of " + DescriptorHandler.this.jarFile.getName() + ". Ignoring extension. Details: " + e);
                    return;
                }
                try {
                    this.extHandler = obj;
                }
                catch (ClassCastException cce) {
                    LogService.log(LogService.ERROR, "Specified contentHandler class " + handlerClass + " for extension in deployment " + "descriptor of " + DescriptorHandler.this.jarFile.getName() + " does not implement ContentHandler. " + "Ignoring extension.");
                    return;
                }
                this.extHandler.startDocument();
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (qName.equals("ext") && DescriptorHandler.this.currentPath.equals(EXTENSIONS)) {
                if (this.extHandler != null) {
                    this.extHandler.endDocument();
                }
                this.extHandler = null;
            }
            if (this.extHandler != null) {
                this.extHandler.endElement(namespaceURI, localName, qName);
            }
        }
    }

    private class WorkerHandler
    extends DefaultHandler {
        private Properties workerProps = null;

        WorkerHandler(Properties p) {
            this.workerProps = p;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (!qName.equals("worker")) {
                return;
            }
            String workerClass = atts.getValue("class");
            if (workerClass == null) {
                return;
            }
            this.workerProps.put(workerClass.replace('.', '_'), workerClass);
        }
    }
}

