/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.IMultithreadedCacheable;
import org.jasig.portal.IMultithreadedChannel;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.LocalConnectionContext;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.DTDResolver;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;

public class CGenericXSLT
implements IMultithreadedChannel,
IMultithreadedCacheable {
    Map stateTable = Collections.synchronizedMap(new HashMap());
    static final String systemCacheId = "org.jasig.portal.channels.CGenericXSLT";
    static /* synthetic */ Class class$org$jasig$portal$channels$CGenericXSLT;

    public void setStaticData(ChannelStaticData sd, String uid) throws ResourceMissingException {
        String connContext;
        CState state = new CState();
        state.xmlUri = sd.getParameter("xmlUri");
        state.sslUri = sd.getParameter("sslUri");
        state.xslTitle = sd.getParameter("xslTitle");
        state.xslUri = sd.getParameter("xslUri");
        String cacheTimeout = sd.getParameter("cacheTimeout");
        if (cacheTimeout != null) {
            state.cacheTimeout = Long.parseLong(cacheTimeout);
        }
        if ((connContext = sd.getParameter("upc_localConnContext")) != null) {
            try {
                state.localConnContext = (LocalConnectionContext)Class.forName(connContext).newInstance();
                state.localConnContext.init(sd);
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, "CGenericXSLT: Cannot initialize ILocalConnectionContext: " + e);
            }
        }
        this.stateTable.put(uid, state);
    }

    public void setRuntimeData(ChannelRuntimeData rd, String uid) {
        CState state = (CState)this.stateTable.get(uid);
        if (state == null) {
            LogService.log(LogService.ERROR, "CGenericXSLT:setRuntimeData() : attempting to access a non-established channel! setStaticData() has never been called on the uid=\"" + uid + "\"");
        } else {
            String xslUri;
            String xslTitle;
            String sslUri;
            state.runtimeData = rd;
            String xmlUri = rd.getParameter("xmlUri");
            if (xmlUri != null) {
                state.xmlUri = xmlUri;
            }
            if ((sslUri = rd.getParameter("sslUri")) != null) {
                state.sslUri = sslUri;
            }
            if ((xslTitle = rd.getParameter("xslTitle")) != null) {
                state.xslTitle = xslTitle;
            }
            if ((xslUri = rd.getParameter("xslUri")) != null) {
                state.xslUri = xslUri;
            }
            Enumeration enumeration = rd.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String n = (String)enumeration.nextElement();
                if (rd.getParameter(n) == null) continue;
                state.params.put(n, rd.getParameter(n));
            }
        }
    }

    public void receiveEvent(PortalEvent ev, String uid) {
        if (ev.getEventNumber() == 1) {
            this.stateTable.remove(uid);
        }
    }

    public ChannelRuntimeProperties getRuntimeProperties(String uid) {
        ChannelRuntimeProperties rp = new ChannelRuntimeProperties();
        if (this.stateTable.get(uid) == null) {
            rp.setWillRender(false);
            LogService.log(LogService.ERROR, "CGenericXSLT:getRuntimeProperties() : attempting to access a non-established channel! setStaticData() has never been called on the uid=\"" + uid + "\"");
        }
        return rp;
    }

    public void renderXML(ContentHandler out, String uid) throws PortalException {
        CState state = (CState)this.stateTable.get(uid);
        if (state == null) {
            LogService.log(LogService.ERROR, "CGenericXSLT:renderXML() : attempting to access a non-established channel! setStaticData() has never been called on the uid=\"" + uid + "\"");
        } else {
            Document xmlDoc;
            LogService.log(LogService.DEBUG, "CGenericXSLT::renderXML() : state = " + state.toString());
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                docBuilderFactory.setNamespaceAware(true);
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                DTDResolver dtdResolver = new DTDResolver();
                docBuilder.setEntityResolver(dtdResolver);
                URL url = state.localConnContext != null ? ResourceLoader.getResourceAsURL(this.getClass(), state.localConnContext.getDescriptor(state.xmlUri, state.runtimeData)) : ResourceLoader.getResourceAsURL(this.getClass(), state.xmlUri);
                URLConnection urlConnect = url.openConnection();
                if (state.localConnContext != null) {
                    try {
                        state.localConnContext.sendLocalData(urlConnect, state.runtimeData);
                    }
                    catch (Exception e) {
                        LogService.log(LogService.ERROR, "CGenericXSLT: Unable to send data through " + state.runtimeData.getParameter("upc_localConnContext") + ": " + e.getMessage());
                    }
                }
                xmlDoc = docBuilder.parse(urlConnect.getInputStream());
            }
            catch (IOException ioe) {
                throw new ResourceMissingException(state.xmlUri, "", ioe.getMessage());
            }
            catch (Exception e) {
                throw new GeneralRenderingException("Problem parsing " + state.xmlUri + ": " + e);
            }
            state.runtimeData.put("baseActionURL", state.runtimeData.getBaseActionURL());
            state.runtimeData.put("isRenderingAsRoot", String.valueOf(state.runtimeData.isRenderingAsRoot()));
            if (state.params != null) {
                Iterator it = state.params.keySet().iterator();
                while (it.hasNext()) {
                    String n = (String)it.next();
                    if (state.params.get(n) == null) continue;
                    state.runtimeData.put(n, state.params.get(n));
                }
            }
            XSLT xslt = XSLT.getTransformer(this);
            xslt.setXML(xmlDoc);
            if (state.xslUri != null) {
                xslt.setXSL(state.xslUri);
            } else {
                xslt.setXSL(state.sslUri, state.xslTitle, state.runtimeData.getBrowserInfo());
            }
            xslt.setTarget(out);
            xslt.setStylesheetParameters(state.runtimeData);
            xslt.transform();
        }
    }

    public ChannelCacheKey generateKey(String uid) {
        CState state = (CState)this.stateTable.get(uid);
        if (state == null) {
            LogService.log(LogService.ERROR, "CGenericXSLT:generateKey() : attempting to access a non-established channel! setStaticData() has never been called on the uid=\"" + uid + "\"");
            return null;
        }
        ChannelCacheKey k = new ChannelCacheKey();
        k.setKey(this.getKey(state) + "," + uid);
        k.setKeyScope(1);
        k.setKeyValidity(new Long(System.currentTimeMillis()));
        return k;
    }

    public boolean isCacheValid(Object validity, String uid) {
        if (!(validity instanceof Long)) {
            return false;
        }
        CState state = (CState)this.stateTable.get(uid);
        if (state == null) {
            LogService.log(LogService.ERROR, "CGenericXSLT:isCacheValid() : attempting to access a non-established channel! setStaticData() has never been called on the uid=\"" + uid + "\"");
            return false;
        }
        return System.currentTimeMillis() - (Long)validity < state.cacheTimeout * 1000L;
    }

    private String getKey(CState state) {
        StringBuffer sbKey = new StringBuffer(1024);
        sbKey.append(systemCacheId).append(": ");
        sbKey.append("xmluri:").append(state.xmlUri).append(", ");
        sbKey.append("sslUri:").append(state.sslUri).append(", ");
        String xslUriForKey = state.xslUri;
        try {
            if (xslUriForKey == null) {
                String sslUri = ResourceLoader.getResourceAsURLString(class$org$jasig$portal$channels$CGenericXSLT == null ? (class$org$jasig$portal$channels$CGenericXSLT = CGenericXSLT.class$(systemCacheId)) : class$org$jasig$portal$channels$CGenericXSLT, state.sslUri);
                xslUriForKey = XSLT.getStylesheetURI(sslUri, state.runtimeData.getBrowserInfo());
            }
        }
        catch (Exception e) {
            xslUriForKey = "Not attainable: " + e;
        }
        sbKey.append("locales:").append(LocaleManager.stringValueOf(state.runtimeData.getLocales()));
        sbKey.append("xslUri:").append(xslUriForKey).append(", ");
        sbKey.append("cacheTimeout:").append(state.cacheTimeout).append(", ");
        sbKey.append("isRenderingAsRoot:").append(state.runtimeData.isRenderingAsRoot()).append(", ");
        if (state.localConnContext != null) {
            sbKey.append("descriptor:").append(state.localConnContext.getDescriptor(state.xmlUri, state.runtimeData)).append(", ");
        }
        sbKey.append("params:").append(state.params.toString());
        return sbKey.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CState {
        private String xmlUri = null;
        private String sslUri = null;
        private String xslTitle = null;
        private String xslUri = null;
        private Map params = new HashMap();
        private long cacheTimeout = PropertiesManager.getPropertyAsLong("org.jasig.portal.channels.CGenericXSLT.default_cache_timeout");
        private ChannelRuntimeData runtimeData = null;
        private LocalConnectionContext localConnContext = null;

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append("xmlUri = " + this.xmlUri + "\n");
            str.append("xslUri = " + this.xslUri + "\n");
            str.append("sslUri = " + this.sslUri + "\n");
            str.append("xslTitle = " + this.xslTitle + "\n");
            if (this.params != null) {
                str.append("params = " + this.params.toString() + "\n");
            }
            return str.toString();
        }
    }
}

