/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.IMultithreadedCacheable;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseMultithreadedChannel;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CImage
extends BaseMultithreadedChannel
implements IMultithreadedCacheable {
    private static final String sslLocation = "CImage/CImage.ssl";

    public void renderXML(ContentHandler out, String uid) throws PortalException {
        BaseMultithreadedChannel.ChannelState channelState = (BaseMultithreadedChannel.ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        String sImageUri = staticData.getParameter("img-uri");
        String sImageWidth = staticData.getParameter("img-width");
        String sImageHeight = staticData.getParameter("img-height");
        String sImageBorder = staticData.getParameter("img-border");
        String sImageLink = staticData.getParameter("img-link");
        String sCaption = staticData.getParameter("caption");
        String sSubCaption = staticData.getParameter("subcaption");
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            LogService.log(LogService.ERROR, pce);
            throw new GeneralRenderingException(pce.getMessage());
        }
        Element contentE = doc.createElement("content");
        Element imageE = doc.createElement("image");
        imageE.setAttribute("src", sImageUri);
        if (CImage.exists(sImageWidth)) {
            imageE.setAttribute("width", sImageWidth);
        }
        if (CImage.exists(sImageWidth)) {
            imageE.setAttribute("height", sImageHeight);
        }
        if (CImage.exists(sImageWidth)) {
            imageE.setAttribute("border", sImageBorder);
        }
        if (CImage.exists(sImageWidth)) {
            imageE.setAttribute("link", sImageLink);
        }
        contentE.appendChild(imageE);
        if (CImage.exists(sCaption)) {
            Element captionE = doc.createElement("caption");
            captionE.appendChild(doc.createTextNode(sCaption));
            contentE.appendChild(captionE);
        }
        if (CImage.exists(sSubCaption)) {
            Element subcaptionE = doc.createElement("subcaption");
            subcaptionE.appendChild(doc.createTextNode(sSubCaption));
            contentE.appendChild(subcaptionE);
        }
        doc.appendChild(contentE);
        XSLT xslt = XSLT.getTransformer(this, runtimeData.getLocales());
        xslt.setXML(doc);
        xslt.setXSL(sslLocation, runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.setStylesheetParameter("baseActionURL", runtimeData.getBaseActionURL());
        xslt.transform();
    }

    private static boolean exists(String s) {
        return s != null && s.length() > 0;
    }

    public ChannelCacheKey generateKey(String uid) {
        ChannelCacheKey key = new ChannelCacheKey();
        key.setKey(this.getKey(uid));
        key.setKeyScope(1);
        key.setKeyValidity(null);
        return key;
    }

    public boolean isCacheValid(Object validity, String uid) {
        return true;
    }

    private String getKey(String uid) {
        BaseMultithreadedChannel.ChannelState channelState = (BaseMultithreadedChannel.ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        StringBuffer sbKey = new StringBuffer(1024);
        sbKey.append("org.jasig.portal.channels.CImage").append(": ");
        sbKey.append("xslUri:");
        try {
            String sslUrl = ResourceLoader.getResourceAsURLString(this.getClass(), sslLocation);
            sbKey.append(XSLT.getStylesheetURI(sslUrl, runtimeData.getBrowserInfo())).append(", ");
        }
        catch (PortalException pe) {
            sbKey.append("Not available, ");
        }
        sbKey.append("staticData:").append(staticData.toString());
        sbKey.append("locales:").append(LocaleManager.stringValueOf(runtimeData.getLocales()));
        return sbKey.toString();
    }
}

