/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.IMultithreadedCacheable;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseMultithreadedChannel;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CInlineFrame
extends BaseMultithreadedChannel
implements IMultithreadedCacheable {
    private static final String sslLocation = "CInlineFrame/CInlineFrame.ssl";

    public void renderXML(ContentHandler out, String uid) throws PortalException {
        BaseMultithreadedChannel.ChannelState channelState = (BaseMultithreadedChannel.ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        String srcUrl = staticData.getParameter("url");
        String frameHeight = staticData.getParameter("height");
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            LogService.log(LogService.ERROR, pce);
            throw new GeneralRenderingException(pce.getMessage());
        }
        Element iframeE = doc.createElement("iframe");
        Element urlE = doc.createElement("url");
        urlE.appendChild(doc.createTextNode(srcUrl));
        iframeE.appendChild(urlE);
        Element heightE = doc.createElement("height");
        heightE.appendChild(doc.createTextNode(frameHeight));
        iframeE.appendChild(heightE);
        doc.appendChild(iframeE);
        XSLT xslt = XSLT.getTransformer(this, runtimeData.getLocales());
        xslt.setXML(doc);
        xslt.setXSL(sslLocation, this.getStylesheetTitle(runtimeData.getBrowserInfo().getUserAgent()), runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.transform();
    }

    private String getStylesheetTitle(String userAgent) {
        String ssTitle = "noIFrameSupport";
        if (userAgent.indexOf("MSIE 3") >= 0 || userAgent.indexOf("MSIE 4") >= 0 || userAgent.indexOf("MSIE 5") >= 0 || userAgent.indexOf("MSIE 6") >= 0 || userAgent.indexOf("Mozilla/5") >= 0 || userAgent.indexOf("Opera/6") >= 0) {
            ssTitle = "IFrameSupport";
        }
        return ssTitle;
    }

    public ChannelCacheKey generateKey(String uid) {
        ChannelCacheKey key = new ChannelCacheKey();
        key.setKey(this.getKey(uid));
        key.setKeyScope(1);
        key.setKeyValidity(null);
        return key;
    }

    public boolean isCacheValid(Object validity, String uid) {
        return true;
    }

    private String getKey(String uid) {
        BaseMultithreadedChannel.ChannelState channelState = (BaseMultithreadedChannel.ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        StringBuffer sbKey = new StringBuffer(1024);
        sbKey.append("org.jasig.portal.channels.CInlineFrame").append(": ");
        sbKey.append("xslUri:");
        try {
            String sslUrl = ResourceLoader.getResourceAsURLString(this.getClass(), sslLocation);
            String ssTitle = this.getStylesheetTitle(runtimeData.getBrowserInfo().getUserAgent());
            sbKey.append(XSLT.getStylesheetURI(sslUrl, ssTitle, runtimeData.getBrowserInfo())).append(", ");
        }
        catch (PortalException pe) {
            sbKey.append("Not available, ");
        }
        sbKey.append("staticData:").append(staticData.toString());
        sbKey.append("locales:").append(LocaleManager.stringValueOf(runtimeData.getLocales()));
        return sbKey.toString();
    }
}

