/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.IUserLayoutStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.StandaloneChannelRenderer;
import org.jasig.portal.UserLayoutStoreFactory;
import org.jasig.portal.UserProfile;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CSelectSystemProfile
extends StandaloneChannelRenderer {
    private static final String sslLocation = "CSelectSystemProfile/CSelectSystemProfile.ssl";
    IUserLayoutStore ulsdb = UserLayoutStoreFactory.getUserLayoutStoreImpl();
    private Hashtable systemProfileList;

    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        super.setRuntimeData(rd);
        String action = this.runtimeData.getParameter("action");
        if (action != null) {
            String profileId = this.runtimeData.getParameter("profileId");
            boolean systemProfile = false;
            if (profileId != null) {
                String profileType = this.runtimeData.getParameter("profileType");
                if (action.equals("map")) {
                    try {
                        this.ulsdb.setSystemBrowserMapping(this.runtimeData.getBrowserInfo().getUserAgent(), Integer.parseInt(profileId));
                    }
                    catch (Exception e) {
                        throw new PortalException(e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected Hashtable getSystemProfileList() throws PortalException {
        if (this.systemProfileList == null) {
            try {
                this.systemProfileList = this.ulsdb.getSystemProfileList();
            }
            catch (Exception e) {
                throw new PortalException(e.getMessage(), e);
            }
        }
        return this.systemProfileList;
    }

    public void renderXML(ContentHandler out) throws PortalException {
        Document doc = DocumentFactory.getNewDocument();
        Element edEl = doc.createElement("profiles");
        doc.appendChild(edEl);
        Element sEl = doc.createElement("system");
        Enumeration spe = this.getSystemProfileList().elements();
        while (spe.hasMoreElements()) {
            UserProfile p = (UserProfile)spe.nextElement();
            Element pEl = doc.createElement("profile");
            pEl.setAttribute("id", Integer.toString(p.getProfileId()));
            pEl.setAttribute("name", p.getProfileName());
            Element dEl = doc.createElement("description");
            dEl.appendChild(doc.createTextNode(p.getProfileDescription()));
            pEl.appendChild(dEl);
            sEl.appendChild(pEl);
        }
        edEl.appendChild(sEl);
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(doc);
        xslt.setXSL(sslLocation, this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
        xslt.transform();
    }
}

