/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager.commands;

import java.util.Iterator;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerXML;
import org.jasig.portal.channels.groupsmanager.Utility;
import org.jasig.portal.channels.groupsmanager.commands.GroupsManagerCommand;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeleteGroup
extends GroupsManagerCommand {
    public void execute(CGroupsManagerSessionData sessionData) throws Exception {
        ChannelRuntimeData runtimeData = sessionData.runtimeData;
        Utility.logMessage("DEBUG", "DeleteGroup::execute(): Start");
        Document model = this.getXmlDoc(sessionData);
        String delId = this.getCommandArg(runtimeData);
        Element delElem = GroupsManagerXML.getElementByTagNameAndId(model, "group", delId);
        Element pn = (Element)delElem.getParentNode();
        if (pn != null) {
            sessionData.highlightedGroupID = pn.getAttribute("id");
        }
        String delKey = delElem.getAttribute("key");
        String elemName = delElem.getAttribute("name");
        Utility.logMessage("DEBUG", "DeleteGroup::execute(): Group: " + elemName + "will be deleted");
        if (Utility.areEqual(delElem.getAttribute("searchResults"), "true")) {
            delElem.getParentNode().removeChild(delElem);
        } else {
            ILockableEntityGroup delGroup = sessionData.lockedGroup;
            if (delGroup == null) {
                String retMsg;
                sessionData.feedback = retMsg = "Unable to retrieve Group!";
                return;
            }
            Utility.logMessage("DEBUG", "DeleteGroup::execute(): About to delete group: " + elemName);
            this.deletePermissions(delGroup);
            delGroup.delete();
            Utility.logMessage("DEBUG", "DeleteGroup::execute(): About to delete xml nodes for group: " + elemName);
            Iterator deletedNodes = GroupsManagerXML.getNodesByTagNameAndKey(model, "group", delKey);
            IGroupMember parentEntGrp = null;
            String hasMbrs = "duh";
            while (deletedNodes.hasNext()) {
                Node deletedNode = (Node)deletedNodes.next();
                Node parentNode = deletedNode.getParentNode();
                String nodeKey = ((Element)parentNode).getAttribute("key");
                if (parentEntGrp == null || !parentEntGrp.getKey().equals(nodeKey)) {
                    if (!Utility.areEqual(nodeKey, "")) {
                        parentEntGrp = GroupsManagerXML.retrieveGroup(nodeKey);
                        hasMbrs = String.valueOf(parentEntGrp.hasMembers());
                        parentNode.removeChild(deletedNode);
                    } else {
                        parentNode.removeChild(deletedNode);
                        NodeList nl = parentNode.getChildNodes();
                        hasMbrs = nl.getLength() > 0 ? "true" : "false";
                    }
                }
                ((Element)parentNode).setAttribute("hasMembers", hasMbrs);
            }
            Node principalNode = model.getDocumentElement().getElementsByTagName("principal").item(0);
            NodeList permElems = model.getElementsByTagName("permission");
            for (int i = permElems.getLength() - 1; i > -1; --i) {
                Element permElem = (Element)permElems.item(i);
                if (!permElem.getAttribute("target").equals(delKey)) continue;
                principalNode.removeChild(permElem);
            }
            sessionData.mode = "browse";
        }
        Utility.logMessage("DEBUG", "DeleteGroup::execute(): Finished");
    }
}

