/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.iccdemo;

import java.util.Iterator;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.channels.iccdemo.HistoryRecord;
import org.jasig.portal.channels.iccdemo.ViewerURL;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CHistory
extends BaseChannel {
    private static final String sslLocation = "urlhistory.ssl";
    private static final String viewerFname = "/portal/iccdemo/viewer";
    private static final String urlselectorFname = "/portal/iccdemo/urlselector";
    private boolean passExternally = false;
    HistoryRecord records = new HistoryRecord();

    public void setStaticData(ChannelStaticData sd) throws PortalException {
        super.setStaticData(sd);
        Context globalObjContext = null;
        try {
            globalObjContext = (Context)this.staticData.getJNDIContext().lookup("/channel-obj");
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CHistory.getUserXML(): Could not find subcontext /channel-obj in JNDI");
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
        try {
            globalObjContext.bind(this.staticData.getChannelSubscribeId(), (Object)this.records);
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CHistory.getUserXML(): Could not bind channel object for channel id=" + this.staticData.getChannelSubscribeId());
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    private Document getUserXML() {
        Document doc = DocumentFactory.getNewDocument();
        Element urlselectorEl = doc.createElement("urlselector");
        String viewerId = this.getChannelId(viewerFname);
        if (viewerId == null) {
            Element warningEl = doc.createElement("warning");
            warningEl.appendChild(doc.createTextNode("Unable to find viewer channel (fname=/portal/iccdemo/viewer). Please subscribe to a viewer channel"));
            urlselectorEl.appendChild(warningEl);
        } else {
            Object bo = this.getBoundObject(viewerId);
            if (bo == null) {
                Element warningEl = doc.createElement("warning");
                warningEl.appendChild(doc.createTextNode("Viewer channel found, but no object was found bound in viewer's jndi context. Perhaps viewer should be moved to the same tab."));
                urlselectorEl.appendChild(warningEl);
            }
        }
        Iterator i = this.records.constIterator();
        while (i.hasNext()) {
            Element urlEl = doc.createElement("url");
            urlEl.appendChild(doc.createTextNode((String)i.next()));
            urlselectorEl.appendChild(urlEl);
        }
        doc.appendChild(urlselectorEl);
        return doc;
    }

    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        String pe;
        super.setRuntimeData(rd);
        String urlN = this.runtimeData.getParameter("urlN");
        if (urlN != null) {
            int recordNumber = Integer.parseInt(urlN);
            this.setViewerURL(this.records.get(recordNumber - 1));
        }
        if ((pe = this.runtimeData.getParameter("passExternally")) != null) {
            this.passExternally = !this.passExternally;
        }
    }

    private void setViewerURL(String url) {
        ViewerURL v;
        String viewerId = this.getChannelId(viewerFname);
        if (viewerId != null && (v = (ViewerURL)this.getBoundObject(viewerId)) != null) {
            v.setNewURL(url);
        }
    }

    private String getChannelId(String fname) {
        String id = null;
        Context globalIDContext = null;
        try {
            globalIDContext = (Context)this.staticData.getJNDIContext().lookup("/channel-ids");
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CURLSelector.getUserXML(): Could not find subcontext /channel-ids in JNDI");
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
        try {
            id = (String)globalIDContext.lookup(fname);
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CURLSelector.getUserXML(): Could not find channel ID for fname=" + fname);
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
        return id;
    }

    private Object getBoundObject(String channelSubscribeId) {
        Object o = null;
        Context globalObjContext = null;
        try {
            globalObjContext = (Context)this.staticData.getJNDIContext().lookup("/channel-obj");
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CURLSelector.getUserXML(): Could not find subcontext /channel-obj in JNDI");
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
        try {
            o = globalObjContext.lookup(channelSubscribeId);
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CURLSelector.getUserXML(): Could not find channel bound object for channel id=" + channelSubscribeId);
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
        return o;
    }

    public void renderXML(ContentHandler out) throws PortalException {
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(this.getUserXML());
        xslt.setXSL(sslLocation, this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
        if (this.passExternally) {
            xslt.setStylesheetParameter("passExternally", "true");
            xslt.setStylesheetParameter("CURLSelectId", this.getChannelId(urlselectorFname));
        } else {
            xslt.setStylesheetParameter("passExternally", "false");
        }
        xslt.transform();
    }
}

