/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.iccdemo;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICCRegistry;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.channels.iccdemo.HistoryRecord;
import org.jasig.portal.channels.iccdemo.ViewerURL;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CViewer
extends BaseChannel {
    private static final String sslLocation = "CInlineFrame/CInlineFrame.ssl";
    private static final String historyFname = "/portal/iccdemo/history";
    private String currentURL = "";

    public void setStaticData(ChannelStaticData sd) throws PortalException {
        super.setStaticData(sd);
        Context globalObjContext = null;
        try {
            globalObjContext = (Context)this.staticData.getJNDIContext().lookup("/channel-obj");
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CHistory.getUserXML(): Could not find subcontext /channel-obj in JNDI");
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
        try {
            globalObjContext.bind(this.staticData.getChannelSubscribeId(), (Object)new ViewerURL(this));
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CHistory.getUserXML(): Could not bind channel object for channel id=" + this.staticData.getChannelSubscribeId());
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
        this.registerHistory();
    }

    private void registerHistory() {
        ICCRegistry r = this.staticData.getICCRegistry();
        String historyId = this.getChannelId(historyFname);
        if (historyId != null) {
            r.addListenerChannel(historyId);
            r.addInstructorChannel(historyId);
        }
    }

    void changeURL(String newURL) {
        this.currentURL = newURL;
        this.addHistoryURL(newURL);
    }

    private void addHistoryURL(String url) {
        HistoryRecord hr;
        String historyId = this.getChannelId(historyFname);
        if (historyId != null && (hr = (HistoryRecord)this.getBoundObject(historyId)) != null) {
            hr.addHistoryRecord(url);
        }
    }

    public void renderXML(ContentHandler out) throws PortalException {
        String frameHeight = "600";
        Document doc = DocumentFactory.getNewDocument();
        Element iframeE = doc.createElement("iframe");
        String historyId = this.getChannelId(historyFname);
        if (historyId == null) {
            Element warningEl = doc.createElement("warning");
            warningEl.appendChild(doc.createTextNode("Unable to find history channel (fname=/portal/iccdemo/history). Please subscribe to a history channel"));
            iframeE.appendChild(warningEl);
        } else {
            Object bo = this.getBoundObject(historyId);
            if (bo == null) {
                Element warningEl = doc.createElement("warning");
                warningEl.appendChild(doc.createTextNode("History channel found, but no object was found bound in history's jndi context. Perhaps history should be moved to the same tab."));
                iframeE.appendChild(warningEl);
            }
        }
        Element urlE = doc.createElement("url");
        urlE.appendChild(doc.createTextNode(this.currentURL));
        iframeE.appendChild(urlE);
        Element heightE = doc.createElement("height");
        heightE.appendChild(doc.createTextNode(frameHeight));
        iframeE.appendChild(heightE);
        doc.appendChild(iframeE);
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(doc);
        xslt.setXSL(sslLocation, this.getStylesheetTitle(this.runtimeData.getBrowserInfo().getUserAgent()), this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.transform();
    }

    private String getStylesheetTitle(String userAgent) {
        String ssTitle = "noIFrameSupport";
        if (userAgent.indexOf("MSIE 3") >= 0 || userAgent.indexOf("MSIE 4") >= 0 || userAgent.indexOf("MSIE 5") >= 0 || userAgent.indexOf("MSIE 6") >= 0 || userAgent.indexOf("Mozilla/5") >= 0 || userAgent.indexOf("Opera/6") >= 0) {
            ssTitle = "IFrameSupport";
        }
        return ssTitle;
    }

    private String getChannelId(String fname) {
        String id = null;
        Context globalIDContext = null;
        try {
            globalIDContext = (Context)this.staticData.getJNDIContext().lookup("/channel-ids");
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CURLSelector.getUserXML(): Could not find subcontext /channel-ids in JNDI");
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
        try {
            id = (String)globalIDContext.lookup(fname);
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CURLSelector.getUserXML(): Could not find channel ID for fname=" + fname);
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
        return id;
    }

    private Object getBoundObject(String channelSubscribeId) {
        Object o = null;
        Context globalObjContext = null;
        try {
            globalObjContext = (Context)this.staticData.getJNDIContext().lookup("/channel-obj");
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CURLSelector.getUserXML(): Could not find subcontext /channel-obj in JNDI");
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
        try {
            o = globalObjContext.lookup(channelSubscribeId);
        }
        catch (NotContextException nce) {
            LogService.log(LogService.ERROR, "CURLSelector.getUserXML(): Could not find channel bound object for channel id=" + channelSubscribeId);
        }
        catch (NamingException e) {
            LogService.log(LogService.ERROR, e);
        }
        return o;
    }
}

