/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.remotechannel;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.xml.rpc.ServiceException;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IPrivileged;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.channels.remotechannel.RemoteChannel;
import org.jasig.portal.channels.remotechannel.RemoteChannelServiceLocator;
import org.jasig.portal.security.IOpaqueCredentials;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.provider.NotSoOpaqueCredentials;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CRemoteChannel
extends BaseChannel
implements IPrivileged,
ICacheable {
    protected RemoteChannel rc = null;
    protected String instanceId = null;
    protected static final String SSL_LOCATION = "CRemoteChannel.ssl";
    protected String baseUrl = null;
    protected String xslUriForKey = null;
    protected boolean receivedEvent = false;
    protected boolean focused = false;

    public void setStaticData(ChannelStaticData sd) throws PortalException {
        super.setStaticData(sd);
        String endpoint = this.staticData.getParameter("endpoint");
        String fname = this.staticData.getParameter("fname");
        RemoteChannelServiceLocator rcs = new RemoteChannelServiceLocator();
        try {
            this.rc = rcs.getRemoteChannel(new URL(endpoint));
        }
        catch (MalformedURLException mue) {
            throw new ResourceMissingException(endpoint, "Remote channel service endpoint", mue.getMessage());
        }
        catch (ServiceException se) {
            throw new PortalException((Exception)((Object)se));
        }
        try {
            this.authenticate();
            this.instanceId = this.rc.instantiateChannel(fname);
        }
        catch (RemoteException re) {
            throw new PortalException(re);
        }
    }

    public void receiveEvent(PortalEvent ev) {
        try {
            this.rc.receiveEvent(this.instanceId, ev);
            if (ev.getEventNumber() == 1) {
                this.rc.logout();
            } else if (ev.getEventNumber() == 2) {
                this.rc.freeChannel(this.instanceId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.receivedEvent = true;
    }

    public void renderXML(ContentHandler out) throws PortalException {
        Element channelE = null;
        try {
            channelE = this.rc.renderChannel(this.instanceId, this.runtimeData);
        }
        catch (RemoteException re) {
            throw new PortalException(re);
        }
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(channelE);
        xslt.setXSL(SSL_LOCATION, this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.transform();
    }

    protected void authenticate() throws RemoteException {
        String username = (String)this.staticData.getPerson().getAttribute("username");
        String password = null;
        ISecurityContext ic = this.staticData.getPerson().getSecurityContext();
        IOpaqueCredentials oc = ic.getOpaqueCredentials();
        if (oc instanceof NotSoOpaqueCredentials) {
            NotSoOpaqueCredentials nsoc = (NotSoOpaqueCredentials)oc;
            password = nsoc.getCredentials();
        }
        if (password == null) {
            Enumeration en = ic.getSubContexts();
            while (en.hasMoreElements()) {
                ISecurityContext sctx = (ISecurityContext)en.nextElement();
                IOpaqueCredentials soc = sctx.getOpaqueCredentials();
                if (!(soc instanceof NotSoOpaqueCredentials)) continue;
                NotSoOpaqueCredentials nsoc = (NotSoOpaqueCredentials)soc;
                password = nsoc.getCredentials();
            }
        }
        if (username != null && password != null) {
            this.rc.authenticate(username, password);
        }
    }

    public void setPortalControlStructures(PortalControlStructures pcs) throws PortalException {
        if (this.baseUrl == null) {
            HttpServletRequest request = pcs.getHttpServletRequest();
            String protocol = request.getProtocol();
            String protocolFixed = protocol.substring(0, protocol.indexOf("/")).toLowerCase();
            String serverName = request.getServerName();
            int serverPort = request.getServerPort();
            String contextPath = request.getContextPath();
            this.baseUrl = protocolFixed + "://" + serverName + ":" + serverPort + contextPath + "/";
        }
    }

    public ChannelCacheKey generateKey() {
        ChannelCacheKey cck = new ChannelCacheKey();
        StringBuffer sbKey = new StringBuffer(1024);
        if (this.staticData.getPerson().isGuest()) {
            cck.setKeyScope(1);
            sbKey.append("SYSTEM_");
        } else {
            cck.setKeyScope(0);
        }
        if (this.xslUriForKey == null) {
            try {
                String sslUri = ResourceLoader.getResourceAsURLString(this.getClass(), SSL_LOCATION);
                this.xslUriForKey = XSLT.getStylesheetURI(sslUri, this.runtimeData.getBrowserInfo());
            }
            catch (PortalException pe) {
                this.xslUriForKey = "Not attainable!";
            }
        }
        sbKey.append("xslUri: ").append(this.xslUriForKey);
        cck.setKey(sbKey.toString());
        return cck;
    }

    public boolean isCacheValid(Object validity) {
        boolean previouslyFocused = this.focused;
        this.focused = this.runtimeData.isRenderingAsRoot();
        boolean focusHasSwitched = this.focused != previouslyFocused;
        boolean cacheValid = !this.receivedEvent && this.runtimeData.size() == 0 && !focusHasSwitched;
        this.receivedEvent = false;
        return cacheValid;
    }
}

