/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.wsrp;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IMultithreadedCacheable;
import org.jasig.portal.IMultithreadedCharacterChannel;
import org.jasig.portal.IMultithreadedPrivileged;
import org.jasig.portal.MediaManager;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.wsrp.MarkupCache;
import org.jasig.portal.channels.wsrp.MarkupWrapper;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.SAXHelper;
import org.jasig.portal.wsrp.MarkupService;
import org.jasig.portal.wsrp.ServiceDescriptionService;
import org.jasig.portal.wsrp.types.CacheControl;
import org.jasig.portal.wsrp.types.ClientData;
import org.jasig.portal.wsrp.types.InteractionParams;
import org.jasig.portal.wsrp.types.MarkupContext;
import org.jasig.portal.wsrp.types.MarkupParams;
import org.jasig.portal.wsrp.types.MarkupResponse;
import org.jasig.portal.wsrp.types.NamedString;
import org.jasig.portal.wsrp.types.PersonName;
import org.jasig.portal.wsrp.types.PortletContext;
import org.jasig.portal.wsrp.types.RegistrationContext;
import org.jasig.portal.wsrp.types.RuntimeContext;
import org.jasig.portal.wsrp.types.ServiceDescription;
import org.jasig.portal.wsrp.types.SessionContext;
import org.jasig.portal.wsrp.types.StateChange;
import org.jasig.portal.wsrp.types.Templates;
import org.jasig.portal.wsrp.types.UploadContext;
import org.jasig.portal.wsrp.types.UserContext;
import org.jasig.portal.wsrp.types.UserProfile;
import org.xml.sax.ContentHandler;

public class CConsumer
implements IMultithreadedCharacterChannel,
IMultithreadedPrivileged,
IMultithreadedCacheable {
    protected static Map channelStateMap = Collections.synchronizedMap(new HashMap());
    protected static Map serviceDescriptionMap = new WeakHashMap();

    public ChannelRuntimeProperties getRuntimeProperties(String uid) {
        return new ChannelRuntimeProperties();
    }

    public void receiveEvent(PortalEvent ev, String uid) {
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        ChannelData cd = channelState.getChannelData();
        cd.setReceivedEvent(true);
        if (ev.getEventNumber() == 4) {
            cd.setMode("wsrp:edit");
        } else if (ev.getEventNumber() == 3) {
            cd.setMode("wsrp:help");
        }
        switch (ev.getEventNumber()) {
            case 4: {
                cd.setMode("wsrp:help");
                break;
            }
            case 3: {
                cd.setMode("wsrp:edit");
                break;
            }
            case 5: {
                cd.setMode("up_about");
                break;
            }
        }
        try {
            if (ev.getEventNumber() == 1 || ev.getEventNumber() == 2) {
                cd.getMarkupService().releaseSessions(cd.getRegistrationContext(), new String[]{cd.getSessionId()});
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "Unable to release session '" + cd.getSessionId() + "' in remote portal");
            LogService.log(LogService.ERROR, e);
        }
        if (channelState != null) {
            channelState.setPortalEvent(ev);
            if (ev.getEventNumber() == 1) {
                channelStateMap.remove(uid);
            }
        }
    }

    public void setStaticData(ChannelStaticData sd, String uid) throws PortalException {
        ChannelState channelState = new ChannelState();
        channelState.setStaticData(sd);
        channelStateMap.put(uid, channelState);
        ChannelData cd = channelState.getChannelData();
        String baseEndpoint = sd.getParameter("baseEndpoint");
        String portletHandle = sd.getParameter("portletHandle");
        if (baseEndpoint == null) {
            throw new PortalException("Missing publish parameter 'baseEndpoint'");
        }
        if (portletHandle == null) {
            throw new PortalException("Missing publish parameter 'portletHandle'");
        }
        ServiceDescriptionService serviceDescriptionService = null;
        try {
            boolean requiresRegistration;
            serviceDescriptionService = ServiceDescriptionService.getService(baseEndpoint);
            cd.setServiceDescriptionService(serviceDescriptionService);
            ServiceDescription serviceDescription = (ServiceDescription)serviceDescriptionMap.get(baseEndpoint);
            if (serviceDescription == null) {
                serviceDescription = serviceDescriptionService.getServiceDescription(null, null);
                serviceDescriptionMap.put(baseEndpoint, serviceDescription);
            }
            if (requiresRegistration = serviceDescription.isRequiresRegistration()) {
                throw new PortalException("Remote portlet '" + portletHandle + "' requires registration which is not yet supported.");
            }
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
        MarkupService markupService = null;
        try {
            markupService = MarkupService.getService(baseEndpoint);
            cd.setMarkupService(markupService);
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
        PortletContext portletContext = new PortletContext();
        portletContext.setPortletHandle(portletHandle);
        cd.setPortletContext(portletContext);
    }

    public void setRuntimeData(ChannelRuntimeData rd, String uid) throws PortalException {
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        channelState.setRuntimeData(rd);
        ChannelData cd = channelState.getChannelData();
        RegistrationContext registrationContext = cd.getRegistrationContext();
        MarkupService markupService = cd.getMarkupService();
        PortletContext portletContext = cd.getPortletContext();
        if (rd.getParameters().size() > 0) {
            try {
                RuntimeContext runtimeContext = this.getRuntimeContext(uid);
                UserContext userContext = this.getUserContext(uid);
                MarkupParams markupParams = this.getMarkupParams(uid);
                InteractionParams interactionParams = new InteractionParams();
                interactionParams.setPortletStateChange(StateChange.readWrite);
                interactionParams.setFormParameters(CConsumer.getFormParameters(rd));
                cd.setInteractionParams(interactionParams);
                markupService.performBlockingInteraction(registrationContext, portletContext, runtimeContext, userContext, markupParams, interactionParams);
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
        }
    }

    public void setPortalControlStructures(PortalControlStructures pcs, String uid) throws PortalException {
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        channelState.setPortalControlStructures(pcs);
    }

    public void renderCharacters(PrintWriter pw, String uid) throws PortalException {
        try {
            String markupString = this.getMarkup(uid);
            pw.print(markupString);
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    public void renderXML(ContentHandler out, String uid) throws PortalException {
        try {
            String markupString = this.getMarkup(uid);
            SAXHelper.outputContent(out, "<div>" + markupString + "</div>");
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    public ChannelCacheKey generateKey(String uid) {
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        PortalControlStructures pcs = channelState.getPortalControlStructures();
        ChannelData cd = channelState.getChannelData();
        ChannelCacheKey cck = new ChannelCacheKey();
        if (staticData.getPerson().isGuest()) {
            cck.setKeyScope(1);
            cck.setKey("SYSTEM_SCOPE_KEY");
        } else {
            cck.setKeyScope(0);
            cck.setKey("INSTANCE_SCOPE_KEY");
        }
        return cck;
    }

    public boolean isCacheValid(Object validity, String uid) {
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        PortalControlStructures pcs = channelState.getPortalControlStructures();
        ChannelData cd = channelState.getChannelData();
        boolean previouslyFocused = cd.getFocused();
        cd.setFocused(runtimeData.isRenderingAsRoot());
        boolean focusHasSwitched = cd.getFocused() != previouslyFocused;
        boolean cacheValid = !cd.getReceivedEvent() && runtimeData.size() == 0 && !focusHasSwitched;
        cd.setReceivedEvent(false);
        return cacheValid;
    }

    private String getMarkup(String uid) throws Exception {
        CacheControl cacheControl;
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        PortalControlStructures pcs = channelState.getPortalControlStructures();
        ChannelData cd = channelState.getChannelData();
        String markup = null;
        MarkupContext markupContext = cd.getMarkupContext();
        String key = this.generateKey(cd.getMarkupParams(), cd.getInteractionParams());
        if (markupContext != null && (cacheControl = markupContext.getCacheControl()) != null) {
            String userScope = cacheControl.getUserScope();
            MarkupWrapper markupWrapper = cd.getMarkupCache().get(key, userScope);
            if (markupWrapper != null) {
                if (!markupWrapper.hasExpired()) {
                    markup = markupWrapper.getMarkup();
                } else {
                    cd.getMarkupCache().remove(key, userScope);
                    if (markupContext.getUseCachedMarkup().booleanValue()) {
                        markup = markupWrapper.getMarkup();
                    }
                }
            }
        }
        if (markup == null) {
            MarkupResponse markupResponse = this.getMarkupFromProducer(uid);
            markupContext = markupResponse.getMarkupContext();
            cd.setMarkupContext(markupContext);
            if (markupContext.getRequiresUrlRewriting().booleanValue()) {
                throw new PortalException("Consumer URL rewriting is currently not supported");
            }
            markup = markupContext.getMarkupString();
            SessionContext sessionContext = markupResponse.getSessionContext();
            String sessionId = sessionContext.getSessionID();
            cd.setSessionId(sessionId);
            CacheControl cacheControl2 = markupContext.getCacheControl();
            if (cacheControl2 != null) {
                MarkupWrapper markupWrapper = new MarkupWrapper(markup, cacheControl2);
                cd.getMarkupCache().put(key, markupWrapper);
            }
        }
        return markup;
    }

    private MarkupResponse getMarkupFromProducer(String uid) throws Exception {
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        PortalControlStructures pcs = channelState.getPortalControlStructures();
        ChannelData cd = channelState.getChannelData();
        RegistrationContext registrationContext = cd.getRegistrationContext();
        PortletContext portletContext = cd.getPortletContext();
        RuntimeContext runtimeContext = this.getRuntimeContext(uid);
        UserContext userContext = this.getUserContext(uid);
        MarkupParams markupParams = this.getMarkupParams(uid);
        MarkupService markupService = cd.getMarkupService();
        MarkupResponse markupResponse = markupService.getMarkup(registrationContext, portletContext, runtimeContext, userContext, markupParams);
        return markupResponse;
    }

    private RuntimeContext getRuntimeContext(String uid) {
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        ChannelData cd = channelState.getChannelData();
        RuntimeContext runtimeContext = new RuntimeContext();
        runtimeContext.setUserAuthentication("wsrp:none");
        runtimeContext.setSessionID(cd.getSessionId());
        Templates templates = new Templates();
        templates.setRenderTemplate(runtimeData.getBaseActionURL());
        runtimeContext.setTemplates(templates);
        return runtimeContext;
    }

    private UserContext getUserContext(String uid) {
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        UserContext userContext = new UserContext();
        IPerson person = staticData.getPerson();
        UserProfile userProfile = new UserProfile();
        PersonName personName = new PersonName();
        personName.setGiven((String)person.getAttribute("givenName"));
        personName.setFamily((String)person.getAttribute("sn"));
        userProfile.setName(personName);
        userContext.setUserContextKey((String)person.getAttribute("username"));
        userContext.setProfile(userProfile);
        return userContext;
    }

    private MarkupParams getMarkupParams(String uid) {
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        ChannelData cd = channelState.getChannelData();
        MarkupParams markupParams = new MarkupParams();
        ClientData clientData = new ClientData();
        clientData.setUserAgent(runtimeData.getBrowserInfo().getUserAgent());
        markupParams.setClientData(clientData);
        markupParams.setSecureClientCommunication(false);
        markupParams.setLocales(CConsumer.getLocalesAsStringArray(runtimeData.getLocales()));
        MediaManager mediaManager = new MediaManager();
        markupParams.setMimeTypes(new String[]{mediaManager.getReturnMimeType(mediaManager.getMedia(runtimeData.getBrowserInfo()))});
        markupParams.setMode(cd.getMode());
        markupParams.setWindowState(cd.getFocused() ? "wsrp:solo" : "wsrp:normal");
        markupParams.setMarkupCharacterSets(new String[]{"UTF-8"});
        markupParams.setValidateTag(cd.getValidateTag());
        markupParams.setValidNewModes(new String[]{""});
        markupParams.setValidNewWindowStates(new String[]{""});
        cd.setMarkupParams(markupParams);
        return markupParams;
    }

    private String generateKey(MarkupParams mp, InteractionParams ip) {
        StringBuffer sbKey = new StringBuffer(1024);
        if (mp != null) {
            sbKey.append("MarkupParams: ");
            sbKey.append(mp.isSecureClientCommunication()).append("|");
            sbKey.append(this.getStringArrayAsString(mp.getLocales())).append("|");
            sbKey.append(this.getStringArrayAsString(mp.getMimeTypes())).append("|");
            sbKey.append(mp.getMode()).append("|");
            sbKey.append(mp.getWindowState()).append("|");
            sbKey.append(mp.getClientData().getUserAgent()).append("|");
            sbKey.append(mp.getNavigationalState()).append("|");
            sbKey.append(this.getStringArrayAsString(mp.getMarkupCharacterSets())).append("|");
            sbKey.append(mp.getValidateTag()).append("|");
            sbKey.append(this.getStringArrayAsString(mp.getValidNewModes())).append("|");
            sbKey.append(this.getStringArrayAsString(mp.getValidNewWindowStates()));
            sbKey.append("\n");
        }
        if (ip != null) {
            sbKey.append("InteractionParams: ");
            sbKey.append(ip.getPortletStateChange().getValue()).append("|");
            sbKey.append(ip.getInteractionState()).append("|");
            sbKey.append(this.getNamedStringArrayAsString(ip.getFormParameters())).append("|");
            sbKey.append(this.getUploadContextArrayAsString(ip.getUploadContexts()));
            sbKey.append("\n");
        }
        return sbKey.toString();
    }

    private String getStringArrayAsString(String[] strings) {
        String string = "null";
        if (strings != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            for (int i = 0; i < strings.length; ++i) {
                sb.append(strings[i]);
                if (i >= strings.length - 1) continue;
                sb.append(",");
            }
            sb.append("}");
            string = sb.toString();
        }
        return string;
    }

    private String getNamedStringArrayAsString(NamedString[] namedStrings) {
        String string = "null";
        if (namedStrings != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            for (int i = 0; i < namedStrings.length; ++i) {
                sb.append(namedStrings[i].getName()).append("=");
                sb.append(namedStrings[i].getValue());
                if (i >= namedStrings.length - 1) continue;
                sb.append(",");
            }
            sb.append("}");
            string = sb.toString();
        }
        return string;
    }

    private String getUploadContextArrayAsString(UploadContext[] uploadContexts) {
        String string = "null";
        if (uploadContexts != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            for (int i = 0; i < uploadContexts.length; ++i) {
                sb.append(uploadContexts[i].getMimeType()).append(",");
                sb.append(new String(uploadContexts[i].getUploadData())).append(",");
                sb.append(this.getNamedStringArrayAsString(uploadContexts[i].getMimeAttributes()));
            }
            sb.append("}");
            string = sb.toString();
        }
        return string;
    }

    private static String[] getLocalesAsStringArray(Locale[] locales) {
        if (locales == null) {
            locales = new Locale[]{Locale.getDefault()};
        }
        String[] localesStringArray = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            localesStringArray[i] = locales[i].toString();
        }
        return localesStringArray;
    }

    private static NamedString[] getFormParameters(ChannelRuntimeData runtimeData) {
        NamedString[] namedStrings = new NamedString[runtimeData.size()];
        int i = 0;
        Enumeration enumeration = runtimeData.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = runtimeData.getParameter(key);
            NamedString namedString = new NamedString();
            namedString.setName(key);
            namedString.setValue(value);
            namedStrings[i++] = namedString;
        }
        return namedStrings;
    }

    protected class ChannelData {
        private String sessionId = null;
        private boolean receivedEvent = false;
        private boolean focused = false;
        private String mode = "wsrp:view";
        private ServiceDescriptionService serviceDescriptionService = null;
        private MarkupService markupService = null;
        private RegistrationContext registrationContext = null;
        private PortletContext portletContext = null;
        private MarkupParams markupParams = null;
        private InteractionParams interactionParams = null;
        private MarkupContext markupContext = null;
        private MarkupCache markupCache = new MarkupCache();

        public String getSessionId() {
            return this.sessionId;
        }

        public boolean getReceivedEvent() {
            return this.receivedEvent;
        }

        public boolean getFocused() {
            return this.focused;
        }

        public String getMode() {
            return this.mode;
        }

        public ServiceDescriptionService getServiceDescriptionService() {
            return this.serviceDescriptionService;
        }

        public MarkupService getMarkupService() {
            return this.markupService;
        }

        public RegistrationContext getRegistrationContext() {
            return this.registrationContext;
        }

        public PortletContext getPortletContext() {
            return this.portletContext;
        }

        public MarkupParams getMarkupParams() {
            return this.markupParams;
        }

        public InteractionParams getInteractionParams() {
            return this.interactionParams;
        }

        public MarkupContext getMarkupContext() {
            return this.markupContext;
        }

        public MarkupCache getMarkupCache() {
            return this.markupCache;
        }

        public String getValidateTag() {
            String validateTag = null;
            if (this.markupContext != null && this.markupContext.getCacheControl() != null) {
                validateTag = this.markupContext.getCacheControl().getValidateTag();
            }
            return validateTag;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public void setReceivedEvent(boolean receivedEvent) {
            this.receivedEvent = receivedEvent;
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public void setServiceDescriptionService(ServiceDescriptionService serviceDescriptionService) {
            this.serviceDescriptionService = serviceDescriptionService;
        }

        public void setMarkupService(MarkupService markupService) {
            this.markupService = markupService;
        }

        public void setRegistrationContext(RegistrationContext registrationContext) {
            this.registrationContext = registrationContext;
        }

        public void setPortletContext(PortletContext portletContext) {
            this.portletContext = portletContext;
        }

        public void setMarkupParams(MarkupParams markupParams) {
            this.markupParams = markupParams;
        }

        public void setInteractionParams(InteractionParams interactionParams) {
            this.interactionParams = interactionParams;
        }

        public void setMarkupContext(MarkupContext markupContext) {
            this.markupContext = markupContext;
        }

        public void setMarkupCache(MarkupCache markupCache) {
            this.markupCache = markupCache;
        }
    }

    protected class ChannelState {
        private ChannelStaticData staticData = null;
        private ChannelRuntimeData runtimeData = null;
        private PortalEvent portalEvent = null;
        private PortalControlStructures pcs = null;
        private ChannelData channelData = new ChannelData();

        protected ChannelState() {
        }

        public ChannelStaticData getStaticData() {
            return this.staticData;
        }

        public ChannelRuntimeData getRuntimeData() {
            return this.runtimeData;
        }

        public PortalEvent getPortalEvent() {
            return this.portalEvent;
        }

        public PortalControlStructures getPortalControlStructures() {
            return this.pcs;
        }

        public ChannelData getChannelData() {
            return this.channelData;
        }

        public void setStaticData(ChannelStaticData sd) {
            this.staticData = sd;
        }

        public void setRuntimeData(ChannelRuntimeData rd) {
            this.runtimeData = rd;
        }

        public void setPortalEvent(PortalEvent ev) {
            this.portalEvent = ev;
        }

        public void setPortalControlStructures(PortalControlStructures pcs) {
            this.pcs = pcs;
        }

        public void setChannelData(ChannelData cd) {
            this.channelData = cd;
        }
    }
}

