/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.locking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jasig.portal.concurrency.IEntityLock;
import org.jasig.portal.concurrency.LockingException;
import org.jasig.portal.concurrency.locking.IEntityLockStore;
import org.jasig.portal.utils.SmartCache;

public class MemoryEntityLockStore
implements IEntityLockStore {
    private static IEntityLockStore singleton;
    private Map lockCache;

    public MemoryEntityLockStore() {
        this.initializeCache();
    }

    public void add(IEntityLock lock) throws LockingException {
        this.primAdd(lock, lock.getExpirationTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(IEntityLock lock) throws LockingException {
        Map m;
        Map map = m = this.getLockCache(lock.getEntityType());
        synchronized (map) {
            m.remove(this.getCacheKey(lock));
        }
    }

    public void deleteAll() {
        this.initializeCache();
    }

    public void deleteExpired(Date expiration) throws LockingException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntityLock[] find(Class entityType, String entityKey, Integer lockType, Date expiration, String lockOwner) throws LockingException {
        ArrayList<IEntityLock> locks = new ArrayList<IEntityLock>();
        Map cache = null;
        Collection caches = null;
        Iterator cacheIterator = null;
        Iterator cacheKeyIterator = null;
        Iterator keyIterator = null;
        IEntityLock lock = null;
        if (entityType == null) {
            caches = this.getLockCache().values();
        } else {
            caches = new ArrayList(1);
            caches.add(this.getLockCache(entityType));
        }
        cacheIterator = caches.iterator();
        while (cacheIterator.hasNext()) {
            cache = (Map)cacheIterator.next();
            cacheKeyIterator = cache.keySet().iterator();
            ArrayList keys = new ArrayList();
            Map map = cache;
            synchronized (map) {
                while (cacheKeyIterator.hasNext()) {
                    keys.add(cacheKeyIterator.next());
                }
            }
            keyIterator = keys.iterator();
            while (keyIterator.hasNext()) {
                lock = this.getLockFromCache(keyIterator.next(), cache);
                if (lock == null || entityKey != null && !entityKey.equals(lock.getEntityKey()) || lockType != null && lockType.intValue() != lock.getLockType() || lockOwner != null && !lockOwner.equals(lock.getLockOwner()) || expiration != null && !expiration.equals(lock.getExpirationTime())) continue;
                locks.add(lock);
            }
        }
        return locks.toArray(new IEntityLock[locks.size()]);
    }

    public IEntityLock find(IEntityLock lock) throws LockingException {
        IEntityLock foundLock = null;
        Map m = this.getLockCache(lock.getEntityType());
        foundLock = this.getLockFromCache(this.getCacheKey(lock), m);
        if (!(foundLock == null || lock.getLockType() == foundLock.getLockType() && lock.getExpirationTime().equals(foundLock.getExpirationTime()))) {
            foundLock = null;
        }
        return foundLock;
    }

    public IEntityLock[] findUnexpired(Date expiration, Class entityType, String entityKey, Integer lockType, String lockOwner) throws LockingException {
        IEntityLock[] locks = this.find(entityType, entityKey, lockType, null, lockOwner);
        ArrayList<IEntityLock> lockAL = new ArrayList<IEntityLock>(locks.length);
        for (int i = 0; i < locks.length; ++i) {
            if (!locks[i].getExpirationTime().after(expiration)) continue;
            lockAL.add(locks[i]);
        }
        return lockAL.toArray(new IEntityLock[lockAL.size()]);
    }

    private String getCacheKey(IEntityLock lock) {
        return lock.getEntityKey() + lock.getLockOwner();
    }

    private Map getLockCache() {
        return this.lockCache;
    }

    private synchronized Map getLockCache(Class type) {
        Map m = (Map)this.getLockCache().get(type);
        if (m == null) {
            m = new SmartCache();
            this.getLockCache().put(type, m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEntityLock getLockFromCache(Object cacheKey, Map cache) {
        Map map = cache;
        synchronized (map) {
            return (IEntityLock)cache.get(cacheKey);
        }
    }

    private void initializeCache() {
        this.lockCache = new HashMap(10);
    }

    private void setLockCache(Map newLockCache) {
        this.lockCache = newLockCache;
    }

    public static synchronized IEntityLockStore singleton() {
        if (singleton == null) {
            singleton = new MemoryEntityLockStore();
        }
        return singleton;
    }

    public void update(IEntityLock lock, Date newExpiration) throws LockingException {
        this.update(lock, newExpiration, null);
    }

    public void update(IEntityLock lock, Date newExpiration, Integer newLockType) throws LockingException {
        if (this.find(lock) == null) {
            throw new LockingException("Problem updating " + lock + " : not found in store.");
        }
        this.primAdd(lock, newExpiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primAdd(IEntityLock lock, Date expiration) throws LockingException {
        SmartCache sc;
        long now = System.currentTimeMillis();
        long willExpire = expiration.getTime();
        long cacheIntervalSecs = (willExpire - now) / 1000L;
        SmartCache smartCache = sc = (SmartCache)this.getLockCache(lock.getEntityType());
        synchronized (smartCache) {
            sc.put(this.getCacheKey(lock), lock, cacheIntervalSecs);
        }
    }
}

