/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.locking;

import java.util.Date;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.concurrency.IEntityLock;
import org.jasig.portal.concurrency.IEntityLockService;
import org.jasig.portal.concurrency.LockingException;
import org.jasig.portal.concurrency.locking.EntityLockImpl;
import org.jasig.portal.concurrency.locking.IEntityLockStore;
import org.jasig.portal.concurrency.locking.MemoryEntityLockStore;
import org.jasig.portal.concurrency.locking.RDBMEntityLockStore;
import org.jasig.portal.services.LogService;

public class ReferenceEntityLockService
implements IEntityLockService {
    private static IEntityLockService singleton = null;
    private IEntityLockStore lockStore = null;
    private boolean multiServer = false;
    private int defaultLockPeriod = 300;
    private int lockToleranceMillis = 5000;

    public ReferenceEntityLockService() throws LockingException {
        this.initialize();
    }

    public void convert(IEntityLock lock, int newType) throws LockingException {
        this.convert(lock, newType, this.defaultLockPeriod);
    }

    public void convert(IEntityLock lock, int newType, int newDuration) throws LockingException {
        if (lock.getLockType() == newType) {
            throw new LockingException("Could not convert " + lock + " : old and new lock TYPEs are the same.");
        }
        if (!this.isValidLockType(newType)) {
            throw new LockingException("Could not convert " + lock + " : lock TYPE " + newType + " is invalid.");
        }
        if (!this.isValid(lock)) {
            throw new LockingException("Could not convert " + lock + " : lock is invalid.");
        }
        if (newType == 1 && this.retrieveLocks(lock.getEntityType(), lock.getEntityKey(), null).length > 1) {
            throw new LockingException("Could not convert " + lock + " : another lock already exists.");
        }
        if (newType == 0) {
            // empty if block
        }
        Date newExpiration = this.getNewExpiration(newDuration);
        this.getLockStore().update(lock, newExpiration, new Integer(newType));
        ((EntityLockImpl)lock).setLockType(newType);
        ((EntityLockImpl)lock).setExpirationTime(newExpiration);
    }

    public boolean existsInStore(IEntityLock lock) throws LockingException {
        Class entityType = lock.getEntityType();
        String key = lock.getEntityKey();
        Integer lockType = new Integer(lock.getLockType());
        Date expiration = lock.getExpirationTime();
        String owner = lock.getLockOwner();
        IEntityLock[] lockArray = this.getLockStore().find(entityType, key, lockType, expiration, owner);
        return lockArray.length == 1;
    }

    private int getDefaultLockPeriod() {
        return this.defaultLockPeriod;
    }

    private IEntityLockStore getLockStore() {
        return this.lockStore;
    }

    private int getLockToleranceMillis() {
        return this.lockToleranceMillis;
    }

    private Date getNewExpiration(int durationSecs) {
        return new Date(System.currentTimeMillis() + (long)(durationSecs * 1000));
    }

    private void initialize() throws LockingException {
        String eMsg = null;
        try {
            this.multiServer = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.concurrency.multiServer");
            this.lockStore = this.multiServer ? RDBMEntityLockStore.singleton() : MemoryEntityLockStore.singleton();
        }
        catch (Exception e) {
            eMsg = "ReferenceEntityLockingService.initialize(): Failed to instantiate entity lock store. " + e;
            LogService.log(LogService.ERROR, eMsg);
            throw new LockingException(eMsg);
        }
        try {
            int lockDuration = PropertiesManager.getPropertyAsInt("org.jasig.portal.concurrency.IEntityLockService.defaultLockDuration");
            this.setDefaultLockPeriod(lockDuration);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.multiServer) {
            try {
                int lockTolerance = PropertiesManager.getPropertyAsInt("org.jasig.portal.concurrency.clockTolerance");
                this.setLockToleranceMillis(lockTolerance);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isLocked(Class entityType, String entityKey) throws LockingException {
        return this.isLocked(entityType, entityKey, null);
    }

    private boolean isLocked(Class entityType, String entityKey, Integer lockType) throws LockingException {
        IEntityLock[] locks = this.retrieveLocks(entityType, entityKey, lockType);
        return locks.length > 0;
    }

    private boolean isMultiServer() {
        return this.multiServer;
    }

    private boolean isUnexpired(IEntityLock lock) {
        return lock.getExpirationTime().getTime() > System.currentTimeMillis();
    }

    public boolean isValid(IEntityLock lock) throws LockingException {
        return this.isUnexpired(lock) && this.existsInStore(lock);
    }

    private boolean isValidLockType(int lockType) {
        return lockType == 0 || lockType == 1;
    }

    public IEntityLock newLock(Class entityType, String entityKey, int lockType, String owner) throws LockingException {
        return this.newLock(entityType, entityKey, lockType, owner, this.defaultLockPeriod);
    }

    public IEntityLock newLock(Class entityType, String entityKey, int lockType, String owner, int durationSecs) throws LockingException {
        Date expires = this.getNewExpiration(durationSecs);
        EntityLockImpl lock = new EntityLockImpl(entityType, entityKey, lockType, expires, owner, this);
        if (lockType == 1 && this.isLocked(entityType, entityKey)) {
            throw new LockingException("Could not create lock: entity already locked.");
        }
        if (lockType == 0) {
            IEntityLock[] locks = this.retrieveLocks(entityType, entityKey, null);
            for (int i = 0; i < locks.length; ++i) {
                if (locks[i].getLockType() == 1) {
                    throw new LockingException("Could not create lock: entity already write locked.");
                }
                if (!locks[i].getLockOwner().equals(owner)) continue;
                throw new LockingException("Could not create lock: owner " + owner + " already holds lock on this entity.");
            }
        }
        this.getLockStore().add(lock);
        return lock;
    }

    public IEntityLock newLock(EntityIdentifier entityID, int lockType, String owner) throws LockingException {
        return this.newLock(entityID.getType(), entityID.getKey(), lockType, owner, this.defaultLockPeriod);
    }

    public IEntityLock newLock(EntityIdentifier entityID, int lockType, String owner, int durationSecs) throws LockingException {
        return this.newLock(entityID.getType(), entityID.getKey(), lockType, owner, durationSecs);
    }

    public void release(IEntityLock lock) throws LockingException {
        this.getLockStore().delete(lock);
        ((EntityLockImpl)lock).setExpirationTime(new Date(0L));
    }

    public void renew(IEntityLock lock) throws LockingException {
        this.renew(lock, this.defaultLockPeriod);
    }

    public void renew(IEntityLock lock, int duration) throws LockingException {
        if (!this.isValid(lock)) {
            throw new LockingException("Could not renew " + lock + " : lock is invalid.");
        }
        Date newExpiration = this.getNewExpiration(duration);
        this.getLockStore().update(lock, newExpiration);
        ((EntityLockImpl)lock).setExpirationTime(newExpiration);
    }

    private IEntityLock[] retrieveLocks(Class entityType, String entityKey, Integer lockType) throws LockingException {
        Date expiration = this.multiServer ? new Date(System.currentTimeMillis() - (long)this.getLockToleranceMillis()) : new Date();
        return this.getLockStore().findUnexpired(expiration, entityType, entityKey, lockType, null);
    }

    private void setDefaultLockPeriod(int newDefaultLockPeriod) {
        this.defaultLockPeriod = newDefaultLockPeriod;
    }

    private void setLockToleranceMillis(int newLockToleranceMillis) {
        this.lockToleranceMillis = newLockToleranceMillis;
    }

    private void setMultiServer(boolean newMultiServer) {
        this.multiServer = newMultiServer;
    }

    public static synchronized IEntityLockService singleton() throws LockingException {
        if (singleton == null) {
            singleton = new ReferenceEntityLockService();
        }
        return singleton;
    }
}

