/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.EntityGroupImpl;
import org.jasig.portal.groups.GroupServiceConfiguration;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityGroupStore;
import org.jasig.portal.groups.IGroupConstants;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.IGroupService;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.groups.LockableEntityGroupImpl;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.SequenceGenerator;
import org.jasig.portal.utils.SqlTransaction;

public class RDBMEntityGroupStore
implements IEntityGroupStore,
IGroupConstants {
    private static RDBMEntityGroupStore singleton;
    private static String GROUP_TABLE;
    private static String GROUP_TABLE_ALIAS;
    private static String GROUP_ID_COLUMN;
    private static String GROUP_CREATOR_COLUMN;
    private static String GROUP_TYPE_COLUMN;
    private static String GROUP_NAME_COLUMN;
    private static String GROUP_DESCRIPTION_COLUMN;
    private static String allGroupColumns;
    private static String allGroupColumnsWithTableAlias;
    private static String findContainingGroupsForEntitySql;
    private static String findContainingGroupsForGroupSql;
    private static String findGroupSql;
    private static String findGroupsByCreatorSql;
    private static String findMemberGroupKeysSql;
    private static String findMemberGroupSql;
    private static String findMemberGroupsSql;
    private static String insertGroupSql;
    private static String updateGroupSql;
    private static String MEMBER_TABLE;
    private static String MEMBER_TABLE_ALIAS;
    private static String MEMBER_GROUP_ID_COLUMN;
    private static String MEMBER_MEMBER_SERVICE_COLUMN;
    private static String MEMBER_MEMBER_KEY_COLUMN;
    private static String MEMBER_IS_GROUP_COLUMN;
    private static String MEMBER_IS_ENTITY;
    private static String MEMBER_IS_GROUP;
    private static String GROUP_NODE_SEPARATOR;
    private static String allMemberColumns;
    private static String deleteMembersInGroupSql;
    private static String deleteMemberGroupSql;
    private static String deleteMemberEntitySql;
    private static String insertMemberSql;
    private static String searchGroupsPartial;
    private static String searchGroups;
    private IGroupService groupService;

    public RDBMEntityGroupStore() {
        this.initialize();
    }

    private void initialize() {
        String sep;
        try {
            sep = GroupServiceConfiguration.getConfiguration().getNodeSeparator();
        }
        catch (Exception ex) {
            sep = ".";
        }
        GROUP_NODE_SEPARATOR = sep;
        String msg = "RDBMEntityGroupStore.initialize(): Node separator set to " + sep;
        LogService.log(LogService.INFO, msg);
    }

    protected static void commit(Connection conn) throws SQLException {
        SqlTransaction.commit(conn);
    }

    public void delete(IEntityGroup group) throws GroupsException {
        if (this.existsInDatabase(group)) {
            try {
                this.primDelete(group);
            }
            catch (SQLException sqle) {
                throw new GroupsException("Problem deleting " + group + ": " + sqle.getMessage());
            }
        }
    }

    private boolean existsInDatabase(IEntityGroup group) throws GroupsException {
        IEntityGroup ug = this.find(group.getLocalKey());
        return ug != null;
    }

    public IEntityGroup find(String groupID) throws GroupsException {
        return this.primFind(groupID, false);
    }

    public Iterator findContainingGroups(IEntity ent) throws GroupsException {
        String memberKey = ent.getKey();
        Integer type = EntityTypes.getEntityTypeID(ent.getLeafType());
        return this.findContainingGroupsForEntity(memberKey, type, false);
    }

    public Iterator findContainingGroups(IEntityGroup group) throws GroupsException {
        String memberKey = group.getLocalKey();
        String serviceName = group.getServiceName().toString();
        Integer type = EntityTypes.getEntityTypeID(group.getLeafType());
        return this.findContainingGroupsForGroup(serviceName, memberKey, type, true);
    }

    public Iterator findContainingGroups(IGroupMember gm) throws GroupsException {
        if (gm.isGroup()) {
            IEntityGroup group = (IEntityGroup)gm;
            return this.findContainingGroups(group);
        }
        IEntity ent = (IEntity)gm;
        return this.findContainingGroups(ent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator findContainingGroupsForEntity(String memberKey, int type, boolean isGroup) throws GroupsException {
        Connection conn = null;
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>();
        IEntityGroup eg = null;
        String groupOrEntity = isGroup ? MEMBER_IS_GROUP : MEMBER_IS_ENTITY;
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindContainingGroupsForEntitySql();
            RDBMServices.PreparedStatement ps = new RDBMServices.PreparedStatement(conn, sql);
            try {
                ps.setString(1, memberKey);
                ps.setInt(2, type);
                ps.setString(3, groupOrEntity);
                LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.findContainingGroupsForEntity(): " + ps + " (" + memberKey + ", " + type + ", " + groupOrEntity + ")");
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        eg = this.instanceFromResultSet(rs);
                        groups.add(eg);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMEntityGroupStore.findContainingGroupsForEntity(): " + e);
            throw new GroupsException("Problem retrieving containing groups: " + e);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return groups.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator findContainingGroupsForGroup(String serviceName, String memberKey, int type, boolean isGroup) throws GroupsException {
        Connection conn = null;
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>();
        IEntityGroup eg = null;
        String groupOrEntity = isGroup ? MEMBER_IS_GROUP : MEMBER_IS_ENTITY;
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindContainingGroupsForGroupSql();
            RDBMServices.PreparedStatement ps = new RDBMServices.PreparedStatement(conn, sql);
            try {
                ps.setString(1, serviceName);
                ps.setString(2, memberKey);
                ps.setInt(3, type);
                ps.setString(4, groupOrEntity);
                LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.findContainingGroupsForGroup(): " + ps + " (" + serviceName + ", " + memberKey + ", " + type + ", " + groupOrEntity + ")");
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        eg = this.instanceFromResultSet(rs);
                        groups.add(eg);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMEntityGroupStore.findContainingGroupsForGroup(): " + e);
            throw new GroupsException("Problem retrieving containing groups: " + e);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return groups.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator findEntitiesForGroup(IEntityGroup group) throws GroupsException {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        Connection conn = null;
        String groupID = group.getLocalKey();
        Class cls = group.getLeafType();
        try {
            conn = RDBMServices.getConnection();
            Statement stmnt = conn.createStatement();
            try {
                String query = "SELECT " + MEMBER_MEMBER_KEY_COLUMN + " FROM " + MEMBER_TABLE + " WHERE " + MEMBER_GROUP_ID_COLUMN + " = '" + groupID + "' AND " + MEMBER_IS_GROUP_COLUMN + " = '" + MEMBER_IS_ENTITY + "'";
                ResultSet rs = stmnt.executeQuery(query);
                try {
                    while (rs.next()) {
                        String key = rs.getString(1);
                        IEntity e = this.newEntity(cls, key);
                        entities.add(e);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw new GroupsException("Problem retrieving Entities for Group: " + sqle.getMessage());
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return entities.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator findGroupsByCreator(String creatorID) throws GroupsException {
        Connection conn = null;
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>();
        IEntityGroup eg = null;
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindGroupsByCreatorSql();
            RDBMServices.PreparedStatement ps = new RDBMServices.PreparedStatement(conn, sql);
            try {
                ps.setString(1, creatorID);
                LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.findGroupsByCreator(): " + ps);
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        eg = this.instanceFromResultSet(rs);
                        groups.add(eg);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMEntityGroupStore.findGroupsByCreator(): " + e);
            throw new GroupsException("Problem retrieving groups: " + e);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return groups.iterator();
    }

    public ILockableEntityGroup findLockable(String groupID) throws GroupsException {
        return (ILockableEntityGroup)this.primFind(groupID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findMemberGroupKeys(IEntityGroup group) throws GroupsException {
        Connection conn = null;
        ArrayList<String> groupKeys = new ArrayList<String>();
        String groupKey = null;
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindMemberGroupKeysSql();
            RDBMServices.PreparedStatement ps = new RDBMServices.PreparedStatement(conn, sql);
            try {
                ps.setString(1, group.getLocalKey());
                LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.findMemberGroupKeys(): " + ps + " (" + group.getLocalKey() + ")");
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        groupKey = rs.getString(1) + GROUP_NODE_SEPARATOR + rs.getString(2);
                        groupKeys.add(groupKey);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception sqle) {
            LogService.log(LogService.ERROR, "RDBMEntityGroupStore.findMemberGroupKeys(): " + sqle);
            throw new GroupsException("Problem retrieving member group keys: " + sqle);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return groupKeys.toArray(new String[groupKeys.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator findMemberGroups(IEntityGroup group) throws GroupsException {
        Connection conn = null;
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>();
        IEntityGroup eg = null;
        String serviceName = group.getServiceName().toString();
        String localKey = group.getLocalKey();
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindMemberGroupsSql();
            RDBMServices.PreparedStatement ps = new RDBMServices.PreparedStatement(conn, sql);
            try {
                ps.setString(1, localKey);
                ps.setString(2, serviceName);
                LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.findMemberGroups(): " + ps + " (" + localKey + ", " + serviceName + ")");
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        eg = this.instanceFromResultSet(rs);
                        groups.add(eg);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception sqle) {
            LogService.log(LogService.ERROR, "RDBMEntityGroupStore.findMemberGroups(): " + sqle);
            throw new GroupsException("Problem retrieving member groups: " + sqle);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return groups.iterator();
    }

    private static String getAllGroupColumns() {
        if (allGroupColumns == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append(GROUP_ID_COLUMN);
            buff.append(", ");
            buff.append(GROUP_CREATOR_COLUMN);
            buff.append(", ");
            buff.append(GROUP_TYPE_COLUMN);
            buff.append(", ");
            buff.append(GROUP_NAME_COLUMN);
            buff.append(", ");
            buff.append(GROUP_DESCRIPTION_COLUMN);
            allGroupColumns = buff.toString();
        }
        return allGroupColumns;
    }

    private static String getAllGroupColumnsWithTableAlias() {
        if (allGroupColumnsWithTableAlias == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append(RDBMEntityGroupStore.prependGroupTableAlias(GROUP_ID_COLUMN));
            buff.append(", ");
            buff.append(RDBMEntityGroupStore.prependGroupTableAlias(GROUP_CREATOR_COLUMN));
            buff.append(", ");
            buff.append(RDBMEntityGroupStore.prependGroupTableAlias(GROUP_TYPE_COLUMN));
            buff.append(", ");
            buff.append(RDBMEntityGroupStore.prependGroupTableAlias(GROUP_NAME_COLUMN));
            buff.append(", ");
            buff.append(RDBMEntityGroupStore.prependGroupTableAlias(GROUP_DESCRIPTION_COLUMN));
            allGroupColumnsWithTableAlias = buff.toString();
        }
        return allGroupColumnsWithTableAlias;
    }

    private static String getAllMemberColumns() {
        if (allMemberColumns == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append(MEMBER_GROUP_ID_COLUMN);
            buff.append(", ");
            buff.append(MEMBER_MEMBER_SERVICE_COLUMN);
            buff.append(", ");
            buff.append(MEMBER_MEMBER_KEY_COLUMN);
            buff.append(", ");
            buff.append(MEMBER_IS_GROUP_COLUMN);
            allMemberColumns = buff.toString();
        }
        return allMemberColumns;
    }

    private static String getDeleteGroupSql(IEntityGroup group) {
        StringBuffer buff = new StringBuffer(100);
        buff.append("DELETE FROM ");
        buff.append(GROUP_TABLE);
        buff.append(" WHERE ");
        buff.append(GROUP_ID_COLUMN);
        buff.append(" = '");
        buff.append(group.getLocalKey());
        buff.append("'");
        return buff.toString();
    }

    private static String getDeleteMemberEntitySql() {
        if (deleteMemberEntitySql == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("DELETE FROM ");
            buff.append(MEMBER_TABLE);
            buff.append(" WHERE ");
            buff.append(MEMBER_GROUP_ID_COLUMN);
            buff.append(" = ? AND ");
            buff.append(MEMBER_MEMBER_KEY_COLUMN);
            buff.append(" = ? AND ");
            buff.append(MEMBER_IS_GROUP_COLUMN);
            buff.append(" = ? ");
            deleteMemberEntitySql = buff.toString();
        }
        return deleteMemberEntitySql;
    }

    private static String getDeleteMemberGroupSql() {
        if (deleteMemberGroupSql == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("DELETE FROM ");
            buff.append(MEMBER_TABLE);
            buff.append(" WHERE ");
            buff.append(MEMBER_GROUP_ID_COLUMN);
            buff.append(" = ? AND ");
            buff.append(MEMBER_MEMBER_SERVICE_COLUMN);
            buff.append(" = ? AND ");
            buff.append(MEMBER_MEMBER_KEY_COLUMN);
            buff.append(" = ? AND ");
            buff.append(MEMBER_IS_GROUP_COLUMN);
            buff.append(" = ? ");
            deleteMemberGroupSql = buff.toString();
        }
        return deleteMemberGroupSql;
    }

    private static String getDeleteMembersInGroupSql() {
        if (deleteMembersInGroupSql == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("DELETE FROM ");
            buff.append(MEMBER_TABLE);
            buff.append(" WHERE ");
            buff.append(GROUP_ID_COLUMN);
            buff.append(" = ");
            deleteMembersInGroupSql = buff.toString();
        }
        return deleteMembersInGroupSql;
    }

    private static String getDeleteMembersInGroupSql(IEntityGroup group) {
        StringBuffer buff = new StringBuffer(RDBMEntityGroupStore.getDeleteMembersInGroupSql());
        buff.append("'");
        buff.append(group.getLocalKey());
        buff.append("'");
        return buff.toString();
    }

    private static String getFindContainingGroupsForEntitySql() {
        if (findContainingGroupsForEntitySql == null) {
            StringBuffer buff = new StringBuffer(500);
            buff.append("SELECT ");
            buff.append(RDBMEntityGroupStore.getAllGroupColumnsWithTableAlias());
            buff.append(" FROM ");
            buff.append(GROUP_TABLE + " " + GROUP_TABLE_ALIAS);
            buff.append(", ");
            buff.append(MEMBER_TABLE + " " + MEMBER_TABLE_ALIAS);
            buff.append(" WHERE ");
            buff.append(RDBMEntityGroupStore.prependGroupTableAlias(GROUP_ID_COLUMN));
            buff.append(" = ");
            buff.append(RDBMEntityGroupStore.prependMemberTableAlias(MEMBER_GROUP_ID_COLUMN));
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.prependMemberTableAlias(MEMBER_MEMBER_KEY_COLUMN));
            buff.append(" = ? AND ");
            buff.append(RDBMEntityGroupStore.prependGroupTableAlias(GROUP_TYPE_COLUMN));
            buff.append(" = ? AND ");
            buff.append(RDBMEntityGroupStore.prependMemberTableAlias(MEMBER_IS_GROUP_COLUMN));
            buff.append(" = ? ");
            findContainingGroupsForEntitySql = buff.toString();
        }
        return findContainingGroupsForEntitySql;
    }

    private static String getFindContainingGroupsForGroupSql() {
        if (findContainingGroupsForGroupSql == null) {
            StringBuffer buff = new StringBuffer(500);
            buff.append("SELECT ");
            buff.append(RDBMEntityGroupStore.getAllGroupColumnsWithTableAlias());
            buff.append(" FROM ");
            buff.append(GROUP_TABLE + " " + GROUP_TABLE_ALIAS);
            buff.append(", ");
            buff.append(MEMBER_TABLE + " " + MEMBER_TABLE_ALIAS);
            buff.append(" WHERE ");
            buff.append(RDBMEntityGroupStore.prependGroupTableAlias(GROUP_ID_COLUMN));
            buff.append(" = ");
            buff.append(RDBMEntityGroupStore.prependMemberTableAlias(MEMBER_GROUP_ID_COLUMN));
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.prependMemberTableAlias(MEMBER_MEMBER_SERVICE_COLUMN));
            buff.append(" = ? AND ");
            buff.append(RDBMEntityGroupStore.prependMemberTableAlias(MEMBER_MEMBER_KEY_COLUMN));
            buff.append(" = ? AND ");
            buff.append(RDBMEntityGroupStore.prependGroupTableAlias(GROUP_TYPE_COLUMN));
            buff.append(" = ? AND ");
            buff.append(RDBMEntityGroupStore.prependMemberTableAlias(MEMBER_IS_GROUP_COLUMN));
            buff.append(" = ? ");
            findContainingGroupsForGroupSql = buff.toString();
        }
        return findContainingGroupsForGroupSql;
    }

    private static String getFindGroupsByCreatorSql() {
        if (findGroupsByCreatorSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("SELECT ");
            buff.append(RDBMEntityGroupStore.getAllGroupColumns());
            buff.append(" FROM ");
            buff.append(GROUP_TABLE);
            buff.append(" WHERE ");
            buff.append(GROUP_CREATOR_COLUMN);
            buff.append(" = ? ");
            findGroupsByCreatorSql = buff.toString();
        }
        return findGroupsByCreatorSql;
    }

    private static String getFindGroupSql() {
        if (findGroupSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("SELECT ");
            buff.append(RDBMEntityGroupStore.getAllGroupColumns());
            buff.append(" FROM ");
            buff.append(GROUP_TABLE);
            buff.append(" WHERE ");
            buff.append(GROUP_ID_COLUMN);
            buff.append(" = ? ");
            findGroupSql = buff.toString();
        }
        return findGroupSql;
    }

    private static String getFindMemberGroupKeysSql() {
        if (findMemberGroupKeysSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("SELECT ");
            buff.append(MEMBER_MEMBER_SERVICE_COLUMN + ", " + MEMBER_MEMBER_KEY_COLUMN);
            buff.append(" FROM ");
            buff.append(MEMBER_TABLE);
            buff.append(" WHERE ");
            buff.append(MEMBER_GROUP_ID_COLUMN);
            buff.append(" = ? AND ");
            buff.append(MEMBER_IS_GROUP_COLUMN);
            buff.append(" = '");
            buff.append(MEMBER_IS_GROUP);
            buff.append("'");
            findMemberGroupKeysSql = buff.toString();
        }
        return findMemberGroupKeysSql;
    }

    private static String getFindMemberGroupSql() {
        if (findMemberGroupSql == null) {
            StringBuffer buff = new StringBuffer(RDBMEntityGroupStore.getFindMemberGroupsSql());
            buff.append("AND ");
            buff.append(GROUP_TABLE_ALIAS);
            buff.append(".");
            buff.append(GROUP_NAME_COLUMN);
            buff.append(" = ?");
            findMemberGroupSql = buff.toString();
        }
        return findMemberGroupSql;
    }

    private static String getFindMemberGroupsSql() {
        if (findMemberGroupsSql == null) {
            StringBuffer buff = new StringBuffer(500);
            buff.append("SELECT ");
            buff.append(RDBMEntityGroupStore.getAllGroupColumnsWithTableAlias());
            buff.append(" FROM ");
            buff.append(GROUP_TABLE + " " + GROUP_TABLE_ALIAS);
            buff.append(", ");
            buff.append(MEMBER_TABLE + " " + MEMBER_TABLE_ALIAS);
            buff.append(" WHERE ");
            buff.append(RDBMEntityGroupStore.prependGroupTableAlias(GROUP_ID_COLUMN));
            buff.append(" = ");
            buff.append(RDBMEntityGroupStore.prependMemberTableAlias(MEMBER_MEMBER_KEY_COLUMN));
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.prependMemberTableAlias(MEMBER_IS_GROUP_COLUMN));
            buff.append(" = '");
            buff.append(MEMBER_IS_GROUP);
            buff.append("' AND ");
            buff.append(RDBMEntityGroupStore.prependMemberTableAlias(MEMBER_GROUP_ID_COLUMN));
            buff.append(" = ? ");
            buff.append(" AND ");
            buff.append(RDBMEntityGroupStore.prependMemberTableAlias(MEMBER_MEMBER_SERVICE_COLUMN));
            buff.append(" = ? ");
            findMemberGroupsSql = buff.toString();
        }
        return findMemberGroupsSql;
    }

    public IGroupService getGroupService() {
        return this.groupService;
    }

    private static String getInsertGroupSql() {
        if (insertGroupSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("INSERT INTO ");
            buff.append(GROUP_TABLE);
            buff.append(" (");
            buff.append(RDBMEntityGroupStore.getAllGroupColumns());
            buff.append(") VALUES (?, ?, ?, ?, ?)");
            insertGroupSql = buff.toString();
        }
        return insertGroupSql;
    }

    private static String getInsertMemberSql() {
        if (insertMemberSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("INSERT INTO ");
            buff.append(MEMBER_TABLE);
            buff.append(" (");
            buff.append(RDBMEntityGroupStore.getAllMemberColumns());
            buff.append(") VALUES (?, ?, ?, ? )");
            insertMemberSql = buff.toString();
        }
        return insertMemberSql;
    }

    private String getNextKey() throws Exception {
        return SequenceGenerator.instance().getNext(GROUP_TABLE);
    }

    private static String getUpdateGroupSql() {
        if (updateGroupSql == null) {
            StringBuffer buff = new StringBuffer(200);
            buff.append("UPDATE ");
            buff.append(GROUP_TABLE);
            buff.append(" SET ");
            buff.append(GROUP_CREATOR_COLUMN);
            buff.append(" = ?, ");
            buff.append(GROUP_TYPE_COLUMN);
            buff.append(" = ?, ");
            buff.append(GROUP_NAME_COLUMN);
            buff.append(" = ?, ");
            buff.append(GROUP_DESCRIPTION_COLUMN);
            buff.append(" = ? WHERE ");
            buff.append(GROUP_ID_COLUMN);
            buff.append(" = ? ");
            updateGroupSql = buff.toString();
        }
        return updateGroupSql;
    }

    private IEntityGroup instanceFromResultSet(ResultSet rs) throws SQLException, GroupsException {
        IEntityGroup eg = null;
        String key = rs.getString(1);
        String creatorID = rs.getString(2);
        Integer entityTypeID = new Integer(rs.getInt(3));
        Class entityType = EntityTypes.getEntityType(entityTypeID);
        String groupName = rs.getString(4);
        String description = rs.getString(5);
        if (key != null) {
            eg = this.newInstance(key, entityType, creatorID, groupName, description);
        }
        return eg;
    }

    private ILockableEntityGroup lockableInstanceFromResultSet(ResultSet rs) throws SQLException, GroupsException {
        ILockableEntityGroup eg = null;
        String key = rs.getString(1);
        String creatorID = rs.getString(2);
        Integer entityTypeID = new Integer(rs.getInt(3));
        Class entityType = EntityTypes.getEntityType(entityTypeID);
        String groupName = rs.getString(4);
        String description = rs.getString(5);
        if (key != null) {
            eg = this.newLockableInstance(key, entityType, creatorID, groupName, description);
        }
        return eg;
    }

    protected static void logNoTransactionWarning() {
        String msg = "You are running the portal on a database that does not support transactions.  This is not a supported production environment for uPortal.  Sooner or later, your database will become corrupt.";
        LogService.log(LogService.WARN, msg);
    }

    public IEntity newEntity(Class type, String key) throws GroupsException {
        if (EntityTypes.getEntityTypeID(type) == null) {
            throw new GroupsException("Invalid group type: " + type);
        }
        return GroupService.getEntity(key, type);
    }

    public IEntityGroup newInstance(Class type) throws GroupsException {
        if (EntityTypes.getEntityTypeID(type) == null) {
            throw new GroupsException("Invalid group type: " + type);
        }
        try {
            return new EntityGroupImpl(this.getNextKey(), type);
        }
        catch (Exception ex) {
            throw new GroupsException("Could not create new group: " + ex.getMessage());
        }
    }

    private IEntityGroup newInstance(String newKey, Class newType, String newCreatorID, String newName, String newDescription) throws GroupsException {
        EntityGroupImpl egi = new EntityGroupImpl(newKey, newType);
        egi.setCreatorID(newCreatorID);
        egi.primSetName(newName);
        egi.setDescription(newDescription);
        return egi;
    }

    private ILockableEntityGroup newLockableInstance(String newKey, Class newType, String newCreatorID, String newName, String newDescription) throws GroupsException {
        LockableEntityGroupImpl group = new LockableEntityGroupImpl(newKey, newType);
        group.setCreatorID(newCreatorID);
        group.primSetName(newName);
        group.setDescription(newDescription);
        return group;
    }

    private static String prependGroupTableAlias(String column) {
        return GROUP_TABLE_ALIAS + "." + column;
    }

    private static String prependMemberTableAlias(String column) {
        return MEMBER_TABLE_ALIAS + "." + column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primAdd(IEntityGroup group, Connection conn) throws SQLException, GroupsException {
        try {
            RDBMServices.PreparedStatement ps = new RDBMServices.PreparedStatement(conn, RDBMEntityGroupStore.getInsertGroupSql());
            try {
                Integer typeID = EntityTypes.getEntityTypeID(group.getLeafType());
                ps.setString(1, group.getLocalKey());
                ps.setString(2, group.getCreatorID());
                ps.setInt(3, typeID);
                ps.setString(4, group.getName());
                ps.setString(5, group.getDescription());
                LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.primAdd(): " + ps + "(" + group.getLocalKey() + ", " + group.getCreatorID() + ", " + typeID + ", " + group.getName() + ", " + group.getDescription() + ")");
                int rc = ps.executeUpdate();
                if (rc != 1) {
                    String errString = "Problem adding " + group;
                    LogService.log(LogService.ERROR, errString);
                    throw new GroupsException(errString);
                }
            }
            finally {
                ps.close();
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void primDelete(IEntityGroup group) throws SQLException {
        Connection conn = null;
        String deleteGroupSql = RDBMEntityGroupStore.getDeleteGroupSql(group);
        String deleteMembershipSql = RDBMEntityGroupStore.getDeleteMembersInGroupSql(group);
        conn = RDBMServices.getConnection();
        Statement stmnt = conn.createStatement();
        RDBMEntityGroupStore.setAutoCommit(conn, false);
        try {
            LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.primDelete(): " + deleteMembershipSql);
            stmnt.executeUpdate(deleteMembershipSql);
            LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.primDelete(): " + deleteGroupSql);
            stmnt.executeUpdate(deleteGroupSql);
        }
        finally {
            stmnt.close();
        }
        RDBMEntityGroupStore.commit(conn);
        Object var8_8 = null;
        try {
            RDBMEntityGroupStore.setAutoCommit(conn, true);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        {
            catch (SQLException sqle) {
                RDBMEntityGroupStore.rollback(conn);
                throw sqle;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                RDBMEntityGroupStore.setAutoCommit(conn, true);
            }
            finally {
                RDBMServices.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEntityGroup primFind(String groupID, boolean lockable) throws GroupsException {
        IEntityGroup eg = null;
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            String sql = RDBMEntityGroupStore.getFindGroupSql();
            RDBMServices.PreparedStatement ps = new RDBMServices.PreparedStatement(conn, sql);
            try {
                ps.setString(1, groupID);
                LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.find(): " + ps + " (" + groupID + ")");
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        eg = lockable ? this.lockableInstanceFromResultSet(rs) : this.instanceFromResultSet(rs);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMEntityGroupStore.find(): " + e);
            throw new GroupsException("Error retrieving " + groupID + ": " + e);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return eg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primUpdate(IEntityGroup group, Connection conn) throws SQLException, GroupsException {
        try {
            RDBMServices.PreparedStatement ps = new RDBMServices.PreparedStatement(conn, RDBMEntityGroupStore.getUpdateGroupSql());
            try {
                Integer typeID = EntityTypes.getEntityTypeID(group.getLeafType());
                ps.setString(1, group.getCreatorID());
                ps.setInt(2, typeID);
                ps.setString(3, group.getName());
                ps.setString(4, group.getDescription());
                ps.setString(5, group.getLocalKey());
                LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.primUpdate(): " + ps + "(" + group.getCreatorID() + ", " + typeID + ", " + group.getName() + ", " + group.getDescription() + ", " + group.getLocalKey() + ")");
                int rc = ps.executeUpdate();
                if (rc != 1) {
                    String errString = "Problem updating " + group;
                    LogService.log(LogService.ERROR, errString);
                    throw new GroupsException(errString);
                }
            }
            finally {
                ps.close();
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primUpdateMembers(EntityGroupImpl egi, Connection conn) throws SQLException {
        block23: {
            String groupKey = egi.getLocalKey();
            String serviceName = null;
            try {
                String isGroup;
                String memberKey;
                if (egi.hasDeletes()) {
                    ArrayList<IGroupMember> deletedGroups = new ArrayList<IGroupMember>();
                    ArrayList<IGroupMember> deletedEntities = new ArrayList<IGroupMember>();
                    Iterator deletes = egi.getRemovedMembers().values().iterator();
                    while (deletes.hasNext()) {
                        IGroupMember gm = (IGroupMember)deletes.next();
                        if (gm.isGroup()) {
                            deletedGroups.add(gm);
                            continue;
                        }
                        deletedEntities.add(gm);
                    }
                    if (!deletedGroups.isEmpty()) {
                        RDBMServices.PreparedStatement psDeleteMemberGroup = new RDBMServices.PreparedStatement(conn, RDBMEntityGroupStore.getDeleteMemberGroupSql());
                        try {
                            Iterator groups = deletedGroups.iterator();
                            while (groups.hasNext()) {
                                IEntityGroup removedGroup = (IEntityGroup)groups.next();
                                memberKey = removedGroup.getLocalKey();
                                isGroup = MEMBER_IS_GROUP;
                                serviceName = removedGroup.getServiceName().toString();
                                psDeleteMemberGroup.setString(1, groupKey);
                                psDeleteMemberGroup.setString(2, serviceName);
                                psDeleteMemberGroup.setString(3, memberKey);
                                psDeleteMemberGroup.setString(4, isGroup);
                                LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.primUpdateMembers(): " + psDeleteMemberGroup + "(" + groupKey + ", " + serviceName + ", " + memberKey + ", " + isGroup + ")");
                                psDeleteMemberGroup.executeUpdate();
                            }
                        }
                        finally {
                            psDeleteMemberGroup.close();
                        }
                    }
                    if (!deletedEntities.isEmpty()) {
                        RDBMServices.PreparedStatement psDeleteMemberEntity = new RDBMServices.PreparedStatement(conn, RDBMEntityGroupStore.getDeleteMemberEntitySql());
                        try {
                            Iterator entities = deletedEntities.iterator();
                            while (entities.hasNext()) {
                                IGroupMember removedEntity = (IGroupMember)entities.next();
                                memberKey = removedEntity.getUnderlyingEntityIdentifier().getKey();
                                isGroup = MEMBER_IS_ENTITY;
                                psDeleteMemberEntity.setString(1, groupKey);
                                psDeleteMemberEntity.setString(2, memberKey);
                                psDeleteMemberEntity.setString(3, isGroup);
                                LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.primUpdateMembers(): " + psDeleteMemberEntity + "(" + groupKey + ", " + memberKey + ", " + isGroup + ")");
                                psDeleteMemberEntity.executeUpdate();
                            }
                        }
                        finally {
                            psDeleteMemberEntity.close();
                        }
                    }
                }
                if (!egi.hasAdds()) break block23;
                RDBMServices.PreparedStatement psAdd = new RDBMServices.PreparedStatement(conn, RDBMEntityGroupStore.getInsertMemberSql());
                try {
                    Iterator adds = egi.getAddedMembers().values().iterator();
                    while (adds.hasNext()) {
                        IGroupMember addedGM = (IGroupMember)adds.next();
                        memberKey = addedGM.getKey();
                        if (addedGM.isGroup()) {
                            IEntityGroup addedGroup = (IEntityGroup)addedGM;
                            isGroup = MEMBER_IS_GROUP;
                            serviceName = addedGroup.getServiceName().toString();
                            memberKey = addedGroup.getLocalKey();
                        } else {
                            isGroup = MEMBER_IS_ENTITY;
                            serviceName = egi.getServiceName().toString();
                            memberKey = addedGM.getUnderlyingEntityIdentifier().getKey();
                        }
                        psAdd.setString(1, groupKey);
                        psAdd.setString(2, serviceName);
                        psAdd.setString(3, memberKey);
                        psAdd.setString(4, isGroup);
                        LogService.log(LogService.DEBUG, "RDBMEntityGroupStore.primUpdateMembers(): " + psAdd + "(" + groupKey + ", " + memberKey + ", " + isGroup + ")");
                        psAdd.executeUpdate();
                    }
                }
                finally {
                    psAdd.close();
                }
            }
            catch (SQLException sqle) {
                LogService.log(LogService.ERROR, sqle);
                throw sqle;
            }
        }
    }

    protected static void rollback(Connection conn) throws SQLException {
        SqlTransaction.rollback(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) throws GroupsException {
        EntityIdentifier[] r = new EntityIdentifier[]{};
        ArrayList<EntityIdentifier> ar = new ArrayList<EntityIdentifier>();
        Connection conn = null;
        RDBMServices.PreparedStatement ps = null;
        int type = EntityTypes.getEntityTypeID(leaftype);
        try {
            conn = RDBMServices.getConnection();
            switch (method) {
                case 1: {
                    ps = new RDBMServices.PreparedStatement(conn, searchGroups);
                    break;
                }
                case 2: {
                    query = query + "%";
                    ps = new RDBMServices.PreparedStatement(conn, searchGroupsPartial);
                    break;
                }
                case 3: {
                    query = "%" + query;
                    ps = new RDBMServices.PreparedStatement(conn, searchGroupsPartial);
                    break;
                }
                case 4: {
                    query = "%" + query + "%";
                    ps = new RDBMServices.PreparedStatement(conn, searchGroupsPartial);
                    break;
                }
                default: {
                    throw new GroupsException("Unknown search type");
                }
            }
            ps.clearParameters();
            ps.setInt(1, type);
            ps.setString(2, query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ar.add(new EntityIdentifier(rs.getString(1), EntityTypes.GROUP_ENTITY_TYPE));
            }
            ps.close();
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMChannelDefSearcher.searchForEntities(): " + ps);
            LogService.log(LogService.ERROR, e);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return ar.toArray(r);
    }

    protected static void setAutoCommit(Connection conn, boolean newValue) throws SQLException {
        SqlTransaction.setAutoCommit(conn, newValue);
    }

    public void setGroupService(IGroupService newGroupService) {
        this.groupService = newGroupService;
    }

    public static synchronized RDBMEntityGroupStore singleton() throws GroupsException {
        if (singleton == null) {
            singleton = new RDBMEntityGroupStore();
        }
        return singleton;
    }

    /*
     * Loose catch block
     */
    public void update(IEntityGroup group) throws GroupsException {
        Connection conn = null;
        boolean exists = this.existsInDatabase(group);
        conn = RDBMServices.getConnection();
        RDBMEntityGroupStore.setAutoCommit(conn, false);
        try {
            if (exists) {
                this.primUpdate(group, conn);
            } else {
                this.primAdd(group, conn);
            }
            this.primUpdateMembers((EntityGroupImpl)group, conn);
            RDBMEntityGroupStore.commit(conn);
        }
        catch (Exception ex) {
            RDBMEntityGroupStore.rollback(conn);
            throw new GroupsException("Problem updating " + this + ex);
        }
        Object var6_6 = null;
        try {
            RDBMEntityGroupStore.setAutoCommit(conn, true);
        }
        catch (SQLException sqle) {
            throw new GroupsException(sqle.getMessage());
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        {
            catch (SQLException sqlex) {
                throw new GroupsException(sqlex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                RDBMEntityGroupStore.setAutoCommit(conn, true);
            }
            catch (SQLException sqle) {
                try {}
                catch (Throwable throwable2) {
                    RDBMServices.releaseConnection(conn);
                    throw throwable2;
                }
                throw new GroupsException(sqle.getMessage());
            }
            RDBMServices.releaseConnection(conn);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public void updateMembers(IEntityGroup eg) throws GroupsException {
        block13: {
            Connection conn = null;
            EntityGroupImpl egi = (EntityGroupImpl)eg;
            if (!egi.isDirty()) break block13;
            conn = RDBMServices.getConnection();
            RDBMEntityGroupStore.setAutoCommit(conn, false);
            try {
                this.primUpdateMembers(egi, conn);
                RDBMEntityGroupStore.commit(conn);
            }
            catch (SQLException sqle) {
                RDBMEntityGroupStore.rollback(conn);
                throw new GroupsException("Problem updating memberships for " + egi + " " + sqle.getMessage());
            }
            Object var6_6 = null;
            try {
                RDBMEntityGroupStore.setAutoCommit(conn, true);
            }
            catch (SQLException sqle) {
                throw new GroupsException(sqle.getMessage());
            }
            finally {
                RDBMServices.releaseConnection(conn);
            }
            {
                catch (SQLException sqlex) {
                    throw new GroupsException(sqlex.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    RDBMEntityGroupStore.setAutoCommit(conn, true);
                }
                catch (SQLException sqle) {
                    try {}
                    catch (Throwable throwable2) {
                        RDBMServices.releaseConnection(conn);
                        throw throwable2;
                    }
                    throw new GroupsException(sqle.getMessage());
                }
                RDBMServices.releaseConnection(conn);
                throw throwable;
            }
        }
    }

    static {
        GROUP_TABLE = "UP_GROUP";
        GROUP_TABLE_ALIAS = "T1";
        GROUP_ID_COLUMN = "GROUP_ID";
        GROUP_CREATOR_COLUMN = "CREATOR_ID";
        GROUP_TYPE_COLUMN = "ENTITY_TYPE_ID";
        GROUP_NAME_COLUMN = "GROUP_NAME";
        GROUP_DESCRIPTION_COLUMN = "DESCRIPTION";
        MEMBER_TABLE = "UP_GROUP_MEMBERSHIP";
        MEMBER_TABLE_ALIAS = "T2";
        MEMBER_GROUP_ID_COLUMN = "GROUP_ID";
        MEMBER_MEMBER_SERVICE_COLUMN = "MEMBER_SERVICE";
        MEMBER_MEMBER_KEY_COLUMN = "MEMBER_KEY";
        MEMBER_IS_GROUP_COLUMN = "MEMBER_IS_GROUP";
        MEMBER_IS_ENTITY = "F";
        MEMBER_IS_GROUP = "T";
        searchGroupsPartial = "SELECT " + GROUP_ID_COLUMN + " FROM " + GROUP_TABLE + " WHERE " + GROUP_TYPE_COLUMN + "=? AND " + GROUP_NAME_COLUMN + " LIKE ?";
        searchGroups = "SELECT " + GROUP_ID_COLUMN + " FROM " + GROUP_TABLE + " WHERE " + GROUP_TYPE_COLUMN + "=? AND " + GROUP_NAME_COLUMN + " = ?";
    }
}

