/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.EntityImpl;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityStore;
import org.jasig.portal.services.LogService;

public class RDBMEntityStore
implements IEntityStore {
    private static IEntityStore singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator findEntitiesForGroup(IEntityGroup group) throws GroupsException {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        Connection conn = null;
        String groupID = group.getLocalKey();
        Class cls = group.getLeafType();
        try {
            conn = RDBMServices.getConnection();
            Statement stmnt = conn.createStatement();
            try {
                String query = "SELECT MEMBER_KEY FROM UP_GROUP_MEMBERSHIP WHERE GROUP_ID = '" + groupID + "'" + " AND MEMBER_IS_GROUP = 'F' ";
                ResultSet rs = stmnt.executeQuery(query);
                try {
                    while (rs.next()) {
                        String key = rs.getString(1);
                        IEntity e = this.newInstance(key, cls);
                        entities.add(e);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw new GroupsException("Problem retrieving Entities for Group: " + sqle.getMessage());
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return entities.iterator();
    }

    public IEntity newInstance(String key) throws GroupsException {
        return this.newInstance(key, null);
    }

    public IEntity newInstance(String key, Class type) throws GroupsException {
        if (EntityTypes.getEntityTypeID(type) == null) {
            throw new GroupsException("Invalid group type: " + type);
        }
        return new EntityImpl(key, type);
    }

    public static synchronized IEntityStore singleton() {
        if (singleton == null) {
            singleton = new RDBMEntityStore();
        }
        return singleton;
    }
}

