/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.groups.ComponentGroupServiceDescriptor;
import org.jasig.portal.groups.CompositeEntityIdentifier;
import org.jasig.portal.groups.GroupServiceConfiguration;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IComponentGroupService;
import org.jasig.portal.groups.IComponentGroupServiceFactory;
import org.jasig.portal.groups.ICompositeGroupService;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityStore;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.IGroupService;
import org.jasig.portal.groups.IIndividualGroupService;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.groups.ReferenceComponentGroupService;
import org.jasig.portal.services.EntityCachingService;
import org.jasig.portal.services.GroupService;

public class ReferenceCompositeGroupService
extends ReferenceComponentGroupService
implements ICompositeGroupService {
    protected IEntityStore entityFactory = null;
    protected IIndividualGroupService defaultService;

    public Iterator findContainingGroups(IGroupMember gm) throws GroupsException {
        ArrayList<IEntityGroup> allGroups = new ArrayList<IEntityGroup>();
        IIndividualGroupService service = null;
        Iterator services = this.getComponentServices().values().iterator();
        while (services.hasNext()) {
            service = (IIndividualGroupService)services.next();
            if (!gm.isEntity() && !service.isEditable() && this.getComponentService(((IEntityGroup)gm).getServiceName()) != service) continue;
            Iterator groups = service.findContainingGroups(gm);
            while (groups.hasNext()) {
                allGroups.add((IEntityGroup)groups.next());
            }
        }
        return allGroups.iterator();
    }

    public IEntityGroup findGroup(String key) throws GroupsException {
        CompositeEntityIdentifier ent = this.newCompositeEntityIdentifier(key);
        IIndividualGroupService service = this.getComponentService(ent);
        return service == null ? null : service.findGroup(ent);
    }

    public ILockableEntityGroup findGroupWithLock(String key, String lockOwner) throws GroupsException {
        CompositeEntityIdentifier ent = this.newCompositeEntityIdentifier(key);
        IIndividualGroupService service = this.getComponentService(ent);
        return service == null ? null : service.findGroupWithLock(ent.getLocalKey(), lockOwner);
    }

    protected IIndividualGroupService getComponentService(Name serviceName) {
        return (IIndividualGroupService)this.getComponentServices().get(serviceName);
    }

    protected IIndividualGroupService getComponentService(CompositeEntityIdentifier entId) {
        return this.getComponentService(entId.getServiceName());
    }

    protected IIndividualGroupService getDefaultService() {
        return this.defaultService;
    }

    public IEntity getEntity(String key, Class type) throws GroupsException {
        return this.getEntity(key, type, null);
    }

    public IEntity getEntity(String key, Class type, String svcName) throws GroupsException {
        IIndividualGroupService svc = null;
        if (svcName == null) {
            svc = this.getDefaultService();
        } else {
            try {
                Name n = GroupService.parseServiceName(svcName);
                svc = this.getComponentService(n);
            }
            catch (InvalidNameException ine) {
                throw new GroupsException("Invalid service name.");
            }
        }
        return svc == null ? null : svc.getEntity(key, type);
    }

    public IGroupMember getGroupMember(String key, Class type) throws GroupsException {
        IGroupMember gm = null;
        gm = type == EntityTypes.GROUP_ENTITY_TYPE ? this.findGroup(key) : this.getEntity(key, type);
        return gm;
    }

    public IGroupMember getGroupMember(EntityIdentifier underlyingEntityIdentifier) throws GroupsException {
        return this.getGroupMember(underlyingEntityIdentifier.getKey(), underlyingEntityIdentifier.getType());
    }

    protected void initializeComponentServices() throws GroupsException {
        Name leafServiceName = null;
        try {
            GroupServiceConfiguration cfg = GroupServiceConfiguration.getConfiguration();
            List services = cfg.getServiceDescriptors();
            Iterator it = services.iterator();
            while (it.hasNext()) {
                ComponentGroupServiceDescriptor descriptor = (ComponentGroupServiceDescriptor)it.next();
                String factoryName = descriptor.getServiceFactoryName();
                IComponentGroupServiceFactory factory = (IComponentGroupServiceFactory)Class.forName(factoryName).newInstance();
                IComponentGroupService service = factory.newGroupService(descriptor);
                if (service.isLeafService()) {
                    leafServiceName = GroupService.parseServiceName(descriptor.getName());
                    service.setServiceName(leafServiceName);
                    this.getComponentServices().put(leafServiceName, service);
                    continue;
                }
                Map componentMap = service.getComponentServices();
                Iterator components = componentMap.values().iterator();
                while (components.hasNext()) {
                    IIndividualGroupService leafService = (IIndividualGroupService)components.next();
                    leafServiceName = leafService.getServiceName();
                    leafServiceName.add(0, descriptor.getName());
                    this.getComponentServices().put(leafServiceName, leafService);
                }
            }
            Name defaultServiceName = GroupService.parseServiceName(cfg.getDefaultService());
            this.defaultService = this.getComponentService(defaultServiceName);
        }
        catch (Exception ex) {
            throw new GroupsException("Problem initializing component services: " + ex.getMessage());
        }
    }

    protected CompositeEntityIdentifier newCompositeEntityIdentifier(String key) throws GroupsException {
        return new CompositeEntityIdentifier(key, EntityTypes.GROUP_ENTITY_TYPE);
    }

    public IEntityGroup newGroup(Class type, Name serviceName) throws GroupsException {
        return this.getComponentService(serviceName).newGroup(type);
    }

    protected IEntityGroup primFindGroup(String key) throws GroupsException {
        CompositeEntityIdentifier ent = this.newCompositeEntityIdentifier(key);
        IIndividualGroupService service = this.getComponentService(ent);
        return service == null ? null : service.findGroup(ent);
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type) throws GroupsException {
        HashSet<EntityIdentifier> allIds = new HashSet<EntityIdentifier>();
        Iterator services = this.getComponentServices().values().iterator();
        while (services.hasNext()) {
            IGroupService service = (IGroupService)services.next();
            EntityIdentifier[] ids = service.searchForEntities(query, method, type);
            for (int i = 0; i < ids.length; ++i) {
                allIds.add(ids[i]);
            }
        }
        return allIds.toArray(new EntityIdentifier[allIds.size()]);
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type, IEntityGroup ancestor) throws GroupsException {
        HashSet<EntityIdentifier> allIds = new HashSet<EntityIdentifier>();
        Iterator services = this.getComponentServices().values().iterator();
        while (services.hasNext()) {
            IGroupService service = (IGroupService)services.next();
            EntityIdentifier[] ids = service.searchForEntities(query, method, type, ancestor);
            for (int i = 0; i < ids.length; ++i) {
                allIds.add(ids[i]);
            }
        }
        return allIds.toArray(new EntityIdentifier[allIds.size()]);
    }

    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) throws GroupsException {
        HashSet<CompositeEntityIdentifier> allIds = new HashSet<CompositeEntityIdentifier>();
        Iterator services = this.getComponentServices().values().iterator();
        while (services.hasNext()) {
            IIndividualGroupService service = (IIndividualGroupService)services.next();
            EntityIdentifier[] ids = service.searchForGroups(query, method, leaftype);
            for (int i = 0; i < ids.length; ++i) {
                try {
                    CompositeEntityIdentifier cei = new CompositeEntityIdentifier(ids[i].getKey(), ids[i].getType());
                    cei.setServiceName(service.getServiceName());
                    allIds.add(cei);
                    continue;
                }
                catch (InvalidNameException ine) {
                    // empty catch block
                }
            }
        }
        return allIds.toArray(new EntityIdentifier[allIds.size()]);
    }

    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype, IEntityGroup ancestor) throws GroupsException {
        HashSet<CompositeEntityIdentifier> allIds = new HashSet<CompositeEntityIdentifier>();
        Iterator services = this.getComponentServices().values().iterator();
        while (services.hasNext()) {
            IIndividualGroupService service = (IIndividualGroupService)services.next();
            EntityIdentifier[] ids = service.searchForGroups(query, method, leaftype, ancestor);
            for (int i = 0; i < ids.length; ++i) {
                try {
                    CompositeEntityIdentifier cei = new CompositeEntityIdentifier(ids[i].getKey(), ids[i].getType());
                    cei.setServiceName(service.getServiceName());
                    allIds.add(cei);
                    continue;
                }
                catch (InvalidNameException ine) {
                    // empty catch block
                }
            }
        }
        return allIds.toArray(new EntityIdentifier[allIds.size()]);
    }

    protected void setComponentServices(Map newComponentServices) {
        this.componentServices = newComponentServices;
    }

    protected void cacheAdd(IGroupMember gm) throws GroupsException {
        try {
            EntityCachingService.instance().add(gm);
        }
        catch (CachingException ce) {
            throw new GroupsException("Problem adding group member " + gm.getKey() + " to cache: " + ce.getMessage());
        }
    }

    protected void cacheRemove(IGroupMember gm) throws GroupsException {
        try {
            EntityCachingService.instance().remove(gm.getEntityIdentifier());
        }
        catch (CachingException ce) {
            throw new GroupsException("Problem removing group member " + gm.getKey() + " from cache: " + ce.getMessage());
        }
    }

    protected void cacheUpdate(IGroupMember gm) throws GroupsException {
        try {
            EntityCachingService.instance().update(gm);
        }
        catch (CachingException ce) {
            throw new GroupsException("Problem updating group member " + gm.getKey() + " in cache: " + ce.getMessage());
        }
    }

    protected IEntity getEntityFromCache(String key) throws CachingException {
        return (IEntity)EntityCachingService.instance().get(EntityTypes.LEAF_ENTITY_TYPE, key);
    }
}

